/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.ToolsConfiguration;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationManagerAccessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightConfigurationManager {
    private static DLightConfigurationManager instance;
    private String selectedConfigurationName = null;

    private DLightConfigurationManager() {
    }

    private final FileObject getToolsFSRoot() {
        FileObject fileObject = FileUtil.getConfigRoot();
        return fileObject.getFileObject(this.getToolsFSRootPath());
    }

    private final String getToolsFSRootPath() {
        return "DLight/Configurations";
    }

    void selectConfiguration(String string) {
        this.selectedConfigurationName = string;
    }

    boolean canDelete(String string) {
        DLightConfiguration dLightConfiguration = this.getConfigurationByName(string);
        return dLightConfiguration != null && !dLightConfiguration.isSystem();
    }

    boolean removeConfiguration(String string) {
        FileObject fileObject = this.getToolsFSRoot();
        if (fileObject == null) {
            System.err.println("Configurations folder is NULL which should not be");
            return false;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return false;
        }
        Object var4_4 = null;
        for (FileObject fileObject2 : fileObjectArray) {
            if (!fileObject2.getName().equals(string)) continue;
            try {
                fileObject2.delete();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    private String commaSeparatedList(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    DLightConfiguration registerConfigurationAsACopy(DLightConfiguration dLightConfiguration, String string, String string2, String string3, List<String> list, String string4, List<String> list2) {
        FileObject fileObject = this.getToolsFSRoot();
        try {
            FileObject fileObject2 = fileObject.createFolder(string);
            fileObject2.setAttribute("displayedName", (Object)string2);
            fileObject2.setAttribute("category", (Object)string3);
            fileObject2.setAttribute("platforms", (Object)this.commaSeparatedList(list));
            fileObject2.setAttribute("collector.providers", (Object)string4);
            fileObject2.setAttribute("indicator.providers", (Object)this.commaSeparatedList(list2));
            fileObject2.createFolder("KnownToolsConfigurationProviders");
            FileObject fileObject3 = dLightConfiguration.getRootFolder();
            FileObject fileObject4 = fileObject3.getFileObject("ConfigurationOptions");
            if (fileObject4 != null) {
                FileObject[] fileObjectArray = fileObject4.getChildren();
                FileObject fileObject5 = null;
                if (fileObjectArray != null && fileObjectArray.length > 0) {
                    fileObject5 = fileObject2.createFolder(fileObject4.getName());
                }
                for (FileObject fileObject6 : fileObjectArray) {
                    if (fileObject6.isFolder()) continue;
                    FileUtil.copyFile((FileObject)fileObject6, (FileObject)fileObject5, (String)fileObject6.getName());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return this.getConfigurationByName(string);
    }

    DLightConfiguration registerConfiguration(String string, String string2, String string3, List<String> list, String string4, List<String> list2) {
        FileObject fileObject = this.getToolsFSRoot();
        try {
            FileObject fileObject2 = fileObject.createFolder(string);
            fileObject2.setAttribute("displayedName", (Object)string2);
            fileObject2.setAttribute("category", (Object)string3);
            fileObject2.setAttribute("platforms", (Object)this.commaSeparatedList(list));
            fileObject2.setAttribute("collector.providers", (Object)string4);
            fileObject2.setAttribute("indicator.providers", (Object)this.commaSeparatedList(list2));
            fileObject2.createFolder("KnownToolsConfigurationProviders");
        }
        catch (IOException iOException) {
            return null;
        }
        return this.getConfigurationByName(string);
    }

    public Collection<DLightConfiguration> getConfigurationsByCategoryName(String string) {
        ArrayList<DLightConfiguration> arrayList = new ArrayList<DLightConfiguration>(this.getDLightConfigurations());
        ArrayList<DLightConfiguration> arrayList2 = new ArrayList<DLightConfiguration>();
        for (DLightConfiguration dLightConfiguration : arrayList) {
            if (string == null || dLightConfiguration.getCategoryName() == null || !dLightConfiguration.getCategoryName().equals(string)) continue;
            arrayList2.add(dLightConfiguration);
        }
        return arrayList2;
    }

    public DLightConfiguration getConfigurationByName(String string) {
        List<DLightConfiguration> list = this.getDLightConfigurations();
        for (DLightConfiguration dLightConfiguration : list) {
            if (!dLightConfiguration.getConfigurationName().equals(string)) continue;
            return dLightConfiguration;
        }
        return null;
    }

    List<DLightConfiguration> getDLightConfigurations() {
        ArrayList<DLightConfiguration> arrayList = new ArrayList<DLightConfiguration>();
        FileObject fileObject = this.getToolsFSRoot();
        if (fileObject == null) {
            System.err.println("Configurations folder is NULL which should not be");
            return arrayList;
        }
        List list = Arrays.asList(fileObject.getChildren());
        if (list.isEmpty()) {
            return arrayList;
        }
        list = FileUtil.getOrder(list, (boolean)false);
        for (FileObject fileObject2 : list) {
            arrayList.add(DLightConfiguration.create(fileObject2));
        }
        return arrayList;
    }

    DLightConfiguration getSelectedDLightConfiguration() {
        if (this.selectedConfigurationName != null) {
            return this.getConfigurationByName(this.selectedConfigurationName);
        }
        List<DLightConfiguration> list = this.getDLightConfigurations();
        if (list == null || list.size() == 0) {
            return DLightConfiguration.createDefault();
        }
        return list.get(0);
    }

    public final DLightConfiguration getDefaultConfiguration() {
        return DLightConfiguration.createDefault();
    }

    public static final synchronized DLightConfigurationManager getInstance() {
        if (instance == null) {
            instance = new DLightConfigurationManager();
        }
        return instance;
    }

    final boolean registerTool(String string, String string2, boolean bl) {
        DLightConfiguration dLightConfiguration = this.getConfigurationByName(string);
        DLightConfiguration dLightConfiguration2 = this.getDefaultConfiguration();
        ToolsConfiguration toolsConfiguration = dLightConfiguration.getToolsConfiguration();
        return toolsConfiguration.register(dLightConfiguration2.getToolsConfiguration().getFileObject(string2), bl);
    }

    final boolean registerTool(String string, DLightTool dLightTool) {
        DLightConfiguration dLightConfiguration = this.getConfigurationByName(string);
        DLightConfiguration dLightConfiguration2 = this.getDefaultConfiguration();
        ToolsConfiguration toolsConfiguration = dLightConfiguration.getToolsConfiguration();
        return toolsConfiguration.register(dLightConfiguration2.getToolsConfiguration().getFileObject(dLightTool.getID()), dLightTool.isEnabled());
    }

    final boolean deleteTool(String string, DLightTool dLightTool) {
        return this.getConfigurationByName(string).getToolsConfiguration().remove(dLightTool.getID());
    }

    static {
        DLightConfigurationManagerAccessor.setDefault(new DLightConfigurationManagerAccessorImpl());
        instance = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DLightConfigurationManagerAccessorImpl
    extends DLightConfigurationManagerAccessor {
        private DLightConfigurationManagerAccessorImpl() {
        }

        @Override
        public DLightConfiguration getDefaultConfiguration(DLightConfigurationManager dLightConfigurationManager) {
            return dLightConfigurationManager.getDefaultConfiguration();
        }

        @Override
        public List<DLightConfiguration> getDLightConfigurations(DLightConfigurationManager dLightConfigurationManager) {
            return dLightConfigurationManager.getDLightConfigurations();
        }

        @Override
        public boolean registerTool(DLightConfigurationManager dLightConfigurationManager, String string, DLightTool dLightTool) {
            return dLightConfigurationManager.registerTool(string, dLightTool);
        }

        @Override
        public boolean deleteTool(DLightConfigurationManager dLightConfigurationManager, String string, DLightTool dLightTool) {
            return dLightConfigurationManager.deleteTool(string, dLightTool);
        }

        @Override
        public DLightConfiguration registerConfiguration(DLightConfigurationManager dLightConfigurationManager, String string, String string2, String string3, List<String> list, String string4, List<String> list2) {
            return dLightConfigurationManager.registerConfiguration(string, string2, string3, list, string4, list2);
        }

        @Override
        public DLightConfiguration registerConfigurationAsACopy(DLightConfigurationManager dLightConfigurationManager, DLightConfiguration dLightConfiguration, String string, String string2, String string3, List<String> list, String string4, List<String> list2) {
            return dLightConfigurationManager.registerConfigurationAsACopy(dLightConfiguration, string, string2, string3, list, string4, list2);
        }

        @Override
        public boolean removeConfiguration(String string) {
            return DLightConfigurationManager.getInstance().removeConfiguration(string);
        }

        @Override
        public boolean canRemoveConfiguration(String string) {
            return DLightConfigurationManager.getInstance().canDelete(string);
        }

        @Override
        public boolean registerTool(String string, String string2, boolean bl) {
            return DLightConfigurationManager.getInstance().registerTool(string, string2, bl);
        }
    }
}

