/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultVersionDescriptor
implements VersionDescriptor {
    private static final VersionDescriptor FOREVER_COMPATIBLE = new VersionDescriptor(){

        @Override
        public boolean isCompatibleWith(VersionDescriptor versionDescriptor) {
            return true;
        }

        @Override
        public boolean isCompatibleWith(Collection<String> collection) {
            return true;
        }

        @Override
        public Set<String> getPreliminaryConvertMessages(DesignComponent designComponent, Collection<String> collection, Collection<String> collection2) {
            return null;
        }

        @Override
        public void convertComponent(DesignComponent designComponent, Collection<String> collection, Collection<String> collection2) {
        }
    };
    private Kind kind;
    private String[] abilities;

    public DefaultVersionDescriptor(Kind kind, String[] stringArray) {
        assert (kind != null && stringArray != null);
        this.kind = kind;
        this.abilities = stringArray;
    }

    public final boolean isCompatibleWith(String[] stringArray) {
        if (this.kind == Kind.ALL) {
            return Arrays.asList(stringArray).containsAll(Arrays.asList(this.abilities));
        }
        List<String> list = Arrays.asList(stringArray);
        for (String string : this.abilities) {
            if (!list.contains(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getPreliminaryConvertMessages(DesignComponent designComponent, Collection<String> collection, Collection<String> collection2) {
        if (this.isCompatibleWith(collection2)) {
            return null;
        }
        String string = InfoPresenter.getHtmlDisplayName(designComponent);
        if (string == null) {
            string = "#" + designComponent.getComponentID();
        }
        return Collections.singleton(NbBundle.getMessage(DefaultVersionDescriptor.class, (String)"MSG_Convertion_RemoveComponent", (Object)string));
    }

    public static VersionDescriptor createForeverCompatibleVersionDescriptor() {
        return FOREVER_COMPATIBLE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        ANY,
        ALL;

    }
}

