/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DynamicPresenter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.model.PresenterListener;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PresenterEventManager
implements PresenterEvent {
    private ArrayList<DependencyItem> dependencies = new ArrayList();
    private HashSet<PresenterListener> changed;
    private List<PresenterListener> topology;
    private Map<PresenterListener, HashSet<PresenterListener>> dependencyMap;

    PresenterEventManager() {
    }

    void firePresenterChanged(PresenterListener presenterListener) {
        this.changed.add(presenterListener);
    }

    void addPresenterListener(DesignComponent designComponent, Class<? extends Presenter> clazz, PresenterListener presenterListener) {
        this.dependencies.add(new DependencyItem(designComponent, clazz, presenterListener));
        this.topology = null;
    }

    void removePresenterListener(DesignComponent designComponent, Class<? extends Presenter> clazz, PresenterListener presenterListener) {
        this.dependencies.remove(new DependencyItem(designComponent, clazz, presenterListener));
        this.topology = null;
    }

    void removeAllPresenterListeners(PresenterListener presenterListener) {
        Iterator<DependencyItem> iterator = this.dependencies.iterator();
        while (iterator.hasNext()) {
            DependencyItem dependencyItem = iterator.next();
            if (dependencyItem.listener != presenterListener) continue;
            iterator.remove();
            this.topology = null;
        }
    }

    void prepare(boolean bl) {
        this.changed = new HashSet(100);
        if (bl) {
            this.topology = null;
        }
    }

    void execute() {
        if (this.topology == null) {
            this.createTopology();
        }
        List<PresenterListener> list = this.topology;
        Map<PresenterListener, HashSet<PresenterListener>> map = this.dependencyMap;
        HashSet<PresenterListener> hashSet = new HashSet<PresenterListener>(100);
        for (PresenterListener presenterListener : this.changed) {
            if (list.contains(presenterListener)) {
                hashSet.add(presenterListener);
                continue;
            }
            presenterListener.presenterChanged(this);
        }
        for (PresenterListener presenterListener : list) {
            HashSet<PresenterListener> hashSet2;
            if (hashSet.contains(presenterListener)) {
                presenterListener.presenterChanged(this);
            }
            if (!this.changed.contains(presenterListener) || (hashSet2 = map.get(presenterListener)) == null) continue;
            for (PresenterListener presenterListener2 : hashSet2) {
                hashSet.add(presenterListener2);
            }
        }
    }

    private void createTopology() {
        HashSet hashSet = new HashSet();
        HashMap<PresenterListener, HashSet<PresenterListener>> hashMap = new HashMap<PresenterListener, HashSet<PresenterListener>>();
        for (DependencyItem dependencyItem : this.dependencies) {
            dependencyItem.setupTopology(hashSet, hashMap);
        }
        try {
            this.topology = Utilities.topologicalSort(hashSet, hashMap);
            this.dependencyMap = hashMap;
        }
        catch (TopologicalSortException topologicalSortException) {
            Debug.warning(new Object[]{topologicalSortException});
            System.err.println("TopologicalSortException: Topological Sets:" + Arrays.toString(topologicalSortException.topologicalSets()));
            System.err.println("TopologicalSortException: Unsortable Set:" + Arrays.toString(topologicalSortException.unsortableSets()));
            this.topology = Collections.emptyList();
            this.dependencyMap = Collections.emptyMap();
        }
    }

    @Override
    public boolean isPresenterChanged(DesignComponent designComponent, Class<? extends Presenter> clazz) {
        assert (designComponent != null && clazz != null);
        for (Presenter presenter : designComponent.getPresenters(clazz)) {
            if (!(presenter instanceof DynamicPresenter) || !this.changed.contains(((DynamicPresenter)presenter).getPresenterListener())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DependencyItem {
        private DesignComponent component;
        private Class<? extends Presenter> presenterClass;
        private PresenterListener listener;

        public DependencyItem(DesignComponent designComponent, Class<? extends Presenter> clazz, PresenterListener presenterListener) {
            assert (designComponent != null && clazz != null && presenterListener != null);
            this.component = designComponent;
            this.presenterClass = clazz;
            this.listener = presenterListener;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DependencyItem dependencyItem = (DependencyItem)object;
            if (this.component != dependencyItem.component) {
                return false;
            }
            if (!this.presenterClass.equals(dependencyItem.presenterClass)) {
                return false;
            }
            return this.listener == dependencyItem.listener;
        }

        public int hashCode() {
            int n = this.component != null ? this.component.hashCode() : 0;
            n = 29 * n + (this.presenterClass != null ? this.presenterClass.hashCode() : 0);
            n = 29 * n + (this.listener != null ? this.listener.hashCode() : 0);
            return n;
        }

        private void setupTopology(HashSet<PresenterListener> hashSet, HashMap<PresenterListener, HashSet<PresenterListener>> hashMap) {
            Presenter presenter = this.component.getPresenter(this.presenterClass);
            if (!(presenter instanceof DynamicPresenter)) {
                return;
            }
            PresenterListener presenterListener = ((DynamicPresenter)presenter).getPresenterListener();
            if (presenterListener == this.listener) {
                return;
            }
            hashSet.add(presenterListener);
            hashSet.add(this.listener);
            HashSet<PresenterListener> hashSet2 = hashMap.get(presenterListener);
            if (hashSet2 == null) {
                hashSet2 = new HashSet();
                hashMap.put(presenterListener, hashSet2);
            }
            hashSet2.add(this.listener);
        }
    }
}

