/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.css.editor.CssEditorSupport;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.model.BorderModel;
import org.netbeans.modules.css.visual.model.PropertyData;
import org.netbeans.modules.css.visual.ui.BorderWidthField;
import org.netbeans.modules.css.visual.ui.ColorSelectionField;
import org.netbeans.modules.css.visual.ui.FlexibleGridLayout;
import org.netbeans.modules.css.visual.ui.StyleEditor;
import org.openide.util.NbBundle;

public class BorderStyleEditor
extends StyleEditor {
    BorderDataTable borderDataTable = new BorderDataTable();
    private JPanel borderPanel;

    public BorderStyleEditor() {
        this.setName("borderStyleEditor");
        this.setDisplayName(NbBundle.getMessage(BorderStyleEditor.class, (String)"BORDER_EDITOR_DISPNAME"));
        this.initComponents();
        this.borderPanel.add((Component)this.borderDataTable, "Center");
    }

    protected void setCssPropertyValues(CssRuleContent cssRuleContent) {
        this.removeCssPropertyChangeListener();
        this.borderDataTable.setCssPropertyValues(cssRuleContent);
        this.setCssPropertyChangeListener(cssRuleContent);
    }

    private void initComponents() {
        this.borderPanel = new JPanel();
        this.setLayout(new BorderLayout(0, 5));
        this.borderPanel.setLayout(new BorderLayout());
        this.add((Component)this.borderPanel, "North");
    }

    class BorderDataTable
    extends JPanel {
        CssRuleContent cssStyleData;
        BorderModel borderModel = new BorderModel();
        JComboBox allStyleCombo;
        BorderWidthField allWidthField;
        ColorSelectionField allColorField;
        JComboBox topStyleCombo;
        BorderWidthField topWidthField;
        ColorSelectionField topColorField;
        JComboBox bottomStyleCombo;
        BorderWidthField bottomWidthField;
        ColorSelectionField bottomColorField;
        JComboBox leftStyleCombo;
        BorderWidthField leftWidthField;
        ColorSelectionField leftColorField;
        JComboBox rightStyleCombo;
        BorderWidthField rightWidthField;
        ColorSelectionField rightColorField;

        public BorderDataTable() {
            this.setLayout(new FlexibleGridLayout(6, 4, 5, 5));
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getHeight() + 10 > 25 ? fontMetrics.getHeight() + 10 : 25;
            this.initCells(n);
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE_TABLE_ACCESS_NAME"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE_TABLE_ACCESS_DESC"));
        }

        protected void setCssPropertyValues(CssRuleContent cssRuleContent) {
            BorderStyleEditor.this.removeCssPropertyChangeListener();
            String string = cssRuleContent.getProperty("border-top-style");
            String string2 = cssRuleContent.getProperty("border-bottom-style");
            String string3 = cssRuleContent.getProperty("border-left-style");
            String string4 = cssRuleContent.getProperty("border-right-style");
            if (string != null && string2 != null && string3 != null && string4 != null && string.equals(string2) && string.equals(string3) && string.equals(string4)) {
                this.allStyleCombo.setSelectedItem(string);
            } else {
                this.allStyleCombo.setSelectedIndex(0);
                if (string != null) {
                    this.topStyleCombo.setSelectedItem(string);
                } else {
                    this.topStyleCombo.setSelectedIndex(0);
                }
                if (string2 != null) {
                    this.bottomStyleCombo.setSelectedItem(string2);
                } else {
                    this.bottomStyleCombo.setSelectedIndex(0);
                }
                if (string3 != null) {
                    this.leftStyleCombo.setSelectedItem(string3);
                } else {
                    this.leftStyleCombo.setSelectedIndex(0);
                }
                if (string4 != null) {
                    this.rightStyleCombo.setSelectedItem(string4);
                } else {
                    this.rightStyleCombo.setSelectedIndex(0);
                }
            }
            String string5 = cssRuleContent.getProperty("border-top-width");
            String string6 = cssRuleContent.getProperty("border-bottom-width");
            String string7 = cssRuleContent.getProperty("border-left-width");
            String string8 = cssRuleContent.getProperty("border-right-width");
            if (string5 != null && string6 != null && string7 != null && string8 != null && string5.equals(string6) && string5.equals(string7) && string5.equals(string8)) {
                this.allWidthField.setWidthString(string5);
            } else {
                this.allWidthField.setWidthString(null);
                this.topWidthField.setWidthString(string5);
                this.bottomWidthField.setWidthString(string6);
                this.leftWidthField.setWidthString(string7);
                this.rightWidthField.setWidthString(string8);
            }
            String string9 = cssRuleContent.getProperty("border-top-color");
            String string10 = cssRuleContent.getProperty("border-bottom-color");
            String string11 = cssRuleContent.getProperty("border-left-color");
            String string12 = cssRuleContent.getProperty("border-right-color");
            if (string9 != null && string10 != null && string11 != null && string12 != null && string9.equals(string10) && string9.equals(string11) && string9.equals(string12)) {
                this.allColorField.setColorString(string9);
            } else {
                this.allColorField.setColorString(null);
                this.topColorField.setColorString(string9);
                this.bottomColorField.setColorString(string10);
                this.leftColorField.setColorString(string11);
                this.rightColorField.setColorString(string12);
            }
            BorderStyleEditor.this.borderDataTable.validate();
            BorderStyleEditor.this.borderDataTable.repaint();
            BorderStyleEditor.this.setCssPropertyChangeListener(cssRuleContent);
        }

        public void initCells(int n) {
            JLabel jLabel = new JLabel("");
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_STYLE")));
            JPanel jPanel2 = new JPanel();
            jPanel2.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_WIDTH")));
            JPanel jPanel3 = new JPanel();
            jPanel3.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_COLOR")));
            JPanel jPanel4 = new JPanel();
            jPanel4.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_ALL")));
            JPanel jPanel5 = new JPanel();
            jPanel5.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_TOP")));
            JPanel jPanel6 = new JPanel();
            jPanel6.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_BOTTOM")));
            JPanel jPanel7 = new JPanel();
            jPanel7.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_LEFT")));
            JPanel jPanel8 = new JPanel();
            jPanel8.add(new JLabel(NbBundle.getMessage(BorderDataTable.class, (String)"BORDER_RIGHT")));
            this.allStyleCombo = new JComboBox();
            this.allStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.allStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.allStyleCombo.setModel(this.borderModel.getStyleList());
            this.allStyleCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    CssEditorSupport.getDefault().firstAggregatedEventWillFire();
                    BorderDataTable.this.topStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                    BorderDataTable.this.bottomStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                    BorderDataTable.this.leftStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                    BorderDataTable.this.rightStyleCombo.setSelectedIndex(BorderDataTable.this.allStyleCombo.getSelectedIndex());
                    CssEditorSupport.getDefault().lastAggregatedEventFired();
                }
            });
            this.allWidthField = new BorderWidthField();
            this.allWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.allWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"ALL_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.allWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CssEditorSupport.getDefault().firstAggregatedEventWillFire();
                    BorderDataTable.this.topWidthField.setWidthString(propertyChangeEvent.getNewValue().toString());
                    BorderDataTable.this.bottomWidthField.setWidthString(propertyChangeEvent.getNewValue().toString());
                    BorderDataTable.this.leftWidthField.setWidthString(propertyChangeEvent.getNewValue().toString());
                    BorderDataTable.this.rightWidthField.setWidthString(propertyChangeEvent.getNewValue().toString());
                    CssEditorSupport.getDefault().lastAggregatedEventFired();
                }
            });
            this.allColorField = new ColorSelectionField();
            this.allColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CssEditorSupport.getDefault().firstAggregatedEventWillFire();
                    BorderDataTable.this.topColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                    BorderDataTable.this.bottomColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                    BorderDataTable.this.leftColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                    BorderDataTable.this.rightColorField.setColorString(BorderDataTable.this.allColorField.getColorString());
                    CssEditorSupport.getDefault().lastAggregatedEventFired();
                }
            });
            this.topStyleCombo = new JComboBox();
            this.topStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.topStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.topStyleCombo.setModel(this.borderModel.getStyleList());
            this.topStyleCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        PropertyData propertyData = new PropertyData();
                        propertyData.setValue(itemEvent.getItem().toString());
                        BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-top-style", null, propertyData.toString());
                    }
                }
            });
            this.topWidthField = new BorderWidthField();
            this.topWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.topWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"TOP_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.topWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-top-width", null, propertyChangeEvent.getNewValue().toString());
                }
            });
            this.topColorField = new ColorSelectionField();
            this.topColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-top-color", null, propertyChangeEvent.getNewValue().toString());
                }
            });
            this.bottomStyleCombo = new JComboBox();
            this.bottomStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.bottomStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.bottomStyleCombo.setModel(this.borderModel.getStyleList());
            this.bottomStyleCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        PropertyData propertyData = new PropertyData();
                        propertyData.setValue(itemEvent.getItem().toString());
                        BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-bottom-style", null, propertyData.toString());
                    }
                }
            });
            this.bottomWidthField = new BorderWidthField();
            this.bottomWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.bottomWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"BOTTOM_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.bottomWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-bottom-width", null, propertyChangeEvent.getNewValue().toString());
                }
            });
            this.bottomColorField = new ColorSelectionField();
            this.bottomColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-bottom-color", null, propertyChangeEvent.getNewValue().toString());
                }
            });
            this.leftStyleCombo = new JComboBox<String>(new String[0]);
            this.leftStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.leftStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.leftStyleCombo.setModel(this.borderModel.getStyleList());
            this.leftStyleCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        PropertyData propertyData = new PropertyData();
                        propertyData.setValue(itemEvent.getItem().toString());
                        BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-left-style", null, propertyData.toString());
                    }
                }
            });
            this.leftWidthField = new BorderWidthField();
            this.leftWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.leftWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"LEFT_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.leftWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-left-width", null, propertyChangeEvent.getNewValue().toString());
                }
            });
            this.leftColorField = new ColorSelectionField();
            this.leftColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-left-color", null, propertyChangeEvent.getNewValue().toString());
                }
            });
            this.rightStyleCombo = new JComboBox();
            this.rightStyleCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_STYLE_ACCESS_NAME"));
            this.rightStyleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_STYLE_ACCESS_DESC"));
            this.rightStyleCombo.setModel(this.borderModel.getStyleList());
            this.rightStyleCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        PropertyData propertyData = new PropertyData();
                        propertyData.setValue(itemEvent.getItem().toString());
                        BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-right-style", null, propertyData.toString());
                    }
                }
            });
            this.rightWidthField = new BorderWidthField();
            this.rightWidthField.setAccessibleName(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_ACCESS_NAME"), NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_UNIT_ACCESS_NAME"));
            this.rightWidthField.setAccessibleDescription(NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_ACCESS_DESC"), NbBundle.getMessage(BorderDataTable.class, (String)"RIGHT_SIDE_BORDER_WIDTH_UNIT_ACCESS_DESC"));
            this.rightWidthField.addPropertyChangeListener("border-width", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-right-width", null, propertyChangeEvent.getNewValue().toString());
                }
            });
            this.rightColorField = new ColorSelectionField();
            this.rightColorField.addPropertyChangeListener("color", new PropertyChangeListenerImpl(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BorderStyleEditor.this.cssPropertyChangeSupport().firePropertyChange("border-right-color", null, propertyChangeEvent.getNewValue().toString());
                }
            });
            this.add(jLabel);
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(jPanel4);
            this.add(this.allStyleCombo);
            this.add(this.allWidthField);
            this.add(this.allColorField);
            this.add(jPanel5);
            this.add(this.topStyleCombo);
            this.add(this.topWidthField);
            this.add(this.topColorField);
            this.add(jPanel6);
            this.add(this.bottomStyleCombo);
            this.add(this.bottomWidthField);
            this.add(this.bottomColorField);
            this.add(jPanel7);
            this.add(this.leftStyleCombo);
            this.add(this.leftWidthField);
            this.add(this.leftColorField);
            this.add(jPanel8);
            this.add(this.rightStyleCombo);
            this.add(this.rightWidthField);
            this.add(this.rightColorField);
            int n2 = this.getComponentCount();
            int[] nArray = new int[]{50, 75, 125, 125};
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i % 4];
                this.getComponent(i).setPreferredSize(new Dimension(n3, n));
                this.getComponent(i).setMinimumSize(new Dimension(n3, n));
                this.getComponent(i).setMaximumSize(new Dimension(n3, n));
            }
        }

        class PropertyChangeListenerImpl
        implements PropertyChangeListener {
            PropertyChangeListenerImpl() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            }
        }
    }
}

