/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class TapPanel
extends JPanel {
    public static final int UP = 0;
    public static final int DOWN = 2;
    public static final String PROP_ORIENTATION = "orientation";
    private int orientation = 0;
    private boolean armed = false;
    private boolean expanded = true;
    private int minimumHeight = 8;
    private static WeakReference<Adap> adapRef = null;
    private Icon up = new UpIcon();
    private Icon down = new DownIcon();
    private int ICON_SIZE = 8;

    public TapPanel() {
        this.setLayout(new TrivialLayout());
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    private static Adap getAdapter() {
        Adap adap = null;
        if (adapRef != null) {
            adap = (Adap)adapRef.get();
        }
        if (adap == null) {
            adap = new Adap();
            adapRef = new WeakReference<Adap>(adap);
        }
        return adap;
    }

    void setSecondaryMouseHandler(MouseListener mouseListener) {
        TapPanel.getAdapter().other = mouseListener;
    }

    public void addNotify() {
        this.addMouseMotionListener(TapPanel.getAdapter());
        this.addMouseListener(TapPanel.getAdapter());
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseMotionListener(TapPanel.getAdapter());
        this.removeMouseListener(TapPanel.getAdapter());
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != this.orientation) {
            int n2 = n;
            this.orientation = n;
            this.firePropertyChange(PROP_ORIENTATION, n2, n);
        }
    }

    private void setArmed(boolean bl) {
        if (bl != this.armed) {
            this.armed = bl;
            this.repaint();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = 20;
        return dimension;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            Dimension dimension = this.getPreferredSize();
            this.expanded = bl;
            Dimension dimension2 = this.getPreferredSize();
            if (this.isDisplayable()) {
                this.revalidate();
            }
        }
    }

    private boolean isArmPoint(Point point) {
        if (!this.expanded) {
            return point.y > 0 && point.y < this.getHeight();
        }
        if (this.orientation == 0) {
            return point.y > this.getHeight() - this.minimumHeight;
        }
        return point.y < this.minimumHeight;
    }

    public void updateBorder() {
        if (this.orientation == 0) {
            super.setBorder(BorderFactory.createEmptyBorder(0, 0, this.minimumHeight, 0));
        } else {
            super.setBorder(BorderFactory.createEmptyBorder(this.minimumHeight, 0, 0, 0));
        }
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setBorder() {
    }

    public void paintBorder(Graphics graphics) {
        Color color;
        if (this.armed) {
            color = UIManager.getColor("List.selectionBackground");
            if (color == null) {
                color = SystemColor.textHighlight;
            }
        } else {
            color = this.getBackground();
        }
        int n = 0;
        int n2 = this.orientation == 0 ? 1 + (this.getHeight() - this.minimumHeight) : 0;
        int n3 = this.getWidth();
        int n4 = this.minimumHeight - 1;
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        int n5 = this.orientation == 0 ? this.getHeight() - 1 : 0;
        int n6 = this.orientation == 0 ? -1 : 1;
        graphics.setColor(this.armed ? color.darker() : UIManager.getColor("controlShadow"));
        graphics.drawLine(0, n5, n3, n5);
        n5 += n6;
        if (this.orientation == 0 == this.expanded) {
            this.up.paintIcon(this, graphics, this.getWidth() / 2 - this.up.getIconWidth() / 2, this.getHeight() - (this.minimumHeight + (this.expanded ? 0 : -1)));
        } else {
            this.down.paintIcon(this, graphics, this.getWidth() / 2 - this.up.getIconWidth() / 2, this.expanded ? 2 : 1);
        }
    }

    public void paintChildren(Graphics graphics) {
        if (!this.expanded) {
            return;
        }
        super.paintChildren(graphics);
    }

    static final class TrivialLayout
    implements LayoutManager {
        TrivialLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            if (container instanceof TapPanel) {
                this.layoutTapPanel((TapPanel)container);
            } else {
                this.layoutComp(container);
            }
        }

        private void layoutComp(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray.length > 0) {
                componentArray[0].setBounds(0, 0, container.getWidth(), container.getHeight());
            }
        }

        private void layoutTapPanel(TapPanel tapPanel) {
            Component[] componentArray = tapPanel.getComponents();
            if (componentArray.length > 0) {
                Dimension dimension = componentArray[0].getPreferredSize();
                if (tapPanel.isExpanded()) {
                    int n = tapPanel.getOrientation() == 0 ? 0 : tapPanel.getMinimumHeight();
                    int n2 = Math.min(tapPanel.getHeight() - tapPanel.getMinimumHeight(), dimension.height);
                    componentArray[0].setBounds(0, n, tapPanel.getWidth(), n2);
                } else {
                    componentArray[0].setBounds(0, 0, 0, 0);
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension(20, 10);
            Component[] componentArray = container.getComponents();
            TapPanel tapPanel = (TapPanel)container;
            if (componentArray.length > 0) {
                Dimension dimension2 = componentArray[0].getPreferredSize();
                dimension.width = dimension2.width;
                dimension.height = tapPanel.isExpanded() ? dimension2.height + tapPanel.getMinimumHeight() : tapPanel.getMinimumHeight();
            }
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }
    }

    private class DownIcon
    implements Icon {
        private DownIcon() {
        }

        public int getIconHeight() {
            return TapPanel.this.ICON_SIZE - 3;
        }

        public int getIconWidth() {
            return TapPanel.this.ICON_SIZE + 2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(TapPanel.this.armed ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("controlShadow"));
            int[] nArray = new int[]{++n, n + 8, n + 4};
            int[] nArray2 = new int[]{n2, n2, n2 + 4};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
    }

    private class UpIcon
    implements Icon {
        private UpIcon() {
        }

        public int getIconHeight() {
            return TapPanel.this.ICON_SIZE - 2;
        }

        public int getIconWidth() {
            return TapPanel.this.ICON_SIZE + 2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(TapPanel.this.armed ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("controlShadow"));
            int[] nArray = new int[]{n, n + 8, n + 4};
            int[] nArray2 = new int[]{n2 + 5, n2 + 5, n2};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
    }

    static class Adap
    extends MouseAdapter
    implements MouseMotionListener {
        MouseListener other = null;

        Adap() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ((TapPanel)mouseEvent.getSource()).setArmed(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ((TapPanel)mouseEvent.getSource()).setArmed(false);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ((TapPanel)mouseEvent.getSource()).setArmed(((TapPanel)mouseEvent.getSource()).isArmPoint(mouseEvent.getPoint()));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (((TapPanel)mouseEvent.getSource()).isArmPoint(mouseEvent.getPoint())) {
                ((TapPanel)mouseEvent.getSource()).setExpanded(!((TapPanel)mouseEvent.getSource()).isExpanded());
                mouseEvent.consume();
            } else if (this.other != null) {
                this.other.mousePressed(mouseEvent);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

