/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.xml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AntProjectSupport
implements AntProjectCookie.ParseStatus,
DocumentListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(AntProjectSupport.class.getName());
    private FileObject fo;
    private Document projDoc = null;
    private Throwable exception = null;
    private boolean parsed = false;
    private Reference<StyledDocument> styledDocRef = null;
    private final Object parseLock;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private Reference<EditorCookie.Observable> editorRef;
    private DocumentBuilder documentBuilder;
    private static final int REPARSE_DELAY = 3000;
    private final RequestProcessor rp;
    private RequestProcessor.Task task = null;

    public AntProjectSupport(FileObject fileObject) {
        this.fo = fileObject;
        this.parseLock = new Object();
        this.rp = new RequestProcessor("AntProjectSupport[" + fileObject + "]");
    }

    private synchronized EditorCookie.Observable getEditor() {
        EditorCookie.Observable observable;
        FileObject fileObject = this.getFileObject();
        if (fileObject == null) {
            return null;
        }
        EditorCookie.Observable observable2 = observable = this.editorRef == null ? null : this.editorRef.get();
        if (observable == null) {
            try {
                observable = (EditorCookie.Observable)DataObject.find((FileObject)fileObject).getLookup().lookup(EditorCookie.Observable.class);
                if (observable != null) {
                    observable.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)observable));
                    this.editorRef = new WeakReference<EditorCookie.Observable>(observable);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(Level.INFO, "no editor for " + this.fo, dataObjectNotFoundException);
            }
        }
        return observable;
    }

    public File getFile() {
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            return FileUtil.toFile((FileObject)fileObject);
        }
        return null;
    }

    public FileObject getFileObject() {
        if (this.fo != null && !this.fo.isValid()) {
            return null;
        }
        return this.fo;
    }

    public void setFile(File file) {
        this.fo = FileUtil.toFileObject((File)file);
        this.invalidate();
    }

    public void setFileObject(FileObject fileObject) {
        this.fo = fileObject;
        this.invalidate();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument() {
        Object object = this.parseLock;
        synchronized (object) {
            if (!this.parsed) {
                this.parseDocument();
            }
            if (this.projDoc == null) {
                return null;
            }
            try {
                return (Document)this.projDoc.cloneNode(true);
            }
            catch (DOMException dOMException) {
                Logger.getLogger(AntProjectSupport.class.getName()).log(Level.INFO, "#154502: cloning document for " + this, dOMException);
                return this.projDoc;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getParseException() {
        Object object = this.parseLock;
        synchronized (object) {
            if (!this.parsed) {
                this.parseDocument();
            }
            return this.exception;
        }
    }

    private static synchronized DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(ErrHandler.DEFAULT);
        return documentBuilder;
    }

    public static InputSource createInputSource(FileObject fileObject, final StyledDocument styledDocument) throws IOException {
        InputSource inputSource;
        block7: {
            String[] stringArray;
            block6: {
                if (fileObject != null && !(stringArray = DataObject.find((FileObject)fileObject)).isModified()) {
                    try {
                        return new InputSource(fileObject.getURL().toExternalForm());
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError((Object)fileStateInvalidException);
                    }
                }
            }
            stringArray = new String[1];
            styledDocument.render(new Runnable(){

                public void run() {
                    try {
                        stringArray[0] = styledDocument.getText(0, styledDocument.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        throw new AssertionError((Object)badLocationException);
                    }
                }
            });
            inputSource = new InputSource(new StringReader(stringArray[0]));
            if (fileObject != null) {
                try {
                    inputSource.setSystemId(fileObject.getURL().toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)fileStateInvalidException);
                }
            }
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDocument() {
        block14: {
            assert (Thread.holdsLock(this.parseLock));
            FileObject fileObject = this.getFileObject();
            LOG.log(Level.FINE, "AntProjectSupport.parseDocument: fo={0}", fileObject);
            try {
                Document document;
                block13: {
                    EditorCookie.Observable observable;
                    if (this.documentBuilder == null) {
                        this.documentBuilder = AntProjectSupport.createDocumentBuilder();
                    }
                    if ((observable = this.getEditor()) != null) {
                        StyledDocument styledDocument = observable.openDocument();
                        if (this.styledDocRef != null && this.styledDocRef.get() != styledDocument || this.styledDocRef == null) {
                            styledDocument.addDocumentListener(this);
                            this.styledDocRef = new WeakReference<StyledDocument>(styledDocument);
                        }
                        InputSource inputSource = AntProjectSupport.createInputSource(fileObject, styledDocument);
                        document = this.documentBuilder.parse(inputSource);
                    } else {
                        if (fileObject != null) {
                            InputStream inputStream = fileObject.getInputStream();
                            try {
                                InputSource inputSource;
                                block12: {
                                    inputSource = new InputSource(inputStream);
                                    try {
                                        inputSource.setSystemId(fileObject.getURL().toExternalForm());
                                    }
                                    catch (FileStateInvalidException fileStateInvalidException) {
                                        if ($assertionsDisabled) break block12;
                                        throw new AssertionError((Object)fileStateInvalidException);
                                    }
                                }
                                document = this.documentBuilder.parse(inputSource);
                                Object var8_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var8_11 = null;
                                inputStream.close();
                                throw throwable;
                            }
                            inputStream.close();
                            {
                                break block13;
                            }
                        }
                        this.exception = new FileNotFoundException("Ant script probably deleted");
                        return;
                    }
                }
                this.projDoc = document;
                this.exception = null;
            }
            catch (Exception exception) {
                this.exception = exception;
                if (this.exception instanceof SAXParseException) break block14;
                LOG.log(Level.INFO, "Strange parse error in " + this, this.exception);
            }
        }
        this.fireChangeEvent(false);
        this.parsed = true;
    }

    public Element getProjectElement() {
        Document document = this.getDocument();
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AntProjectSupport)) {
            return false;
        }
        AntProjectSupport antProjectSupport = (AntProjectSupport)object;
        if (this.fo != null) {
            return this.fo.equals(antProjectSupport.fo);
        }
        return false;
    }

    public int hashCode() {
        return 0x6CB1 ^ (this.fo != null ? this.fo.hashCode() : 0);
    }

    public String toString() {
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            return fileObject.toString();
        }
        return "<missing Ant script>";
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent(boolean bl) {
        LOG.log(Level.FINE, "AntProjectSupport.fireChangeEvent: fo={0}", this.fo);
        ChangeFirer changeFirer = new ChangeFirer();
        AntProjectSupport antProjectSupport = this;
        synchronized (antProjectSupport) {
            if (this.task == null) {
                this.task = this.rp.post((Runnable)changeFirer, bl ? 3000 : 0);
            } else if (!bl) {
                this.task.schedule(0);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.invalidate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.invalidate();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            this.invalidate();
        }
    }

    protected final void invalidate() {
        LOG.log(Level.FINE, "AntProjectSupport.invalidate: fo={0}", this.fo);
        this.parsed = false;
        this.fireChangeEvent(true);
    }

    private final class ChangeFirer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.log(Level.FINE, "AntProjectSupport.ChangeFirer.run: fo={0}", AntProjectSupport.this.fo);
            AntProjectSupport antProjectSupport = AntProjectSupport.this;
            synchronized (antProjectSupport) {
                if (AntProjectSupport.this.task == null) {
                    return;
                }
                AntProjectSupport.this.task = null;
            }
            AntProjectSupport.this.cs.fireChange();
        }
    }

    private static final class ErrHandler
    implements ErrorHandler {
        static final ErrorHandler DEFAULT = new ErrHandler();

        private ErrHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

