/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.AntModule;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class Hyperlink
implements OutputListener {
    static final Set<Hyperlink> hyperlinks = new WeakSet();
    private final URL url;
    private final String message;
    private final int line1;
    private int col1;
    private final int line2;
    private final int col2;
    private Line liveLine;
    private static final Logger ERR = Logger.getLogger("org.apache.tools.ant.module.run.Hyperlink");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hyperlink(URL uRL, String string, int n, int n2, int n3, int n4) {
        this.url = uRL;
        this.message = string;
        this.line1 = n;
        this.col1 = n2;
        this.line2 = n3;
        this.col2 = n4;
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            hyperlinks.add(this);
        }
    }

    public void setColumn1(int n) {
        if (this.col1 == -1) {
            this.col1 = n;
        }
    }

    public void outputLineAction(OutputEvent outputEvent) {
        block12: {
            FileObject fileObject = URLMapper.findFileObject((URL)this.url);
            if (fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                if (editorCookie != null && fileObject == dataObject.getPrimaryFile()) {
                    block13: {
                        if (this.line1 == -1) {
                            editorCookie.open();
                            break block12;
                        }
                        try {
                            editorCookie.openDocument();
                        }
                        catch (UserQuestionException userQuestionException) {
                            if (this.askUserAndDoOpen(userQuestionException, editorCookie)) break block13;
                            return;
                        }
                    }
                    AntModule.err.log("opened document for " + fileObject);
                    try {
                        Line line = this.updateLines(editorCookie);
                        if (!line.isDeleted()) {
                            line.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, this.col1 == -1 ? -1 : this.col1 - 1);
                        }
                        break block12;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        editorCookie.open();
                    }
                    break block12;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
        if (this.message != null) {
            StatusDisplayer.getDefault().setStatusText(this.message);
        }
    }

    private boolean askUserAndDoOpen(UserQuestionException userQuestionException, EditorCookie editorCookie) {
        while (userQuestionException != null) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0);
            confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                try {
                    userQuestionException.confirmed();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return true;
                }
            } else {
                return false;
            }
            userQuestionException = null;
            try {
                editorCookie.openDocument();
            }
            catch (UserQuestionException userQuestionException2) {
                userQuestionException = userQuestionException2;
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, null, iOException);
            }
            catch (Exception exception) {
                ERR.log(Level.SEVERE, null, exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Line updateLines(EditorCookie editorCookie) {
        Line.Set set = editorCookie.getLineSet();
        Set<Hyperlink> set2 = hyperlinks;
        synchronized (set2) {
            assert (this.line1 != -1);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.liveLine == null) {
                bl = true;
                for (Hyperlink hyperlink : hyperlinks) {
                    if (hyperlink == this) {
                        bl2 = true;
                    }
                    if (hyperlink.liveLine != null || !hyperlink.url.equals(this.url) || hyperlink.line1 == -1) continue;
                    Line line = set.getOriginal(hyperlink.line1 - 1);
                    assert (line != null) : hyperlink;
                    hyperlink.liveLine = line;
                    if (hyperlink != this) continue;
                    bl3 = true;
                }
            }
            assert (this.liveLine != null) : "this=" + this + " ran=" + bl + " encounteredThis=" + bl2 + " modifiedThis=" + bl3 + " hyperlinks=" + hyperlinks + " hyperlinks.contains(this)=" + hyperlinks.contains(this);
            return this.liveLine;
        }
    }

    public void outputLineSelected(OutputEvent outputEvent) {
        FileObject fileObject = URLMapper.findFileObject((URL)this.url);
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            if (editorCookie != null) {
                Line line;
                if (editorCookie.getDocument() == null) {
                    AntModule.err.log("no document for " + fileObject);
                    return;
                }
                AntModule.err.log("got document for " + fileObject);
                if (this.line1 != -1 && !(line = this.updateLines(editorCookie)).isDeleted()) {
                    line.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE, this.col1 == -1 ? -1 : this.col1 - 1);
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputLineCleared(OutputEvent outputEvent) {
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            this.liveLine = null;
        }
    }

    public String toString() {
        return "Hyperlink[" + this.url + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
    }
}

