/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBRulesRegistry;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBProblemFinder {
    private boolean cancelled = false;
    private FileObject file = null;
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
    public static final Logger LOG = Logger.getLogger(EJBProblemFinder.class.getName());
    private static final Object singleInstanceLock = new Object();
    private static EJBProblemFinder runningInstance = null;

    public EJBProblemFinder(FileObject fileObject) {
        assert (fileObject != null);
        this.file = fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final CompilationInfo compilationInfo) throws Exception {
        if (!"text/x-java".equals(this.file.getMIMEType())) {
            return;
        }
        if (runningInstance != null) {
            runningInstance.cancel();
        }
        Object object = singleInstanceLock;
        synchronized (object) {
            J2eeModule j2eeModule;
            runningInstance = this;
            this.cancelled = false;
            this.problemsFound.clear();
            boolean bl = false;
            Project project = FileOwnerQuery.getOwner((FileObject)this.file);
            if (project == null) {
                return;
            }
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null && J2eeModule.Type.EJB.equals(j2eeModule.getType())) {
                bl = true;
            }
            if (!bl) {
                return;
            }
            j2eeModule = EjbJar.getEjbJar((FileObject)this.file);
            Profile profile = j2eeModule.getJ2eeProfile();
            if (j2eeModule == null || !Profile.JAVA_EE_5.equals(profile) && !Profile.JAVA_EE_6_FULL.equals(profile) && !Profile.JAVA_EE_6_WEB.equals(profile)) {
                return;
            }
            j2eeModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata ejbJarMetadata) {
                    String string = ejbJarMetadata.getRoot().getVersion().toString();
                    if (!"3.0".equals(string) && !"3.1".equals(string)) {
                        return null;
                    }
                    for (Tree tree : compilationInfo.getCompilationUnit().getTypeDecls()) {
                        if (EJBProblemFinder.this.isCancelled()) break;
                        if (tree.getKind() != Tree.Kind.CLASS) continue;
                        long l = Calendar.getInstance().getTimeInMillis();
                        TreePath treePath = compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), tree);
                        TypeElement typeElement = (TypeElement)compilationInfo.getTrees().getElement(treePath);
                        Ejb ejb = ejbJarMetadata.findByEjbClass(typeElement.getQualifiedName().toString());
                        EJBProblemContext eJBProblemContext = new EJBProblemContext(compilationInfo, EJBProblemFinder.this.file, typeElement, ejb, ejbJarMetadata);
                        EJBProblemFinder.this.problemsFound.addAll(EJBRulesRegistry.check(eJBProblemContext));
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        long l2 = Calendar.getInstance().getTimeInMillis() - l;
                        LOG.log(Level.FINE, "processed class {0} in {1} ms", new Object[]{typeElement.getSimpleName(), l2});
                    }
                    return null;
                }
            });
            HintsController.setErrors((FileObject)this.file, (String)"EJB Verification", this.problemsFound);
            runningInstance = null;
        }
    }

    public void cancel() {
        LOG.fine("Cancelling EJBProblemFinder task");
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<? extends ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProblemFinderCompControl
    extends EJBProblemFinder
    implements CancellableTask<CompilationController> {
        public ProblemFinderCompControl(FileObject fileObject) {
            super(fileObject);
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            super.run((CompilationInfo)compilationController);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProblemFinderCompInfo
    extends EJBProblemFinder
    implements CancellableTask<CompilationInfo> {
        public ProblemFinderCompInfo(FileObject fileObject) {
            super(fileObject);
        }
    }
}

