/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hyperlink;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.hibernate.editor.HibernateEditorUtil;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkEnv;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkProcessor;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;

public class PropertyHyperlinkProcessor
extends HyperlinkProcessor {
    public void process(HyperlinkEnv hyperlinkEnv) {
        try {
            final String string = HibernateEditorUtil.getClassName((Node)hyperlinkEnv.getCurrentTag());
            if (string == null) {
                return;
            }
            final String string2 = hyperlinkEnv.getValueString();
            if (string2 == null || string2.length() == 0) {
                return;
            }
            JavaSource javaSource = HibernateEditorUtil.getJavaSource(hyperlinkEnv.getDocument());
            if (javaSource == null) {
                return;
            }
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = HibernateEditorUtil.findClassElementByBinaryName(string, compilationController);
                    if (typeElement == null) {
                        return;
                    }
                    TypeMirror typeMirror = typeElement.asType();
                    if (typeMirror == null) {
                        return;
                    }
                    ElementUtilities elementUtilities = compilationController.getElementUtilities();
                    VariableElement variableElement = HibernateEditorUtil.findFieldElementOnType(elementUtilities, typeMirror, string2);
                    if (variableElement != null) {
                        ElementOpen.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)variableElement);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

