/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.dlight.annotationsupport.AnnotationMark;
import org.netbeans.modules.dlight.annotationsupport.AnnotationMarkInstaller;
import org.netbeans.modules.dlight.annotationsupport.AnnotationMarkProvider;
import org.netbeans.modules.dlight.annotationsupport.FileAnnotationInfo;
import org.netbeans.modules.dlight.annotationsupport.LineAnnotationInfo;
import org.netbeans.modules.dlight.annotationsupport.ShowTextAnnotationsAction;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.text.NbDocument;
import org.openide.util.actions.SystemAction;

public class AnnotationBar
extends JComponent
implements Accessible,
PropertyChangeListener,
DocumentListener,
ChangeListener,
ActionListener,
ComponentListener,
MouseMotionListener {
    private FileAnnotationInfo fileAnnotationInfo;
    private final JTextComponent textComponent;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument doc;
    private final Caret caret;
    private boolean annotated;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private Color metricsFG = null;
    private Color metricsBG = null;
    private Color navigationBarFG = null;
    private Color navigationBarBG = null;
    private Font barFont = null;

    public AnnotationBar(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.doc = this.editorUI.getDocument();
        this.caret = this.textComponent.getCaret();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.addMouseListener(new PopupMenuListener());
    }

    protected FileAnnotationInfo getFileAnnotationInfo() {
        return this.fileAnnotationInfo;
    }

    private void getColors() {
        EditorSettings editorSettings = EditorSettings.getDefault();
        Map map = editorSettings.getHighlightings(editorSettings.getCurrentFontColorProfile());
        AttributeSet attributeSet = (AttributeSet)map.get("dlight-metrics-annotations");
        this.metricsFG = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        this.metricsBG = (Color)attributeSet.getAttribute(StyleConstants.Background);
        attributeSet = (AttributeSet)map.get("dlight-metrics-text-highlighting");
        this.navigationBarFG = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        this.navigationBarBG = (Color)attributeSet.getAttribute(StyleConstants.Background);
    }

    private Color getMetricsFGColor() {
        if (this.metricsFG == null) {
            this.getColors();
        }
        return this.metricsFG;
    }

    private Color getMetricsBGColor() {
        if (this.metricsBG == null) {
            this.getColors();
        }
        return this.metricsBG;
    }

    private Color getNavigationBarFGColor() {
        if (this.navigationBarFG == null) {
            this.getColors();
        }
        return this.navigationBarFG;
    }

    private Color getTextHighlightBGColor() {
        if (this.navigationBarBG == null) {
            this.getColors();
        }
        return this.navigationBarBG;
    }

    private Color backgroundColor() {
        if (this.getMetricsBGColor() != null) {
            return this.getMetricsBGColor();
        }
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Color foregroundColor() {
        if (this.getMetricsFGColor() != null) {
            return this.getMetricsFGColor();
        }
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.foregroundColor;
    }

    private Color defaultBackground() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Font getBarFont() {
        if (this.barFont == null) {
            this.barFont = new Font("Monospaced", 0, this.editorUI.getComponent().getFont().getSize() - 1);
        }
        return this.barFont;
    }

    private Font getBarBoldFont() {
        Font font = this.getBarFont().deriveFont(1);
        return font;
    }

    public Dimension getPreferredSize() {
        int n;
        if (!this.annotated || this.getFileAnnotationInfo() == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = this.textComponent.getSize();
        dimension.width = n = this.getBarWidth();
        dimension.height *= 2;
        return dimension;
    }

    private int getBarWidth() {
        int n = this.getFileAnnotationInfo().getAnnotationLength();
        if (n == 0) {
            return 0;
        }
        Graphics graphics = this.getGraphics();
        graphics.setFont(this.getBarFont());
        int n2 = graphics.getFontMetrics().charWidth('X');
        graphics.setFont(this.getBarBoldFont());
        n2 = graphics.getFontMetrics().charWidth('X');
        return n * n2 + 7;
    }

    public void annotate(FileAnnotationInfo fileAnnotationInfo) {
        if (fileAnnotationInfo == null) {
            return;
        }
        this.fileAnnotationInfo = fileAnnotationInfo;
        this.setToolTipText(fileAnnotationInfo.getTooltip());
        this.annotated = true;
        this.doc.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.editorUI.addPropertyChangeListener((PropertyChangeListener)this);
        EditorSettings.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.addMouseMotionListener(this);
        ArrayList<AnnotationMark> arrayList = new ArrayList<AnnotationMark>();
        for (LineAnnotationInfo lineAnnotationInfo : fileAnnotationInfo.getLineAnnotationInfo()) {
            arrayList.add(new AnnotationMark(lineAnnotationInfo.getLine() - 1, lineAnnotationInfo.getTooltip(), this.getNavigationBarFGColor()));
        }
        for (LineAnnotationInfo lineAnnotationInfo : fileAnnotationInfo.getBlockAnnotationInfo()) {
            arrayList.add(new AnnotationMark(lineAnnotationInfo.getLine() - 1, lineAnnotationInfo.getTooltip(), this.getNavigationBarFGColor()));
        }
        Object object = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
        if (object != null) {
            ((AnnotationMarkProvider)((Object)object)).setMarks(arrayList);
        }
        this.revalidate();
    }

    public void unAnnotate() {
        Object object2;
        this.annotated = false;
        if (this.getFileAnnotationInfo() == null || this.getFileAnnotationInfo().getLineAnnotationInfo() == null) {
            return;
        }
        for (Object object2 : this.getFileAnnotationInfo().getLineAnnotationInfo()) {
            this.setHighlight((StyledDocument)this.doc, object2.getLine(), object2.getLine(), new Color(255, 255, 255), null);
        }
        ArrayList arrayList = new ArrayList();
        object2 = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
        if (object2 != null) {
            ((AnnotationMarkProvider)((Object)object2)).setMarks(arrayList);
        }
        this.doc.removeDocumentListener((DocumentListener)this);
        this.textComponent.removeComponentListener(this);
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        EditorSettings.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        this.removeMouseMotionListener(this);
        this.revalidate();
    }

    private void setHighlight(StyledDocument styledDocument, int n, int n2, Color color, Color color2) {
        if (color == null) {
            return;
        }
        for (int i = n - 1; i < n2; ++i) {
            int n3;
            if (i < 0 || (n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)i)) < 0) continue;
            Style style = styledDocument.getLogicalStyle(n3);
            if (style == null) {
                style = styledDocument.addStyle("gizmo-style(" + color + "):1000", null);
            }
            if (color != null) {
                style.addAttribute(StyleConstants.ColorConstants.Background, color);
            }
            styledDocument.setLogicalStyle(n3, style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        block12: {
            if (!this.annotated || this.getFileAnnotationInfo() == null) {
                return;
            }
            super.paintComponent(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            JTextComponent jTextComponent = this.editorUI.getComponent();
            if (jTextComponent == null) {
                return;
            }
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            View view = Utilities.getDocumentView((JTextComponent)jTextComponent);
            if (view == null) {
                return;
            }
            graphics.setColor(this.defaultBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
            abstractDocument.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int n = baseTextUI.getPosFromY(rectangle.y);
                    int n2 = view.getViewIndex(n, Position.Bias.Forward);
                    int n3 = view.getViewCount();
                    if (n2 < 0 || n2 >= n3) break block12;
                    Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, view.getView(n2).getStartOffset());
                    int n4 = rectangle2 == null ? 0 : rectangle2.y;
                    int n5 = rectangle.y + rectangle.height;
                    for (int i = n2; i < n3; ++i) {
                        View view2 = view.getView(i);
                        this.paintView(view2, graphics, n4);
                        if ((n4 += this.editorUI.getLineHeight()) < n5) continue;
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException badLocationException) {
                System.out.println("ble: " + badLocationException.getMessage());
                badLocationException.printStackTrace();
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
    }

    private void paintView(View view, Graphics graphics, int n) {
        String string;
        int n2;
        int n3;
        int n4;
        int n5;
        Rectangle rectangle;
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        Element element = baseTextUI.getRootView(jTextComponent).getElement();
        int n6 = view.getStartOffset();
        LineAnnotationInfo lineAnnotationInfo = this.getFileAnnotationInfo().getLineAnnotationInfoByLineOffset(n6);
        if (lineAnnotationInfo != null) {
            rectangle = graphics.getClipBounds();
            n5 = rectangle.x;
            n4 = rectangle.width - 1;
            n3 = n;
            n2 = this.editorUI.getLineHeight();
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(n5, n3 + 1, n4, n2 - 1);
            string = lineAnnotationInfo.getAnnotation();
            graphics.setFont(this.getBarFont());
            graphics.setColor(this.foregroundColor());
            graphics.drawString(string, 4, n + this.editorUI.getLineAscent());
            lineAnnotationInfo.setY(n, n + this.editorUI.getLineHeight());
        }
        if ((lineAnnotationInfo = this.getFileAnnotationInfo().getBlockAnnotationInfoByLineOffset(n6)) != null) {
            rectangle = graphics.getClipBounds();
            n5 = rectangle.x;
            n4 = rectangle.width - 1;
            n3 = n;
            n2 = this.editorUI.getLineHeight();
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(n5, n3 + 1, n4, n2 - 2);
            string = lineAnnotationInfo.getAnnotation();
            graphics.setFont(this.getBarBoldFont());
            graphics.setColor(this.foregroundColor());
            graphics.drawString(string, 4, n + this.editorUI.getLineAscent());
            lineAnnotationInfo.setY(n, n + this.editorUI.getLineHeight());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string) && propertyChangeEvent.getNewValue() == null) {
            this.release();
        }
        if ("editorFontColors".equals(string) && propertyChangeEvent.getNewValue() != null && ((String)propertyChangeEvent.getNewValue()).equals("NetBeans")) {
            this.metricsFG = null;
            this.metricsBG = null;
            this.navigationBarFG = null;
            this.navigationBarBG = null;
            if (this.annotated) {
                this.unAnnotate();
                this.annotate(this.getFileAnnotationInfo());
            }
        }
    }

    private void release() {
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        this.textComponent.removeComponentListener(this);
        this.doc.removeDocumentListener((DocumentListener)this);
        this.caret.removeChangeListener(this);
        AnnotationMarkProvider annotationMarkProvider = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
        if (annotationMarkProvider != null) {
            annotationMarkProvider.setMarks(Collections.<AnnotationMark>emptyList());
        }
        this.clearRecentFeedback();
    }

    private void clearRecentFeedback() {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.revalidate();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        String string = this.getFileAnnotationInfo().getTooltip();
        LineAnnotationInfo lineAnnotationInfo = this.getFileAnnotationInfo().getLineAnnotationInfoByYCoordinate(mouseEvent.getY());
        if (lineAnnotationInfo == null) {
            lineAnnotationInfo = this.getFileAnnotationInfo().getBlockAnnotationInfoByYCoordinate(mouseEvent.getY());
        }
        if (lineAnnotationInfo != null) {
            string = lineAnnotationInfo.getTooltip();
        }
        this.setToolTipText(string);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private static class PopupMenuListener
    extends MouseAdapter
    implements MouseListener {
        private JPopupMenu pm;
        JCheckBoxMenuItem checkBoxMenuItem;

        public PopupMenuListener() {
            SystemAction systemAction = SystemAction.get(ShowTextAnnotationsAction.class);
            this.pm = new JPopupMenu();
            this.checkBoxMenuItem = new JCheckBoxMenuItem((Action)systemAction);
            this.checkBoxMenuItem.setIcon(null);
            this.checkBoxMenuItem.setState(true);
            this.pm.add(this.checkBoxMenuItem);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.checkBoxMenuItem.setState(true);
                this.pm.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

