/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.SupportiveDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;
import org.openide.explorer.view.Visualizer;

public class TreeTableOperator
extends JTableOperator {
    private JTreeOperator _tree;

    public TreeTableOperator(JTable jTable) {
        super(jTable);
    }

    public TreeTableOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public TreeTableOperator(ContainerOperator containerOperator, int n) {
        this((JTable)TreeTableOperator.waitComponent((ContainerOperator)containerOperator, (ComponentChooser)new TreeTableFinder(ComponentSearcher.getTrueChooser((String)"Any TreeTable")), (int)n));
        this.copyEnvironment((Operator)containerOperator);
    }

    public JTreeOperator tree() {
        if (this._tree == null) {
            this.waitState(new ComponentChooser(){

                public boolean checkComponent(Component component) {
                    return TreeTableOperator.this.getColumnCount() > 0 && TreeTableOperator.this.getRowCount() > 0;
                }

                public String getDescription() {
                    return "TreeTable contains any rows.";
                }
            });
            Object object = this.getValueAt(0, 0);
            JTree jTree = (JTree)this.getCellRenderer(0, 0).getTableCellRendererComponent((JTable)this.getSource(), object, false, false, 0, 0);
            this._tree = new RenderedTreeOperator(this, jTree);
            this._tree.setVisualizer((Operator.ComponentVisualizer)new EmptyVisualizer());
        }
        this.makeComponentVisible();
        return this._tree;
    }

    public int selectNode(String string) {
        TreePath treePath = this.tree().findPath(string, "|");
        if (!this.tree().isPathSelected(treePath)) {
            this.tree().selectPath(treePath);
        }
        int n = this.tree().getRowForPath(treePath);
        this.scrollToCell(n, 0);
        new EventTool().waitNoEvent(500L);
        return n;
    }

    public void verify() {
        this.tree();
    }

    static {
        DriverManager.setDriver((String)"drivers.mouse", (Object)((Object)new RenderedMouseDriver()), RenderedTreeOperator.class);
    }

    public static class RenderedTreeOperator
    extends JTreeOperator {
        TreeTableOperator oper;

        public RenderedTreeOperator(TreeTableOperator treeTableOperator, JTree jTree) {
            super(jTree);
            this.oper = treeTableOperator;
        }

        public ComponentOperator getRealOperator() {
            return this.oper;
        }

        public JPopupMenu callPopupOnPaths(TreePath[] treePathArray, int n) {
            this.oper.makeComponentVisible();
            for (int i = 0; i < treePathArray.length; ++i) {
                if (treePathArray[i].getParentPath() == null) continue;
                this.expandPath(treePathArray[i].getParentPath());
            }
            this.selectPaths(treePathArray);
            this.scrollToPath(treePathArray[treePathArray.length - 1]);
            Point point = this.getPointToClick(treePathArray[treePathArray.length - 1]);
            return JPopupMenuOperator.callPopup((Component)this.oper.getSource(), (int)((int)point.getX()), (int)((int)point.getY()), (int)n);
        }

        public void scrollToPath(TreePath treePath) {
            this.makeComponentVisible();
            JScrollPane jScrollPane = (JScrollPane)this.getContainer((ComponentChooser)new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser((String)"JScrollPane")));
            if (jScrollPane == null) {
                return;
            }
            JScrollPaneOperator jScrollPaneOperator = new JScrollPaneOperator(jScrollPane);
            jScrollPaneOperator.copyEnvironment((Operator)this);
            jScrollPaneOperator.setVisualizer((Operator.ComponentVisualizer)new EmptyVisualizer());
            Rectangle rectangle = this.getPathBounds(treePath);
            if (rectangle == null) {
                throw new JTreeOperator.NoSuchPathException((JTreeOperator)this, treePath);
            }
            jScrollPaneOperator.scrollToComponentRectangle(this.getRealOperator().getSource(), (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        }

        public void expandPath(TreePath treePath) {
            super.expandPath(treePath);
            Visualizer.findNode((Object)treePath.getLastPathComponent()).getChildren().getNodes(true);
        }
    }

    public static class RenderedMouseDriver
    extends SupportiveDriver
    implements MouseDriver {
        public RenderedMouseDriver() {
            super(new Class[]{RenderedTreeOperator.class});
        }

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public void pressMouse(ComponentOperator componentOperator, int n, int n2, int n3, int n4) {
            this.checkSupported(componentOperator);
            ComponentOperator componentOperator2 = ((RenderedTreeOperator)componentOperator).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)componentOperator2).pressMouse(componentOperator2, n, n2, n3, n4);
        }

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public void releaseMouse(ComponentOperator componentOperator, int n, int n2, int n3, int n4) {
            this.checkSupported(componentOperator);
            ComponentOperator componentOperator2 = ((RenderedTreeOperator)componentOperator).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)componentOperator2).releaseMouse(componentOperator2, n, n2, n3, n4);
        }

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public void clickMouse(ComponentOperator componentOperator, int n, int n2, int n3, int n4, int n5, Timeout timeout) {
            this.checkSupported(componentOperator);
            ComponentOperator componentOperator2 = ((RenderedTreeOperator)componentOperator).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)componentOperator2).clickMouse(componentOperator2, n, n2, n3, n4, n5, timeout);
        }

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public void moveMouse(ComponentOperator componentOperator, int n, int n2) {
            this.checkSupported(componentOperator);
            ComponentOperator componentOperator2 = ((RenderedTreeOperator)componentOperator).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)componentOperator2).moveMouse(componentOperator2, n, n2);
        }

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public void dragMouse(ComponentOperator componentOperator, int n, int n2, int n3, int n4) {
            this.checkSupported(componentOperator);
            ComponentOperator componentOperator2 = ((RenderedTreeOperator)componentOperator).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)componentOperator2).dragMouse(componentOperator2, n, n2, n3, n4);
        }

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public void dragNDrop(ComponentOperator componentOperator, int n, int n2, int n3, int n4, int n5, int n6, Timeout timeout, Timeout timeout2) {
            this.checkSupported(componentOperator);
            ComponentOperator componentOperator2 = ((RenderedTreeOperator)componentOperator).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)componentOperator2).dragNDrop(componentOperator2, n, n2, n3, n4, n5, n6, timeout, timeout2);
        }

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public void enterMouse(ComponentOperator componentOperator) {
            this.checkSupported(componentOperator);
            ComponentOperator componentOperator2 = ((RenderedTreeOperator)componentOperator).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)componentOperator2).enterMouse(componentOperator2);
        }

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
        public void exitMouse(ComponentOperator componentOperator) {
            this.checkSupported(componentOperator);
            ComponentOperator componentOperator2 = ((RenderedTreeOperator)componentOperator).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)componentOperator2).exitMouse(componentOperator2);
        }
    }

    static class TreeTableFinder
    implements ComponentChooser {
        ComponentChooser subFinder;

        public TreeTableFinder(ComponentChooser componentChooser) {
            this.subFinder = componentChooser;
        }

        public boolean checkComponent(Component component) {
            Class<?> clazz = component.getClass();
            do {
                if (!clazz.getName().equals("org.openide.explorer.view.TreeTable")) continue;
                return this.subFinder.checkComponent(component);
            } while ((clazz = clazz.getSuperclass()) != null);
            return false;
        }

        public String getDescription() {
            return this.subFinder.getDescription();
        }
    }
}

