/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.importstep;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.client.PanelProgressSupport;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.PreviewPanel;
import org.netbeans.modules.subversion.util.Context;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ImportPreviewStep
extends AbstractStep {
    private PreviewPanel previewPanel;
    private Context context;
    private CommitTable table;
    private PanelProgressSupport support;
    private String importMessage;

    public ImportPreviewStep(Context context) {
        this.context = context;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ImportPreviewStep.class);
    }

    protected JComponent createComponent() {
        if (this.previewPanel == null) {
            this.previewPanel = new PreviewPanel();
            this.table = new CommitTable(this.previewPanel.tableLabel, CommitTable.IMPORT_COLUMNS, new String[]{"path"});
            JComponent jComponent = this.table.getComponent();
            this.previewPanel.tablePanel.setLayout(new BorderLayout());
            this.previewPanel.tablePanel.add((Component)jComponent, "Center");
        }
        return this.previewPanel;
    }

    protected void validateBeforeNext() {
        this.validateUserInput();
    }

    public void validateUserInput() {
        Collection<CommitOptions> collection = this.table.getCommitFiles().values();
        if (this.table != null && collection.size() > 0) {
            for (CommitOptions commitOptions : collection) {
                if (commitOptions == CommitOptions.EXCLUDE) continue;
                this.valid();
                return;
            }
            this.invalid(null);
        } else {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(ImportPreviewStep.class, (String)"CTL_Import_NothingToImport"), true));
        }
    }

    public void setup(final String string, final String string2, final SVNUrl sVNUrl, String string3, final boolean bl) {
        this.importMessage = string3;
        this.support = new PanelProgressSupport(bl ? null : this.previewPanel.progressPanel){

            protected void perform() {
                FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
                File[] fileArray = fileStatusCache.listFiles(ImportPreviewStep.this.context, 6612);
                if (fileArray.length == 0 || this.isCanceled()) {
                    return;
                }
                if (string != null) {
                    ImportPreviewStep.this.table.setRootFile(string, string2);
                }
                ArrayList<SvnFileNode> arrayList = new ArrayList<SvnFileNode>(fileArray.length);
                for (int i = 0; i < fileArray.length; ++i) {
                    File file = fileArray[i];
                    SvnFileNode svnFileNode = new SvnFileNode(file);
                    svnFileNode.getCopy();
                    svnFileNode.getRelativePath();
                    arrayList.add(svnFileNode);
                    if (!this.isCanceled()) continue;
                    return;
                }
                final SvnFileNode[] svnFileNodeArray = arrayList.toArray(new SvnFileNode[fileArray.length]);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ImportPreviewStep.this.table.setNodes(svnFileNodeArray);
                        ImportPreviewStep.this.table.getTableModel().addTableModelListener(new TableModelListener(){

                            public void tableChanged(TableModelEvent tableModelEvent) {
                                ImportPreviewStep.this.validateUserInput();
                            }
                        });
                        ImportPreviewStep.this.validateUserInput();
                        if (bl) {
                            ImportPreviewStep.this.startCommitTask(sVNUrl);
                        }
                    }
                });
            }
        };
        this.support.start(Subversion.getInstance().getRequestProcessor(sVNUrl), sVNUrl, NbBundle.getMessage(ImportPreviewStep.class, (String)"BK1009"));
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    public Map getCommitFiles() {
        return this.table.getCommitFiles();
    }

    public void storeTableSorter() {
    }

    public void startCommitTask(SVNUrl sVNUrl) {
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                CommitAction.performCommit(ImportPreviewStep.this.importMessage, (Map<SvnFileNode, CommitOptions>)ImportPreviewStep.this.getCommitFiles(), ImportPreviewStep.this.context, (SvnProgressSupport)this, true);
            }
        };
        svnProgressSupport.start(Subversion.getInstance().getRequestProcessor(sVNUrl), sVNUrl, NbBundle.getMessage(ImportPreviewStep.class, (String)"LBL_Import_Progress"));
    }
}

