/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.checkout;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.checkout.CheckoutCompleted;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class CheckoutAction
extends CallableSystemAction {
    public void performAction() {
        SvnClient svnClient;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Utils.logVCSActionEvent((String)"SVN");
        CheckoutWizard checkoutWizard = new CheckoutWizard();
        if (!checkoutWizard.show()) {
            return;
        }
        SVNUrl sVNUrl = checkoutWizard.getRepositoryRoot();
        RepositoryFile[] repositoryFileArray = checkoutWizard.getRepositoryFiles();
        File file = checkoutWizard.getWorkdir();
        boolean bl = checkoutWizard.isAtWorkingDirLevel();
        boolean bl2 = SvnModuleConfig.getDefault().getShowCheckoutCompleted();
        try {
            svnClient = Subversion.getInstance().getClient(sVNUrl);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        CheckoutAction.performCheckout(sVNUrl, svnClient, repositoryFileArray, file, bl, bl2);
    }

    public String getName() {
        return NbBundle.getMessage(CheckoutAction.class, (String)"CTL_CheckoutAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static RequestProcessor.Task performCheckout(final SVNUrl sVNUrl, final SvnClient svnClient, final RepositoryFile[] repositoryFileArray, final File file, final boolean bl, final boolean bl2) {
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                try {
                    this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
                    this.setCancellableDelegate(svnClient);
                    CheckoutAction.checkout(svnClient, sVNUrl, repositoryFileArray, file, bl, this);
                }
                catch (SVNClientException sVNClientException) {
                    this.annotate(sVNClientException);
                    return;
                }
                finally {
                    Subversion.getInstance().versionedFilesChanged();
                }
                if (this.isCanceled()) {
                    return;
                }
                this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_ScanFolders_Progress"));
                if (bl2) {
                    CheckoutAction.showCheckoutCompletet(repositoryFileArray, file, bl, this);
                }
            }
        };
        return svnProgressSupport.start(Subversion.getInstance().getRequestProcessor(sVNUrl), sVNUrl, ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
    }

    public static void checkout(SvnClient svnClient, SVNUrl sVNUrl, RepositoryFile[] repositoryFileArray, File file, boolean bl, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        for (int i = 0; i < repositoryFileArray.length; ++i) {
            File file2;
            if (!bl) {
                file2 = new File(file.getAbsolutePath() + "/" + repositoryFileArray[i].getName());
                file2 = FileUtil.normalizeFile((File)file2);
                file2.mkdir();
            } else {
                file2 = file;
            }
            if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
                return;
            }
            svnClient.checkout(repositoryFileArray[i].getFileUrl(), file2, repositoryFileArray[i].getRevision(), true);
            if (svnProgressSupport == null || !svnProgressSupport.isCanceled()) continue;
            return;
        }
    }

    private static void showCheckoutCompletet(RepositoryFile[] repositoryFileArray, File file, boolean bl, SvnProgressSupport svnProgressSupport) {
        String[] stringArray;
        if (bl) {
            stringArray = new String[]{"."};
        } else {
            stringArray = new String[repositoryFileArray.length];
            for (int i = 0; i < repositoryFileArray.length; ++i) {
                if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
                    return;
                }
                stringArray[i] = repositoryFileArray[i].isRepositoryRoot() ? "." : repositoryFileArray[i].getFileUrl().getLastPathSegment();
            }
        }
        CheckoutCompleted checkoutCompleted = new CheckoutCompleted(file, stringArray);
        if (svnProgressSupport != null && svnProgressSupport.isCanceled()) {
            return;
        }
        checkoutCompleted.scanForProjects(svnProgressSupport);
    }
}

