/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.renderer.CheckBoxProvider;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.JRendererCheckBox;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.table.DatePickerCellEditor;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.table.BooleanTableCellEditor;
import org.netbeans.modules.db.dataview.table.DateTimePickerCellEditor;
import org.netbeans.modules.db.dataview.table.JXTableDecorator;
import org.netbeans.modules.db.dataview.table.JXTableRowHeader;
import org.netbeans.modules.db.dataview.table.NumberFieldEditor;
import org.netbeans.modules.db.dataview.table.ResultSetCellRenderer;
import org.netbeans.modules.db.dataview.table.ResultSetTableModel;
import org.netbeans.modules.db.dataview.table.StringTableCellEditor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetJXTable
extends JXTableDecorator {
    private String[] columnToolTips;
    private final int multiplier;
    private static final String data = "WE WILL EITHER FIND A WAY, OR MAKE ONE.";
    private static Logger mLogger = Logger.getLogger(ResultSetJXTable.class.getName());
    protected DataView dView;
    private final List<Integer> columnWidthList;
    private static final int MAX_COLUMN_WIDTH = 25;

    public ResultSetJXTable(DataView dataView) {
        this.dView = dataView;
        this.setShowGrid(true, true);
        this.setGridColor(GRID_COLOR);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnControlVisible(true);
        this.getColumnControl().setToolTipText(NbBundle.getMessage(ResultSetJXTable.class, (String)"ResultSetJXTable.columnControl.tooltip"));
        this.setHorizontalScrollEnabled(true);
        this.setAutoResizeMode(0);
        this.setFillsViewportHeight(true);
        this.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)Color.WHITE, (Color)ALTERNATE_ROW_COLOR)});
        this.addHighlighter((Highlighter)new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, ROLLOVER_ROW_COLOR, null));
        this.setDefaultCellRenderers();
        this.setDefaultCellEditors();
        if (this.dView.getDataViewDBTable() != null) {
            this.columnToolTips = this.dView.getDataViewDBTable().getColumnToolTips();
        }
        this.multiplier = this.getFontMetrics(this.getFont()).stringWidth(data) / data.length() + 4;
        this.columnWidthList = this.getColumnWidthList();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeaderImpl(this.columnModel);
    }

    public void createTableModel(List<Object[]> list, JXTableRowHeader jXTableRowHeader) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        assert (list != null);
        TableModel tableModel = this.createModelFrom(list);
        this.setModel(tableModel);
        if (!this.columnWidthList.isEmpty()) {
            this.setHeader((JTable)((Object)this), this.columnWidthList);
        }
        if (jXTableRowHeader != null) {
            jXTableRowHeader.setTable((JTable)((Object)this));
        }
    }

    protected void setDefaultCellRenderers() {
        this.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new ResultSetCellRenderer()));
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new ResultSetCellRenderer()));
        this.setDefaultRenderer(Number.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)FormatStringValue.NUMBER_TO_STRING, 4)));
        this.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((ComponentProvider)new CheckBoxProvider())));
        this.setDefaultRenderer(Date.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)FormatStringValue.DATE_TO_STRING)));
        this.setDefaultRenderer(Time.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.TIME_TO_STRING)));
        this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.DATETIME_TO_STRING)));
        this.setDefaultRenderer(java.util.Date.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.DATETIME_TO_STRING)));
    }

    protected void setDefaultCellEditors() {
        Object object;
        KeyListener keyListener = this.createControKeyListener();
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(keyListener);
        this.setDefaultEditor(Object.class, new StringTableCellEditor(jTextField));
        this.setDefaultEditor(String.class, new StringTableCellEditor(jTextField));
        this.setDefaultEditor(Time.class, new StringTableCellEditor(jTextField));
        JTextField jTextField2 = new JTextField();
        jTextField.addKeyListener(keyListener);
        this.setDefaultEditor(Number.class, new NumberFieldEditor(jTextField2));
        JRendererCheckBox jRendererCheckBox = new JRendererCheckBox();
        jRendererCheckBox.addKeyListener(keyListener);
        this.setDefaultEditor(Boolean.class, new BooleanTableCellEditor(jRendererCheckBox));
        try {
            object = new DatePickerCellEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
            this.setDefaultEditor(Date.class, (TableCellEditor)object);
        }
        catch (NullPointerException nullPointerException) {
            mLogger.log(Level.WARNING, "While creating DatePickerCellEditor was thrown " + nullPointerException);
        }
        try {
            object = new DateTimePickerCellEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
            ((DateTimePickerCellEditor)object).addKeyListener(keyListener);
            this.setDefaultEditor(Timestamp.class, (TableCellEditor)object);
            this.setDefaultEditor(java.util.Date.class, (TableCellEditor)object);
        }
        catch (NullPointerException nullPointerException) {
            mLogger.log(Level.WARNING, "While creating DateTimePickerCellEditor was thrown " + nullPointerException);
        }
    }

    protected KeyListener createControKeyListener() {
        return new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        };
    }

    private void setHeader(JTable jTable, List<Integer> list) {
        try {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < list.size(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(list.get(i));
            }
            jTable.getTableHeader().setColumnModel(tableColumnModel);
        }
        catch (Exception exception) {
            mLogger.log(Level.INFO, "Failed to set the size of the table headers" + exception);
        }
    }

    private List<Integer> getColumnWidthList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            int n = this.getRSColumnCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                DBColumn dBColumn = this.getDBColumn(i);
                int n3 = dBColumn.getDisplaySize();
                int n4 = Math.max(n3, n2 = dBColumn.getDisplayName().length()) * this.multiplier;
                if (n4 < 5) {
                    n4 = 15 * this.multiplier;
                }
                if (n4 > 25 * this.multiplier) {
                    n4 = 25 * this.multiplier;
                }
                arrayList.add(n4);
            }
        }
        catch (Exception exception) {
            mLogger.log(Level.INFO, "Failed to set the size of the table headers" + exception);
        }
        return arrayList;
    }

    private TableModel createModelFrom(List<Object[]> list) {
        DefaultTableModel defaultTableModel = this.getDefaultTableModel();
        int n = this.getRSColumnCount();
        for (int i = 0; i < n; ++i) {
            DBColumn dBColumn = this.getDBColumn(i);
            defaultTableModel.addColumn(dBColumn.getDisplayName());
        }
        for (Object[] objectArray : list) {
            defaultTableModel.addRow(objectArray);
        }
        return defaultTableModel;
    }

    public DBColumn getDBColumn(int n) {
        DBColumn dBColumn = this.dView.getDataViewDBTable().getColumn(n);
        return dBColumn;
    }

    public int getRSColumnCount() {
        return this.dView.getDataViewDBTable().getColumnCount();
    }

    protected DefaultTableModel getDefaultTableModel() {
        return new ResultSetTableModel(this);
    }

    private class JTableHeaderImpl
    extends JXTableHeader {
        public JTableHeaderImpl(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return this.getColumnToolTipText(mouseEvent);
        }

        protected String getColumnToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.columnModel.getColumnIndexAtX(point.x);
            try {
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return ResultSetJXTable.this.columnToolTips[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
    }
}

