/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.structure.registry;

import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.structure.registry.RegistryScene;
import org.netbeans.modules.vmd.structure.registry.RegistryWidget;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryEditorView
implements DataEditorView,
DescriptorRegistryListener {
    private static final long serialVersionUID = 3328221238376153199L;
    static final String REGISTRY_ID = "registry";
    private DataObjectContext context;
    private transient DescriptorRegistry registry;
    private transient JToolBar toolbarRepresentation;
    private transient JScrollPane scrollPane;
    private transient RegistryScene scene;
    private transient JComponent view;

    public RegistryEditorView() {
    }

    public RegistryEditorView(DataObjectContext dataObjectContext) {
        this.context = dataObjectContext;
        this.init();
    }

    private void init() {
        this.registry = DescriptorRegistry.getDescriptorRegistry((String)this.context.getProjectType(), (String)this.context.getProjectID());
        this.scene = new RegistryScene();
        this.view = this.scene.createView();
        this.scrollPane = new JScrollPane(this.view);
        this.toolbarRepresentation = new JToolBar();
        this.toolbarRepresentation.setFloatable(false);
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.MODEL;
    }

    public boolean canShowSideWindows() {
        return true;
    }

    public Collection<String> getTags() {
        return Collections.emptySet();
    }

    public String preferredID() {
        return REGISTRY_ID;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RegistryEditorView.class, (String)"TITLE_RegistryView");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RegistryEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.scrollPane;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbarRepresentation;
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void componentOpened() {
        this.registry.addRegistryListener((DescriptorRegistryListener)this);
    }

    public void componentClosed() {
        this.registry.removeRegistryListener((DescriptorRegistryListener)this);
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return this.getOrder();
    }

    public int getEditPriority() {
        return -this.getOrder();
    }

    public int getOrder() {
        return 12;
    }

    public void descriptorRegistryUpdated() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryEditorView.this.update();
            }
        });
    }

    private void update() {
        this.registry.readAccess(new Runnable(){

            public void run() {
                RegistryWidget registryWidget = new RegistryWidget((Scene)RegistryEditorView.this.scene, false, null, NbBundle.getMessage(RegistryEditorView.class, (String)"DISP_Descriptors"));
                Collection collection = RegistryEditorView.this.registry.getComponentDescriptors();
                RegistryEditorView.this.scene.clear();
                RegistryEditorView.this.scene.addRootNode("descriptors", registryWidget);
                RegistryEditorView.this.updateForSuper(collection, null, registryWidget);
                registryWidget = new RegistryWidget((Scene)RegistryEditorView.this.scene, false, null, NbBundle.getMessage(RegistryEditorView.class, (String)"DISP_Producers"));
                RegistryEditorView.this.scene.addRootNode("producers", registryWidget);
                for (ComponentProducer componentProducer : RegistryEditorView.this.registry.getComponentProducers()) {
                    RegistryWidget registryWidget2;
                    PaletteDescriptor paletteDescriptor = componentProducer.getPaletteDescriptor();
                    if (paletteDescriptor != null) {
                        String string = paletteDescriptor.getSmallIcon();
                        Image image = string != null ? ImageUtilities.loadImage((String)string) : null;
                        registryWidget2 = new RegistryWidget((Scene)RegistryEditorView.this.scene, true, image, paletteDescriptor.getDisplayName());
                    } else {
                        registryWidget2 = new RegistryWidget((Scene)RegistryEditorView.this.scene, false, null, componentProducer.getMainComponentTypeID().toString());
                    }
                    registryWidget.addSub("producer:" + componentProducer.getProducerID(), registryWidget2);
                }
                RegistryEditorView.this.scene.validate();
            }
        });
    }

    private void updateForSuper(Collection<ComponentDescriptor> collection, ComponentDescriptor componentDescriptor, RegistryWidget registryWidget) {
        for (ComponentDescriptor componentDescriptor2 : collection) {
            RegistryWidget registryWidget2;
            if (componentDescriptor2.getSuperDescriptor() != componentDescriptor) continue;
            PaletteDescriptor paletteDescriptor = componentDescriptor2.getPaletteDescriptor();
            if (paletteDescriptor != null) {
                String string = paletteDescriptor.getSmallIcon();
                Image image = string != null ? ImageUtilities.loadImage((String)string) : null;
                registryWidget2 = new RegistryWidget((Scene)this.scene, true, image, paletteDescriptor.getDisplayName());
            } else {
                registryWidget2 = new RegistryWidget((Scene)this.scene, false, null, componentDescriptor2.getTypeDescriptor().getThisType().toString());
            }
            registryWidget.addSub("descriptor:" + componentDescriptor2.getTypeDescriptor().getThisType(), registryWidget2);
            this.updateForSuper(collection, componentDescriptor2, registryWidget2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.context);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }
}

