/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.railsprojects.FindFileListener;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.modules.ruby.railsprojects.GeneratorPanel;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputListener;

public final class GenerateAction
extends NodeAction {
    public static final String EDITOR_ACTION_NAME = "rails-generator";
    private static final Logger LOGGER = Logger.getLogger(GenerateAction.class.getName());
    private boolean forcing;
    private boolean preview;

    protected void performAction(Node[] nodeArray) {
        RubyPlatform rubyPlatform;
        DataObject dataObject;
        Lookup lookup = nodeArray[0].getLookup();
        RailsProject railsProject = (RailsProject)((Object)lookup.lookup(RailsProject.class));
        if (railsProject == null) {
            dataObject = (DataObject)lookup.lookup(DataObject.class);
            if (dataObject == null) {
                return;
            }
            rubyPlatform = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            if (rubyPlatform instanceof RailsProject) {
                railsProject = (RailsProject)rubyPlatform;
            }
        }
        if (railsProject == null) {
            return;
        }
        dataObject = railsProject.getProjectDirectory().getFileObject("vendor/rails/railties");
        rubyPlatform = RubyPlatform.platformFor((Project)railsProject);
        if (dataObject == null && !rubyPlatform.hasValidRails(true)) {
            LOGGER.warning("No valid Rails installation found, platform is:" + RubyPlatform.platformFor((Project)railsProject));
            return;
        }
        Generator generator = (Generator)nodeArray[0].getLookup().lookup(Generator.class);
        if (generator == null) {
            generator = Generator.CONTROLLER;
        }
        this.generate(railsProject, generator, null, null, false, false);
    }

    public void generate(Project project, String string, String string2, String string3) {
        assert (string.equals("controller")) : "Only the controller generator is supported";
        Generator generator = Generator.CONTROLLER;
        if (project != null) {
            this.generate((RailsProject)project, generator, string2, string3, true, true);
        } else assert (false);
    }

    public void generate(final RailsProject railsProject, Generator generator, String string, String string2, boolean bl, boolean bl2) {
        String string3;
        final JButton jButton = new JButton(NbBundle.getMessage(GenerateAction.class, (String)"Ok"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateAction.class, (String)"AD_Ok"));
        final GeneratorPanel generatorPanel = new GeneratorPanel((Project)railsProject, generator);
        if (bl2) {
            generatorPanel.setForcing(false);
        } else {
            generatorPanel.setForcing(this.forcing);
        }
        generatorPanel.setPretend(this.preview);
        if (string != null) {
            generatorPanel.setInitialState(string, string2);
        }
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        generatorPanel.setChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jButton.setEnabled(generatorPanel.isDataValid());
            }
        });
        jButton.setEnabled(bl);
        String string4 = ProjectUtils.getInformation((Project)railsProject).getDisplayName();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)generatorPanel, NbBundle.getMessage(GenerateAction.class, (String)"GeneratorTitle", (Object)string4), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(-1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GenerateAction.class, (String)"AD_GeneratorDialog"));
        dialog.setVisible(true);
        boolean bl3 = dialogDescriptor.getValue() != objectArray[0];
        dialog.dispose();
        if (!bl2) {
            this.forcing = generatorPanel.isForce();
        }
        this.preview = generatorPanel.isPretend();
        if (!bl3 && (string3 = generatorPanel.getType()).length() > 0) {
            String[] stringArray;
            String[] stringArray2;
            final FileObject fileObject = railsProject.getProjectDirectory();
            final File file = FileUtil.toFile((FileObject)railsProject.getProjectDirectory());
            final String string5 = "script" + File.separator + generatorPanel.getScript();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string3);
            if (generatorPanel.isForce()) {
                arrayList.add("--force");
            } else {
                arrayList.add("--skip");
            }
            if (generatorPanel.isPretend()) {
                arrayList.add("--pretend");
            }
            if ((stringArray2 = Utilities.parseParameters((String)generatorPanel.getGeneratedName())) != null) {
                stringArray = stringArray2;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string6 = stringArray[i];
                    arrayList.add(string6);
                }
            }
            if ((stringArray = generatorPanel.getFirstParameterList()) != null && stringArray.length > 0 && stringArray[0].length() > 0) {
                for (String string7 : stringArray) {
                    arrayList.add(string7);
                }
                String[] stringArray3 = generatorPanel.getSecondParameterList();
                if (stringArray3 != null && stringArray3.length > 0 && stringArray3[0].length() > 0) {
                    for (String string8 : stringArray3) {
                        arrayList.add(string8);
                    }
                }
            }
            final String[] stringArray4 = arrayList.toArray(new String[arrayList.size()]);
            try {
                final String string9 = railsProject.evaluator().getProperty("source.encoding");
                railsProject.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        DirectoryFileLocator directoryFileLocator = new DirectoryFileLocator(fileObject);
                        StatefulConvertor statefulConvertor = new StatefulConvertor((LineConvertors.FileLocator)directoryFileLocator, RailsProjectGenerator.RAILS_GENERATOR_PATTERN, RubyLineConvertorFactory.EXT_RE, 2, -1);
                        String string = NbBundle.getMessage(GenerateAction.class, (String)"RailsGenerator");
                        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(RubyPlatform.platformFor((Project)railsProject), string, file, string5).additionalArgs(stringArray4).fileLocator((LineConvertors.FileLocator)directoryFileLocator).addStandardRecognizers().addOutConvertor((LineConvertor)statefulConvertor).addErrConvertor((LineConvertor)statefulConvertor);
                        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor, string9);
                        Future future = ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)string).run();
                        try {
                            future.get();
                        }
                        catch (InterruptedException interruptedException) {
                            Exceptions.printStackTrace((Throwable)interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            Exceptions.printStackTrace((Throwable)executionException);
                        }
                        railsProject.getProjectDirectory().getFileSystem().refresh(true);
                        List<ExecutionUtils.FileLocation> list = statefulConvertor.getLocations();
                        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
                        for (int i = list.size() - 1; i >= 0; --i) {
                            FileObject fileObject2;
                            ExecutionUtils.FileLocation fileLocation = list.get(i);
                            String string2 = fileLocation.file;
                            if (string2 == null || (fileObject2 = directoryFileLocator.find(string2)) == null) continue;
                            String string3 = fileObject2.getMIMEType();
                            if (string3.equals("text/x-ruby")) {
                                arrayList.add(fileObject2);
                                continue;
                            }
                            if (!string3.equals("application/x-httpd-eruby")) continue;
                            arrayList2.add(fileObject2);
                        }
                        if (arrayList2.size() <= 4) {
                            for (FileObject fileObject3 : arrayList2) {
                                OutputProcessor.open((FileObject)fileObject3, (int)1);
                            }
                        }
                        if (arrayList.size() <= 4) {
                            for (FileObject fileObject4 : arrayList) {
                                OutputProcessor.open((FileObject)fileObject4, (int)1);
                            }
                        }
                    }
                });
                railsProject.getProjectDirectory().getFileSystem().refresh(true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(GenerateAction.class, (String)EDITOR_ACTION_NAME);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        Lookup lookup = nodeArray[0].getLookup();
        RailsProject railsProject = (RailsProject)((Object)lookup.lookup(RailsProject.class));
        if (railsProject != null) {
            return true;
        }
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        return dataObject != null;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        Node[] nodeArray;
        Node node;
        DataObject dataObject = (DataObject)jTextComponent.getDocument().getProperty("stream");
        if (dataObject != null && (node = dataObject.getNodeDelegate()) != null && this.enable(nodeArray = new Node[]{node})) {
            this.performAction(nodeArray);
        }
    }

    public boolean appliesTo(String string) {
        return "application/x-httpd-eruby".equals(string) || "text/x-ruby".equals(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatefulConvertor
    implements LineConvertor {
        private final LineConvertors.FileLocator locator;
        private final Pattern linePattern;
        private final Pattern filePattern;
        private final int fileGroup;
        private final int lineGroup;
        private final List<ExecutionUtils.FileLocation> locations = new ArrayList<ExecutionUtils.FileLocation>();

        public StatefulConvertor(LineConvertors.FileLocator fileLocator, Pattern pattern, Pattern pattern2, int n, int n2) {
            this.locator = fileLocator;
            this.linePattern = pattern;
            this.fileGroup = n;
            this.lineGroup = n2;
            this.filePattern = pattern2;
        }

        public synchronized List<ConvertedLine> convert(String string) {
            if (string.length() > 400) {
                return null;
            }
            Matcher matcher = this.linePattern.matcher(string);
            if (matcher.matches()) {
                String string2 = null;
                int n = -1;
                if (this.fileGroup >= 0) {
                    string2 = matcher.group(this.fileGroup);
                    if (string2.startsWith("\"")) {
                        string2 = string2.substring(1);
                    }
                    if (string2.startsWith("./")) {
                        string2 = string2.substring(2);
                    }
                    if (this.filePattern != null && !this.filePattern.matcher(string2).matches()) {
                        return null;
                    }
                }
                if (this.lineGroup >= 0) {
                    String string3 = matcher.group(this.lineGroup);
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.log(Level.INFO, null, numberFormatException);
                        n = 0;
                    }
                }
                if (!string.trim().startsWith("skip")) {
                    this.locations.add(new ExecutionUtils.FileLocation(string2, n));
                }
                return Collections.singletonList(ConvertedLine.forText((String)string, (OutputListener)new FindFileListener(string2, n, this.locator)));
            }
            return null;
        }

        synchronized List<ExecutionUtils.FileLocation> getLocations() {
            return this.locations;
        }
    }

    public static class EditorAction
    extends BaseAction {
        public EditorAction() {
            super(GenerateAction.EDITOR_ACTION_NAME, 0);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            ((GenerateAction)SystemAction.get(GenerateAction.class)).actionPerformed(actionEvent, jTextComponent);
        }

        public Class getShortDescriptionBundleClass() {
            return GenerateAction.class;
        }
    }
}

