/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.metamodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUnit {
    public static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    public static final String FACES_CONFIG = "faces-config.xml";
    private final ClassPath myBootPath;
    private final ClassPath myCompilePath;
    private final ClassPath mySourcePath;
    private File myMainFacesConfig;
    private final WebModule myModule;
    private final FileObject[] myConfigFiles;

    public static ModelUnit create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, File file) {
        return new ModelUnit(classPath, classPath2, classPath3, file, null);
    }

    public static ModelUnit create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        return new ModelUnit(classPath, classPath2, classPath3, null);
    }

    public static ModelUnit create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, FileObject[] fileObjectArray) {
        return new ModelUnit(classPath, classPath2, classPath3, null, fileObjectArray);
    }

    public static ModelUnit create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, WebModule webModule) {
        return new ModelUnit(classPath, classPath2, classPath3, webModule);
    }

    private ModelUnit(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, File file, FileObject[] fileObjectArray) {
        this.myBootPath = classPath;
        this.myCompilePath = classPath2;
        this.mySourcePath = classPath3;
        this.myMainFacesConfig = file;
        this.myConfigFiles = fileObjectArray;
        this.myModule = null;
        this.getConfigFiles();
    }

    private ModelUnit(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, WebModule webModule) {
        this.myBootPath = classPath;
        this.myCompilePath = classPath2;
        this.mySourcePath = classPath3;
        if (webModule != null) {
            FileObject[] fileObjectArray = ConfigurationUtils.getFacesConfigFiles(webModule);
            this.myMainFacesConfig = fileObjectArray != null && fileObjectArray.length > 0 ? FileUtil.toFile((FileObject)fileObjectArray[0]) : null;
        }
        this.myModule = webModule;
        this.myConfigFiles = null;
        this.getConfigFiles();
    }

    public ClassPath getBootPath() {
        return this.myBootPath;
    }

    public ClassPath getCompilePath() {
        return this.myCompilePath;
    }

    public ClassPath getSourcePath() {
        return this.mySourcePath;
    }

    public synchronized FileObject getMainFacesConfig() {
        if (this.myMainFacesConfig != null && !this.myMainFacesConfig.exists()) {
            this.myMainFacesConfig = null;
        }
        return this.myMainFacesConfig != null ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.myMainFacesConfig)) : null;
    }

    public synchronized List<FileObject> getConfigFiles() {
        Object object;
        FileObject[] fileObjectArray = this.myModule == null ? this.myConfigFiles : ConfigurationUtils.getFacesConfigFiles(this.myModule);
        HashSet<Object> hashSet = fileObjectArray != null ? new HashSet<FileObject>(Arrays.asList(fileObjectArray)) : new HashSet();
        if (this.myMainFacesConfig == null && (object = this.getSourcePath().findAllResources("WEB-INF/faces-config.xml")) != null && object.size() > 0) {
            this.myMainFacesConfig = FileUtil.toFile((FileObject)((FileObject)object.get(0)));
        }
        if (this.myMainFacesConfig != null) {
            hashSet.add(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.myMainFacesConfig)));
        }
        object = ".faces-config.xml";
        for (FileObject fileObject : this.getSourcePath().getRoots()) {
            FileObject[] fileObjectArray2;
            FileObject fileObject2 = fileObject.getFileObject(META_INF);
            if (fileObject2 == null) continue;
            for (FileObject fileObject3 : fileObjectArray2 = fileObject2.getChildren()) {
                String string = fileObject3.getNameExt();
                if (!string.equals(FACES_CONFIG) && !string.endsWith((String)object)) continue;
                hashSet.add(fileObject3);
            }
        }
        return new ArrayList<Object>(hashSet);
    }
}

