/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.netbeans.modules.search.CleanTask;
import org.netbeans.modules.search.IssuesPanel;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultViewPanel;
import org.netbeans.modules.search.SearchTask;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ResultView
extends TopComponent {
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final String ID = "search-results";
    private static Reference<ResultView> instance = null;
    private JPopupMenu pop;
    private PopupListener popL;
    private CloseListener closeL;
    private JPanel emptyPanel;
    private final CardLayout contentCards;
    private Map<SearchTask, ResultViewPanel> searchToViewMap = new HashMap<SearchTask, ResultViewPanel>();
    private Map<ResultViewPanel, SearchTask> viewToSearchMap = new HashMap<ResultViewPanel, SearchTask>();
    private Map<ReplaceTask, SearchTask> replaceToSearchMap = new HashMap<ReplaceTask, SearchTask>();
    private Map<SearchTask, ReplaceTask> searchToReplaceMap = new HashMap<SearchTask, ReplaceTask>();

    static synchronized ResultView getInstance() {
        ResultView resultView = (ResultView)WindowManager.getDefault().findTopComponent(ID);
        if (resultView == null) {
            resultView = ResultView.getDefault();
        }
        return resultView;
    }

    public static synchronized ResultView getDefault() {
        ResultView resultView;
        if (instance == null) {
            resultView = new ResultView();
            instance = new WeakReference<ResultView>(resultView);
        } else {
            resultView = instance.get();
            if (resultView == null) {
                resultView = new ResultView();
                instance = new WeakReference<ResultView>(resultView);
            }
        }
        return resultView;
    }

    private ResultView() {
        this.contentCards = new CardLayout();
        this.setLayout(this.contentCards);
        this.setName("Search Results");
        this.setDisplayName(NbBundle.getMessage(ResultView.class, (String)"TITLE_SEARCH_RESULTS"));
        this.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TOOLTIP_SEARCH_RESULTS"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/search/res/find.gif"));
        this.initAccessibility();
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.popL = new PopupListener();
        this.closeL = new CloseListener();
        this.initActions();
        this.emptyPanel = new JPanel();
        this.add(this.emptyPanel, "Center");
        if (isMacLaf) {
            this.emptyPanel.setBackground(macBackground);
            this.setBackground(macBackground);
            this.setOpaque(true);
        }
    }

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("jumpNext", new PrevNextAction(false));
        actionMap.put("jumpPrev", new PrevNextAction(true));
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultView.getDefault();
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(ResultView.class);
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ResultViewTopComponent"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ResultViewTopComponent"));
    }

    public void fillOutput() {
        this.getCurrentResultViewPanel().fillOutput();
    }

    void closeResults() {
        this.close();
    }

    void displayIssuesToUser(ReplaceTask replaceTask, String string, String[] stringArray, boolean bl) {
        assert (EventQueue.isDispatchThread());
        IssuesPanel issuesPanel = new IssuesPanel(string, stringArray);
        if (isMacLaf) {
            issuesPanel.setBackground(macBackground);
        }
        this.searchToViewMap.get(this.replaceToSearchMap.get(replaceTask)).displayIssues(issuesPanel);
        if (!this.isOpened()) {
            this.open();
        }
        if (bl) {
            this.requestAttention(true);
        }
    }

    protected void componentOpened() {
        assert (EventQueue.isDispatchThread());
        Manager.getInstance().searchWindowOpened();
        ResultViewPanel resultViewPanel = this.getCurrentResultViewPanel();
        if (resultViewPanel != null) {
            resultViewPanel.componentOpened();
        }
    }

    public void requestFocus() {
        ResultViewPanel resultViewPanel = this.getCurrentResultViewPanel();
        if (resultViewPanel != null) {
            resultViewPanel.tree.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        ResultViewPanel resultViewPanel = this.getCurrentResultViewPanel();
        if (resultViewPanel != null) {
            return resultViewPanel.tree.requestFocusInWindow();
        }
        return false;
    }

    private ResultViewPanel getCurrentResultViewPanel() {
        Component component;
        if (this.getComponentCount() > 0 && ((component = this.getComponent(0)) instanceof JTabbedPane ? (component = ((JTabbedPane)component).getSelectedComponent()) instanceof ResultViewPanel : component instanceof ResultViewPanel)) {
            return (ResultViewPanel)component;
        }
        return null;
    }

    private void addTabPanel(JPanel jPanel) {
        Component component = this.getComponent(0);
        if (component instanceof JTabbedPane) {
            ((JTabbedPane)component).addTab(this.getTabTitle(jPanel), null, jPanel, jPanel.getToolTipText());
            ((JTabbedPane)component).setSelectedComponent(jPanel);
            component.validate();
        } else {
            this.remove(component);
            JTabbedPane jTabbedPane = TabbedPaneFactory.createCloseButtonTabbedPane();
            jTabbedPane.setMinimumSize(new Dimension(0, 0));
            jTabbedPane.addMouseListener((MouseListener)((Object)this.popL));
            jTabbedPane.addPropertyChangeListener(this.closeL);
            if (isMacLaf) {
                jTabbedPane.setBackground(macBackground);
                jTabbedPane.setOpaque(true);
            }
            this.add(jTabbedPane, "Center");
            if (component instanceof ResultViewPanel) {
                jTabbedPane.addTab(this.getTabTitle(component), null, component, ((JPanel)component).getToolTipText());
            }
            jTabbedPane.addTab(this.getTabTitle(jPanel), null, jPanel, jPanel.getToolTipText());
            jTabbedPane.setSelectedComponent(jPanel);
            jTabbedPane.validate();
        }
        this.validate();
        this.requestActive();
    }

    private String getTabTitle(Component component) {
        return NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_RESULTS_FOR_X", (Object)String.valueOf(component.getName())) + "   ";
    }

    private void updateTabTitle(JPanel jPanel) {
        Component component;
        if (this.getComponentCount() != 0 && (component = this.getComponent(0)) instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            int n = jTabbedPane.indexOfComponent(jPanel);
            jTabbedPane.setTitleAt(n, this.getTabTitle(jPanel));
            jTabbedPane.setToolTipTextAt(n, jPanel.getToolTipText());
        }
    }

    private void removePanel(JPanel jPanel) {
        Object object;
        Object object2;
        Component component;
        Component component2 = component = this.getComponentCount() > 0 ? this.getComponent(0) : null;
        if (component instanceof JTabbedPane) {
            object2 = (JTabbedPane)component;
            if (jPanel == null) {
                jPanel = (JPanel)((JTabbedPane)object2).getSelectedComponent();
            }
            if (((ResultViewPanel)(object = (ResultViewPanel)jPanel)).isSearchInProgress()) {
                Manager.getInstance().stopSearching(this.viewToSearchMap.get(jPanel));
            }
            ((JTabbedPane)object2).remove(jPanel);
            if (((Container)object2).getComponentCount() == 1) {
                Component component3 = ((Container)object2).getComponent(0);
                ((Component)object2).removeMouseListener((MouseListener)((Object)this.popL));
                ((Component)object2).removePropertyChangeListener(this.closeL);
                this.remove((Component)object2);
                this.add(component3, "Center");
                this.setName(((JPanel)component3).getToolTipText());
            }
        } else if (component instanceof ResultViewPanel) {
            object2 = (ResultViewPanel)component;
            if (((ResultViewPanel)object2).isSearchInProgress()) {
                Manager.getInstance().stopSearching(this.viewToSearchMap.get(component));
            }
            this.remove(component);
            this.add(this.emptyPanel, "Center");
            this.close();
        } else {
            this.close();
        }
        Manager.getInstance().scheduleCleanTask(new CleanTask(this.viewToSearchMap.get(jPanel).getResultModel()));
        object2 = this.viewToSearchMap.remove(jPanel);
        this.searchToViewMap.remove(object2);
        object = this.searchToReplaceMap.remove(object2);
        this.replaceToSearchMap.remove(object);
        this.validate();
    }

    protected void componentClosed() {
        assert (EventQueue.isDispatchThread());
        Manager.getInstance().searchWindowClosed();
    }

    void notifySearchPending(SearchTask searchTask, int n) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel resultViewPanel = searchTask.getResultModel().getResultView();
        resultViewPanel.removeIssuesPanel();
        String string = null;
        switch (n) {
            case 8: {
                string = "TEXT_FINISHING_REPLACE";
                break;
            }
            case 1: {
                string = "TEXT_FINISHING_PREV_SEARCH";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        resultViewPanel.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)string));
        resultViewPanel.setBtnStopEnabled(true);
        resultViewPanel.setBtnReplaceEnabled(false);
    }

    void searchTaskStateChanged(SearchTask searchTask, int n) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel resultViewPanel = searchTask.getResultModel().getResultView();
        switch (n) {
            case 1: {
                resultViewPanel.removeIssuesPanel();
                this.updateTabTitle(resultViewPanel);
                resultViewPanel.searchStarted();
                break;
            }
            case 2: {
                resultViewPanel.searchFinished();
                break;
            }
            case 3: {
                resultViewPanel.searchInterrupted();
                break;
            }
            case 4: {
                resultViewPanel.searchCancelled();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void showAllDetailsFinished() {
        assert (EventQueue.isDispatchThread());
    }

    void addSearchPair(ResultViewPanel resultViewPanel, SearchTask searchTask) {
        if (searchTask != null && resultViewPanel != null) {
            SearchTask searchTask2 = this.viewToSearchMap.get(resultViewPanel);
            if (searchTask2 != null) {
                this.searchToViewMap.remove(searchTask2);
            }
            this.searchToViewMap.put(searchTask, resultViewPanel);
            this.viewToSearchMap.put(resultViewPanel, searchTask);
        }
    }

    void addReplacePair(ReplaceTask replaceTask, ResultViewPanel resultViewPanel) {
        if (replaceTask != null && resultViewPanel != null) {
            SearchTask searchTask = this.viewToSearchMap.get(resultViewPanel);
            this.replaceToSearchMap.put(replaceTask, searchTask);
            this.searchToReplaceMap.put(searchTask, replaceTask);
        }
    }

    synchronized ResultViewPanel initiateResultView(SearchTask searchTask) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel resultViewPanel = this.searchToViewMap.get(searchTask);
        if (resultViewPanel == null) {
            resultViewPanel = new ResultViewPanel(searchTask);
            if (isMacLaf) {
                resultViewPanel.setBackground(macBackground);
            }
            this.addSearchPair(resultViewPanel, searchTask);
            resultViewPanel.setName(searchTask.getSearchCriteria().getTextPatternExpr());
            this.addTabPanel(resultViewPanel);
        } else {
            resultViewPanel.setName(searchTask.getSearchCriteria().getTextPatternExpr());
        }
        return resultViewPanel;
    }

    void closeAndSendFocusToEditor(ReplaceTask replaceTask) {
        TopComponent topComponent;
        assert (EventQueue.isDispatchThread());
        this.removePanel(this.searchToViewMap.get(this.replaceToSearchMap.get(replaceTask)));
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null && (topComponent = mode.getSelectedTopComponent()) != null) {
            topComponent.requestActive();
        }
    }

    void rescan(ReplaceTask replaceTask) {
        ResultViewPanel resultViewPanel;
        assert (EventQueue.isDispatchThread());
        SearchTask searchTask = this.replaceToSearchMap.get(replaceTask);
        SearchTask searchTask2 = searchTask.createNewGeneration();
        if (searchTask.getResultModel() != null && (resultViewPanel = searchTask.getResultModel().getResultView()) != null) {
            ResultView.getInstance().addSearchPair(searchTask.getResultModel().getResultView(), searchTask2);
            resultViewPanel.removeIssuesPanel();
        }
        Manager.getInstance().scheduleSearchTask(searchTask2);
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void closeAll(boolean bl) {
        Component component = this.getComponent(0);
        if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            Component component2 = jTabbedPane.getSelectedComponent();
            Component[] componentArray = jTabbedPane.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (bl && componentArray[i] == component2 || !(componentArray[i] instanceof ResultViewPanel)) continue;
                this.removePanel((ResultViewPanel)componentArray[i]);
            }
        }
    }

    private final class PrevNextAction
    extends AbstractAction {
        private boolean prev;

        public PrevNextAction(boolean bl) {
            this.prev = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResultViewPanel resultViewPanel = ResultView.this.getCurrentResultViewPanel();
            if (resultViewPanel != null) {
                resultViewPanel.goToNext(!this.prev);
            }
        }
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseAllButCurrent"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResultView.this.closeAll(true);
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseAll"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResultView.this.closeAll(false);
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseWindow"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResultView.this.removePanel(null);
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            ResultView.this.pop.show((Component)((Object)ResultView.this), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("close".equals(propertyChangeEvent.getPropertyName())) {
                ResultView.this.removePanel((JPanel)propertyChangeEvent.getNewValue());
            }
        }
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7398708142639457544L;

        public Object readResolve() {
            return ResultView.getDefault();
        }
    }
}

