/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.ButtonWithExtraInfo;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ListComboBoxModel;
import org.netbeans.modules.search.SearchScope;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BasicSearchForm
extends JPanel
implements ChangeListener,
ItemListener {
    private final BasicSearchCriteria searchCriteria;
    private final Map<SearchScope, Boolean> searchScopes;
    private final String preferredSearchScopeType;
    private SearchScope selectedSearchScope;
    private ChangeListener usabilityChangeListener;
    private ButtonGroup radioBtnGroup;
    private JComboBox cboxTextToFind;
    private JComboBox cboxReplacement;
    private JComboBox cboxFileNamePattern;
    private JCheckBox chkWholeWords;
    private JCheckBox chkCaseSensitive;
    private JCheckBox chkRegexp;
    private JTextComponent textToFindEditor;
    private JTextComponent fileNamePatternEditor;
    private JTextComponent replacementPatternEditor;
    private JLabel lblHintTextToFind;
    private Color errorTextColor;
    private Color defaultTextColor;
    private boolean invalidTextPattern = false;
    private boolean invalidReplacePattern = false;
    private boolean ignoreFileNamePatternChanges = false;

    BasicSearchForm(Map<SearchScope, Boolean> map, String string, BasicSearchCriteria basicSearchCriteria, boolean bl, boolean bl2) {
        this.searchCriteria = basicSearchCriteria != null ? basicSearchCriteria : new BasicSearchCriteria();
        this.searchScopes = map;
        this.preferredSearchScopeType = string;
        this.initComponents(bl);
        this.initAccessibility();
        this.initHistory();
        this.initInteraction();
        if (bl && this.searchCriteria.getReplaceExpr() == null) {
            this.searchCriteria.setReplaceExpr("");
        }
        if (bl2) {
            this.initPreviousValues();
        } else {
            this.initValuesFromHistory();
        }
        this.updateTextPatternColor();
        if (bl) {
            this.updateReplacePatternColor();
        }
    }

    private void initComponents(boolean bl) {
        JLabel jLabel;
        JLabel jLabel2 = new JLabel();
        this.cboxTextToFind = new JComboBox();
        jLabel2.setLabelFor(this.cboxTextToFind);
        this.lblHintTextToFind = new JLabel();
        this.lblHintTextToFind.setMinimumSize(new Dimension(0, 0));
        if (bl) {
            jLabel = new JLabel();
            this.cboxReplacement = new JComboBox();
            this.cboxReplacement.getAccessibleContext().setAccessibleDescription(this.getText("BasicSearchForm.cbox.Replacement.AccessibleDescription"));
            jLabel.setLabelFor(this.cboxReplacement);
        } else {
            jLabel = null;
            this.cboxReplacement = null;
        }
        JLabel jLabel3 = new JLabel();
        this.cboxFileNamePattern = new JComboBox();
        jLabel3.setLabelFor(this.cboxFileNamePattern);
        JLabel jLabel4 = new JLabel();
        this.chkWholeWords = new JCheckBox();
        this.chkCaseSensitive = new JCheckBox();
        this.chkRegexp = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)this.getText("BasicSearchForm.lblTextToFind.text"));
        this.lblHintTextToFind.setText(this.getText("BasicSearchForm.lblHintTextToFind.text"));
        this.lblHintTextToFind.setForeground(SystemColor.textInactiveText);
        this.cboxTextToFind.setEditable(true);
        if (bl) {
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)this.getText("BasicSearchForm.lblReplacement.text"));
            this.cboxReplacement.setEditable(true);
        }
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)this.getText("BasicSearchForm.lblFileNamePattern.text"));
        jLabel4.setText(this.getText("BasicSearchForm.lblHintFileNamePattern.text"));
        jLabel4.setForeground(SystemColor.textInactiveText);
        this.cboxFileNamePattern.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkWholeWords, (String)this.getText("BasicSearchForm.chkWholeWords.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkCaseSensitive, (String)this.getText("BasicSearchForm.chkCaseSensitive.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkRegexp, (String)this.getText("BasicSearchForm.chkRegexp.text"));
        JComponent jComponent = this.createButtonsPanel("LBL_OptionsPanelTitle", this.chkWholeWords, this.chkCaseSensitive, this.chkRegexp);
        JComponent jComponent2 = this.createButtonsPanel("LBL_ScopePanelTitle", this.createSearchScopeButtons());
        GridLayout gridLayout = new GridLayout(1, 0);
        JPanel jPanel = new JPanel(gridLayout);
        jPanel.add(jComponent);
        jPanel.add(jComponent2);
        gridLayout.setHgap(LayoutStyle.getSharedInstance().getPreferredGap(jComponent, jComponent2, 1, 3, null));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHonorsVisibility(false);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)BasicSearchForm.createParallelGroup(groupLayout, 1, jLabel2, jLabel, jLabel3)).addPreferredGap(0).add((GroupLayout.Group)BasicSearchForm.createParallelGroup(groupLayout, 1, jLabel4, this.lblHintTextToFind, this.cboxTextToFind, this.cboxReplacement, this.cboxFileNamePattern))).add((Component)jPanel)).addContainerGap());
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        sequentialGroup.addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.cboxTextToFind, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblHintTextToFind);
        if (this.cboxReplacement != null) {
            sequentialGroup.addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)this.cboxReplacement, -2, -1, -2)).addPreferredGap(0);
        }
        sequentialGroup.addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel3).add((Component)this.cboxFileNamePattern, -2, -1, -2)).addPreferredGap(0).add((Component)jLabel4).addPreferredGap(1).add((Component)jPanel, -2, -1, -2).addContainerGap();
        groupLayout.setVerticalGroup((GroupLayout.Group)sequentialGroup);
        Component component = this.cboxTextToFind.getEditor().getEditorComponent();
        this.textToFindEditor = (JTextComponent)component;
        component = this.cboxFileNamePattern.getEditor().getEditorComponent();
        this.fileNamePatternEditor = (JTextComponent)component;
        if (this.cboxReplacement != null) {
            component = this.cboxReplacement.getEditor().getEditorComponent();
            this.replacementPatternEditor = (JTextComponent)component;
        }
    }

    private static GroupLayout.ParallelGroup createParallelGroup(GroupLayout groupLayout, int n, Component ... componentArray) {
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(n);
        for (Component component : componentArray) {
            if (component == null) continue;
            if (component.getClass() == JComboBox.class) {
                parallelGroup.add(component, 0, 300, Short.MAX_VALUE);
                continue;
            }
            parallelGroup.add(component);
        }
        return parallelGroup;
    }

    private void initAccessibility() {
        this.chkCaseSensitive.getAccessibleContext().setAccessibleDescription(this.getText("BasicSearchForm.chkCaseSensitive.AccessibleDescription"));
        this.chkRegexp.getAccessibleContext().setAccessibleDescription(this.getText("BasicSearchForm.chkRegexp.AccessibleDescription"));
        this.chkWholeWords.getAccessibleContext().setAccessibleDescription(this.getText("BasicSearchForm.chkWholeWords.AccessibleDescription"));
    }

    private void initPreviousValues() {
        this.cboxTextToFind.setSelectedItem(this.searchCriteria.getTextPatternExpr());
        this.cboxFileNamePattern.setSelectedItem(this.searchCriteria.getFileNamePatternExpr());
        if (this.cboxReplacement != null) {
            this.cboxReplacement.setSelectedItem(this.searchCriteria.getReplaceExpr());
        }
        this.chkWholeWords.setSelected(this.searchCriteria.isWholeWords());
        this.chkCaseSensitive.setSelected(this.searchCriteria.isCaseSensitive());
        this.chkRegexp.setSelected(this.searchCriteria.isRegexp());
    }

    private void initInteraction() {
        TextFieldFocusListener textFieldFocusListener = new TextFieldFocusListener();
        this.textToFindEditor.addFocusListener(textFieldFocusListener);
        if (this.replacementPatternEditor != null) {
            this.replacementPatternEditor.addFocusListener(textFieldFocusListener);
        }
        FileNamePatternWatcher fileNamePatternWatcher = new FileNamePatternWatcher(this.fileNamePatternEditor);
        this.fileNamePatternEditor.addFocusListener(fileNamePatternWatcher);
        this.fileNamePatternEditor.addHierarchyListener(fileNamePatternWatcher);
        class PatternChangeListener
        implements DocumentListener {
            private final JComboBox sourceComboBox;

            PatternChangeListener(JComboBox jComboBox) {
                this.sourceComboBox = jComboBox;
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            private void update(DocumentEvent documentEvent) {
                String string;
                if (this.sourceComboBox == BasicSearchForm.this.cboxFileNamePattern && BasicSearchForm.this.ignoreFileNamePatternChanges) {
                    return;
                }
                Document document = documentEvent.getDocument();
                try {
                    string = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    assert (false);
                    ErrorManager.getDefault().notify(65536, (Throwable)badLocationException);
                    string = "";
                }
                if (this.sourceComboBox == BasicSearchForm.this.cboxTextToFind) {
                    BasicSearchForm.this.searchCriteria.setTextPattern(string);
                    BasicSearchForm.this.updateTextPatternColor();
                    if (BasicSearchForm.this.cboxReplacement != null) {
                        BasicSearchForm.this.updateReplacePatternColor();
                    }
                } else if (this.sourceComboBox == BasicSearchForm.this.cboxFileNamePattern) {
                    BasicSearchForm.this.searchCriteria.setFileNamePattern(string);
                } else {
                    assert (this.sourceComboBox == BasicSearchForm.this.cboxReplacement);
                    BasicSearchForm.this.searchCriteria.setReplaceExpr(string);
                    if (BasicSearchForm.this.cboxReplacement != null) {
                        BasicSearchForm.this.updateReplacePatternColor();
                    }
                }
            }
        }
        this.textToFindEditor.getDocument().addDocumentListener(new PatternChangeListener(this.cboxTextToFind));
        this.fileNamePatternEditor.getDocument().addDocumentListener(new PatternChangeListener(this.cboxFileNamePattern));
        if (this.replacementPatternEditor != null) {
            this.replacementPatternEditor.getDocument().addDocumentListener(new PatternChangeListener(this.cboxReplacement));
        }
        this.chkRegexp.addItemListener(this);
        this.chkCaseSensitive.addItemListener(this);
        this.chkWholeWords.addItemListener(this);
        boolean bl = this.chkRegexp.isSelected();
        this.chkWholeWords.setEnabled(!bl);
        this.searchCriteria.setUsabilityChangeListener(this);
    }

    private void initHistory() {
        List<String> list;
        Object object;
        List list2 = SearchHistory.getDefault().getSearchPatterns();
        if (!list2.isEmpty()) {
            object = new ArrayList(list2.size());
            list = list2.iterator();
            while (list.hasNext()) {
                SearchPattern searchPattern = (SearchPattern)list.next();
                String string = searchPattern.getSearchExpression();
                if (object.contains(string)) continue;
                object.add(string);
            }
            this.cboxTextToFind.setModel(new ListComboBoxModel((List<? extends Object>)object));
        }
        if (!(list = ((FindDialogMemory)(object = FindDialogMemory.getDefault())).getFileNamePatterns()).isEmpty()) {
            this.cboxFileNamePattern.setModel(new ListComboBoxModel(list, true));
        }
        if (this.cboxReplacement != null && !(list = ((FindDialogMemory)object).getReplacementExpressions()).isEmpty()) {
            this.cboxReplacement.setModel(new ListComboBoxModel(list, true));
        }
    }

    private void initValuesFromHistory() {
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (findDialogMemory.isTextPatternSpecified() && this.cboxTextToFind.getItemCount() != 0) {
            this.cboxTextToFind.setSelectedIndex(0);
        }
        if (findDialogMemory.isFileNamePatternSpecified() && this.cboxFileNamePattern.getItemCount() != 0) {
            this.cboxFileNamePattern.setSelectedIndex(0);
        }
        if (this.cboxReplacement != null && this.cboxReplacement.getItemCount() != 0) {
            this.cboxReplacement.setSelectedIndex(0);
        }
        this.chkWholeWords.setSelected(findDialogMemory.isWholeWords());
        this.chkCaseSensitive.setSelected(findDialogMemory.isCaseSensitive());
        this.chkRegexp.setSelected(findDialogMemory.isRegularExpression());
    }

    @Override
    public boolean requestFocusInWindow() {
        assert (this.textToFindEditor != null);
        if (this.textToFindEditor.isFocusOwner()) {
            return true;
        }
        int n = this.textToFindEditor.getText().length();
        if (n > 0) {
            this.textToFindEditor.setCaretPosition(0);
            this.textToFindEditor.moveCaretPosition(n);
        }
        return this.textToFindEditor.requestFocusInWindow();
    }

    private void updateTextPatternColor() {
        boolean bl = this.invalidTextPattern;
        this.invalidTextPattern = this.searchCriteria.isTextPatternInvalid();
        if (this.invalidTextPattern != bl) {
            if (this.defaultTextColor == null) {
                assert (!bl);
                this.defaultTextColor = this.textToFindEditor.getForeground();
            }
            this.textToFindEditor.setForeground(this.invalidTextPattern ? this.getErrorTextColor() : this.defaultTextColor);
        }
    }

    private void updateReplacePatternColor() {
        boolean bl = this.invalidReplacePattern;
        this.invalidReplacePattern = this.searchCriteria.isReplacePatternInvalid();
        if (this.invalidReplacePattern != bl) {
            if (this.defaultTextColor == null) {
                assert (!bl);
                this.defaultTextColor = this.textToFindEditor.getForeground();
            }
            this.replacementPatternEditor.setForeground(this.invalidReplacePattern ? this.getErrorTextColor() : this.defaultTextColor);
        }
    }

    private static boolean isBackrefSyntaxUsed(String string) {
        int n;
        int n2 = string.length();
        if (n2 < 2) {
            return false;
        }
        String string2 = string.substring(0, n2 - 1);
        int n3 = 0;
        while ((n = string2.indexOf(92, n3)) != -1) {
            char c = string.charAt(n + 1);
            if (c == '\\') {
                n3 = n + 1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                return true;
            }
            n3 = n + 2;
        }
        return false;
    }

    private Color getErrorTextColor() {
        if (this.errorTextColor == null) {
            this.errorTextColor = UIManager.getDefaults().getColor("TextField.errorForeground");
            if (this.errorTextColor == null) {
                this.errorTextColor = Color.RED;
            }
        }
        return this.errorTextColor;
    }

    void setUsabilityChangeListener(ChangeListener changeListener) {
        this.usabilityChangeListener = changeListener;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.usabilityChangeListener != null) {
            this.usabilityChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemSelectable == this.chkRegexp) {
            this.searchCriteria.setRegexp(bl);
            this.updateTextPatternColor();
            if (this.cboxReplacement != null) {
                this.updateReplacePatternColor();
            }
            this.chkWholeWords.setEnabled(!bl);
            this.lblHintTextToFind.setVisible(!bl);
        } else if (itemSelectable == this.chkCaseSensitive) {
            this.searchCriteria.setCaseSensitive(bl);
        } else if (itemSelectable == this.chkWholeWords) {
            this.searchCriteria.setWholeWords(bl);
        } else assert (false);
    }

    private AbstractButton[] createSearchScopeButtons() {
        this.radioBtnGroup = new ButtonGroup();
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
                    Object object = abstractButton.getClientProperty("searchScope");
                    BasicSearchForm.this.selectedSearchScope = (SearchScope)object;
                }
            }
        };
        AbstractButton[] abstractButtonArray = new AbstractButton[this.searchScopes.size()];
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        for (Map.Entry<SearchScope, Boolean> entry : this.orderSearchScopes()) {
            SearchScope searchScope = entry.getKey();
            boolean bl2 = entry.getValue();
            String string = bl2 ? searchScope.getAdditionalInfo() : null;
            JRadioButton jRadioButton = string == null ? new JRadioButton() : new ButtonWithExtraInfo(string);
            Mnemonics.setLocalizedText((AbstractButton)jRadioButton, (String)searchScope.getDisplayName());
            ((Component)jRadioButton).getAccessibleContext().setAccessibleDescription(searchScope.getDisplayName());
            jRadioButton.putClientProperty("searchScope", searchScope);
            jRadioButton.addItemListener(itemListener);
            jRadioButton.setEnabled(bl2);
            if (bl2) {
                if (searchScope.getTypeId().equals(this.preferredSearchScopeType)) {
                    jRadioButton.setSelected(true);
                    bl = true;
                } else if (n2 == -1) {
                    n2 = n;
                }
            }
            abstractButtonArray[n++] = jRadioButton;
            this.radioBtnGroup.add(jRadioButton);
        }
        if (!bl && n2 != -1) {
            abstractButtonArray[n2].setSelected(true);
        }
        return abstractButtonArray;
    }

    private Collection<Map.Entry<SearchScope, Boolean>> orderSearchScopes() {
        Set<Map.Entry<SearchScope, Boolean>> set = this.searchScopes.entrySet();
        if (set.isEmpty() || set.size() == 1) {
            return set;
        }
        ArrayList<Map.Entry<SearchScope, Boolean>> arrayList = new ArrayList<Map.Entry<SearchScope, Boolean>>(set.size());
        Map.Entry entry = null;
        for (Map.Entry entry2 : set) {
            if (entry == null) {
                entry = entry2;
                continue;
            }
            arrayList.add(entry2);
        }
        arrayList.add(entry);
        return arrayList;
    }

    private JComponent createButtonsPanel(String string, AbstractButton ... sequentialGroup) {
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup();
        for (AbstractButton abstractButton : sequentialGroup) {
            if (abstractButton instanceof ButtonWithExtraInfo) {
                parallelGroup.add((Component)abstractButton, -1, -2, Short.MAX_VALUE);
                continue;
            }
            parallelGroup.add((Component)abstractButton);
        }
        groupLayout.setHorizontalGroup((GroupLayout.Group)parallelGroup);
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup();
        int n = 1;
        for (GroupLayout.SequentialGroup sequentialGroup3 : sequentialGroup) {
            if (n == 0) {
                sequentialGroup2.addPreferredGap(0);
            }
            sequentialGroup2.add((Component)sequentialGroup3);
            n = 0;
        }
        groupLayout.setVerticalGroup((GroupLayout.Group)sequentialGroup2);
        groupLayout.linkSize((Component[])sequentialGroup, 2);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getText(string)), BorderFactory.createEmptyBorder(3, 5, 5, 5)));
        return jPanel;
    }

    void onOk() {
        this.searchCriteria.onOk();
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (this.searchCriteria.isTextPatternUsable()) {
            SearchHistory.getDefault().add(this.getCurrentSearchPattern());
            findDialogMemory.setTextPatternSpecified(true);
        } else {
            findDialogMemory.setTextPatternSpecified(false);
        }
        if (this.searchCriteria.isFileNamePatternUsable()) {
            findDialogMemory.storeFileNamePattern(this.fileNamePatternEditor.getText());
            findDialogMemory.setFileNamePatternSpecified(true);
        } else {
            findDialogMemory.setFileNamePatternSpecified(false);
        }
        if (this.replacementPatternEditor != null) {
            findDialogMemory.storeReplacementExpression(this.replacementPatternEditor.getText());
        }
        findDialogMemory.setWholeWords(this.chkWholeWords.isSelected());
        findDialogMemory.setCaseSensitive(this.chkCaseSensitive.isSelected());
        findDialogMemory.setRegularExpression(this.chkRegexp.isSelected());
    }

    private SearchPattern getCurrentSearchPattern() {
        return SearchPattern.create((String)this.textToFindEditor.getText(), (boolean)this.chkWholeWords.isSelected(), (boolean)this.chkCaseSensitive.isSelected(), (boolean)this.chkRegexp.isSelected());
    }

    SearchScope getSelectedSearchScope() {
        assert (this.selectedSearchScope != null);
        return this.selectedSearchScope;
    }

    BasicSearchCriteria getBasicSearchCriteria() {
        return this.searchCriteria;
    }

    boolean isUsable() {
        return this.selectedSearchScope != null && this.searchCriteria.isUsable();
    }

    private String getText(String string) {
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    private final class FileNamePatternWatcher
    extends TextFieldFocusListener
    implements HierarchyListener {
        private final Logger watcherLogger;
        private final JTextComponent txtComp;
        private final Document doc;
        private Color foregroundColor;
        private String infoText;
        private boolean infoDisplayed;

        private FileNamePatternWatcher(JTextComponent jTextComponent) {
            this.watcherLogger = Logger.getLogger("org.netbeans.modules.search.BasicSearchForm.FileNamePatternWatcher");
            this.txtComp = jTextComponent;
            this.doc = jTextComponent.getDocument();
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (hierarchyEvent.getComponent() != this.txtComp || (hierarchyEvent.getChangeFlags() & 2L) == 0L || !this.txtComp.isDisplayable()) {
                return;
            }
            this.watcherLogger.finer("componentShown()");
            if (this.foregroundColor == null) {
                this.foregroundColor = this.txtComp.getForeground();
            }
            if (this.doc.getLength() == 0 && !this.txtComp.isFocusOwner()) {
                this.displayInfo();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.infoDisplayed) {
                this.hideInfo();
            }
            super.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            if (this.isEmptyText()) {
                this.displayInfo();
            }
        }

        private boolean isEmptyText() {
            String string;
            int n = this.doc.getLength();
            if (n == 0) {
                return true;
            }
            try {
                string = this.doc.getText(0, n);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                string = null;
            }
            return string != null && string.trim().length() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void displayInfo() {
            assert (this.doc.getLength() == 0 && !this.txtComp.isFocusOwner());
            this.watcherLogger.finer("displayInfo()");
            try {
                this.txtComp.setForeground(this.txtComp.getDisabledTextColor());
                BasicSearchForm.this.ignoreFileNamePatternChanges = true;
                this.doc.insertString(0, this.getInfoText(), null);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                BasicSearchForm.this.ignoreFileNamePatternChanges = false;
                this.infoDisplayed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hideInfo() {
            this.watcherLogger.finer("hideInfo()");
            this.txtComp.setEnabled(true);
            try {
                BasicSearchForm.this.ignoreFileNamePatternChanges = true;
                this.doc.remove(0, this.doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                BasicSearchForm.this.ignoreFileNamePatternChanges = false;
                this.txtComp.setForeground(this.foregroundColor);
                this.infoDisplayed = false;
            }
        }

        private String getInfoText() {
            if (this.infoText == null) {
                this.infoText = NbBundle.getMessage(this.getClass(), (String)"BasicSearchForm.cboxFileNamePattern.allFiles");
            }
            return this.infoText;
        }
    }

    private static class TextFieldFocusListener
    implements FocusListener {
        private TextFieldFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JTextComponent jTextComponent;
            if (!focusEvent.isTemporary() && (jTextComponent = (JTextComponent)focusEvent.getSource()).getText().length() != 0) {
                jTextComponent.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

