/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.filter.FilterCondition;
import org.netbeans.modules.tasklist.filter.StringFilterCondition;
import org.netbeans.modules.tasklist.filter.TaskGroupCondition;
import org.netbeans.modules.tasklist.filter.TaskProperties;
import org.netbeans.modules.tasklist.filter.TaskProperty;
import org.netbeans.spi.tasklist.Task;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeywordsFilter {
    private boolean allTrue = false;
    private List<AppliedFilterCondition> appliedConditions = null;
    private static final String NO_FILTER = NbBundle.getMessage(KeywordsFilter.class, (String)"no-filter");
    private static final TaskProperty[] PROPS = new TaskProperty[]{TaskProperties.PROP_DESCRIPTION, TaskProperties.PROP_GROUP, TaskProperties.PROP_FILE, TaskProperties.PROP_LOCATION};

    public KeywordsFilter() {
        this(true, new ArrayList<AppliedFilterCondition>());
    }

    public KeywordsFilter(boolean bl, List<AppliedFilterCondition> list) {
        this.allTrue = bl;
        this.appliedConditions = list;
    }

    protected KeywordsFilter(KeywordsFilter keywordsFilter) {
        this(keywordsFilter.allTrue, KeywordsFilter.cloneConditions(keywordsFilter.appliedConditions));
    }

    private static List<AppliedFilterCondition> cloneConditions(List<AppliedFilterCondition> list) {
        LinkedList<AppliedFilterCondition> linkedList = new LinkedList<AppliedFilterCondition>();
        Iterator<AppliedFilterCondition> iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add((AppliedFilterCondition)iterator.next().clone());
        }
        return linkedList;
    }

    public Object clone() {
        return new KeywordsFilter(this);
    }

    public AppliedFilterCondition[] createConditions(TaskProperty taskProperty) {
        if (taskProperty.equals(TaskProperties.PROP_GROUP)) {
            return KeywordsFilter.applyConditions(taskProperty, TaskGroupCondition.createConditions());
        }
        if (taskProperty.equals(TaskProperties.PROP_DESCRIPTION)) {
            return KeywordsFilter.applyConditions(taskProperty, StringFilterCondition.createConditions());
        }
        if (taskProperty.equals(TaskProperties.PROP_FILE)) {
            return KeywordsFilter.applyConditions(taskProperty, StringFilterCondition.createConditions());
        }
        if (taskProperty.equals(TaskProperties.PROP_LOCATION)) {
            return KeywordsFilter.applyConditions(taskProperty, StringFilterCondition.createConditions());
        }
        throw new IllegalArgumentException("wrong property");
    }

    public TaskProperty[] getProperties() {
        return PROPS;
    }

    public void clear() {
        this.getConditions().clear();
    }

    public boolean accept(Task task) {
        if (!this.hasConstraints()) {
            return true;
        }
        Iterator<AppliedFilterCondition> iterator = this.appliedConditions.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            AppliedFilterCondition appliedFilterCondition = iterator.next();
            bl = appliedFilterCondition.isTrue(task);
            if (bl && !this.allTrue) {
                return true;
            }
            if (bl || !this.allTrue) continue;
            return false;
        }
        return bl;
    }

    public boolean matchAll() {
        return this.allTrue;
    }

    public boolean hasConstraints() {
        return this.appliedConditions != null && this.appliedConditions.size() > 0;
    }

    public void setMatchAll(boolean bl) {
        if (this.allTrue != bl) {
            this.allTrue = bl;
        }
    }

    public final List getConditions() {
        return this.appliedConditions;
    }

    public final void setConditions(List<AppliedFilterCondition> list) {
        this.appliedConditions = list;
    }

    public String toString() {
        Iterator<AppliedFilterCondition> iterator = this.appliedConditions.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + "[");
        stringBuffer.append(this.allTrue ? "ALL of the following conditions" : "ANY of the following conditions");
        stringBuffer.append(", ");
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static AppliedFilterCondition[] applyConditions(TaskProperty taskProperty, FilterCondition[] filterConditionArray) {
        if (filterConditionArray == null) {
            return null;
        }
        AppliedFilterCondition[] appliedFilterConditionArray = new AppliedFilterCondition[filterConditionArray.length];
        for (int i = 0; i < filterConditionArray.length; ++i) {
            appliedFilterConditionArray[i] = new AppliedFilterCondition(taskProperty, filterConditionArray[i]);
        }
        return appliedFilterConditionArray;
    }

    static FilterCondition createCondition(TaskProperty taskProperty) {
        if (taskProperty.getID().equals(TaskProperties.PROP_GROUP.getID())) {
            return new TaskGroupCondition();
        }
        return new StringFilterCondition();
    }

    void load(Preferences preferences, String string) throws BackingStoreException {
        this.allTrue = preferences.getBoolean(string + "_allTrue", false);
        this.appliedConditions.clear();
        int n = preferences.getInt(string + "_count", 0);
        for (int i = 0; i < n; ++i) {
            AppliedFilterCondition appliedFilterCondition = new AppliedFilterCondition();
            appliedFilterCondition.load(preferences, string + "_condition_" + i);
            this.appliedConditions.add(appliedFilterCondition);
        }
    }

    void save(Preferences preferences, String string) throws BackingStoreException {
        preferences.putBoolean(string + "_allTrue", this.allTrue);
        preferences.putInt(string + "_count", this.appliedConditions.size());
        for (int i = 0; i < this.appliedConditions.size(); ++i) {
            this.appliedConditions.get(i).save(preferences, string + "_condition_" + i);
        }
    }
}

