/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.MethodGenerator;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.view.actions.AddOperationAction;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveOperationAction
extends AbstractAction {
    private Set<MethodModel> methods;
    private Service service;

    public RemoveOperationAction(Service service) {
        super(RemoveOperationAction.getName());
        this.putValue("ShortDescription", NbBundle.getMessage(RemoveOperationAction.class, (String)"Hint_RemoveOperation"));
        this.putValue("MnemonicKey", Integer.valueOf(NbBundle.getMessage(AddOperationAction.class, (String)"LBL_RemoveOperation_mnem_pos")));
        this.service = service;
        this.setEnabled(false);
    }

    public void setWorkingSet(Set<MethodModel> set) {
        this.methods = set;
        this.setEnabled(this.service.getWsdlUrl() == null && set != null && !set.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.methods.size() < 1) {
            return;
        }
        boolean bl = this.methods.size() == 1;
        String string = bl ? this.methods.iterator().next().getOperationName() : "" + this.methods.size();
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RemoveOperationAction.class, (String)(bl ? "MSG_OPERATION_DELETE" : "MSG_OPERATIONS_DELETE"), (Object)string));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object == NotifyDescriptor.YES_OPTION) {
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoveOperationAction.class, (String)(bl ? "MSG_RemoveOperation" : "MSG_RemoveOperations"), (Object)string));
            Task task = new Task(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    progressHandle.start();
                    try {
                        RemoveOperationAction.this.removeOperation(RemoveOperationAction.this.methods);
                    }
                    catch (IOException iOException) {
                        progressHandle.finish();
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
            });
            RequestProcessor.getDefault().post((Runnable)task);
        }
    }

    private void removeOperation(Set<MethodModel> set) throws IOException {
        for (MethodModel methodModel : set) {
            SaveCookie saveCookie;
            String string = methodModel.getOperationName();
            FileObject fileObject = this.getImplementationClass(methodModel);
            MethodGenerator.deleteMethod((FileObject)fileObject, (String)string);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (!dataObject.isModified() || (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) == null) continue;
            saveCookie.save();
        }
    }

    private static String getName() {
        return NbBundle.getMessage(RemoveOperationAction.class, (String)"LBL_RemoveOperation");
    }

    private FileObject getImplementationClass(MethodModel methodModel) {
        FileObject fileObject = null;
        FileObject fileObject2 = methodModel.getImplementationClass();
        String string = this.service.getImplementationClass();
        if (this.service.getLocalWsdlFile() != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sourceGroupArray.length > 0) {
                ClassPath classPath = null;
                for (int i = 0; i < sourceGroupArray.length && ((classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[i].getRootFolder(), (String)"classpath/source")) == null || (fileObject = classPath.findResource(string.replace('.', '/') + ".java")) == null); ++i) {
                }
            }
        } else {
            fileObject = fileObject2;
        }
        return fileObject;
    }
}

