/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteProjectSupport {
    public static ExecutionEnvironment getExecutionEnvironment(Project project) {
        MakeConfiguration makeConfiguration = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (makeConfiguration != null) {
            return makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        }
        return null;
    }

    public static boolean projectExists(Project project) {
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        File file2 = new File(file, "nbproject");
        return file2.exists();
    }

    public static File getPrivateStorage(Project project) {
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        File file2 = new File(new File(file, "nbproject"), "private");
        return file2;
    }

    public static File[] getProjectSourceDirs(Project project) {
        MakeConfiguration makeConfiguration = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (makeConfiguration == null) {
            File file = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
            return new File[]{file};
        }
        return RemoteProjectSupport.getProjectSourceDirs(project, makeConfiguration);
    }

    public static File[] getProjectSourceDirs(Project project, MakeConfiguration makeConfiguration) {
        String string;
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        if (makeConfiguration == null) {
            return new File[]{file};
        }
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(file);
        MakeConfigurationDescriptor makeConfigurationDescriptor = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)project);
        for (String string2 : makeConfigurationDescriptor.getSourceRoots()) {
            string = IpeUtils.toAbsolutePath((String)file.getAbsolutePath(), (String)string2);
            File file2 = new File(string);
            hashSet.add(file2);
        }
        RemoteProjectSupport.addExtraFiles(makeConfigurationDescriptor, hashSet);
        for (String string2 : makeConfiguration.getSubProjectLocations()) {
            string2 = IpeUtils.toAbsolutePath((String)file.getAbsolutePath(), (String)string2);
            hashSet.add(new File(string2));
        }
        for (String string2 : makeConfiguration.getSubProjects()) {
            string = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)string2);
            for (String string3 : makeConfigurationDescriptor.getSourceRoots()) {
                File file3 = new File(string3).getAbsoluteFile();
                hashSet.add(file3);
            }
            RemoteProjectSupport.addExtraFiles((MakeConfigurationDescriptor)string, hashSet);
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    private static void addExtraFiles(MakeConfigurationDescriptor makeConfigurationDescriptor, Set<File> set) {
        SharabilityFilter sharabilityFilter = new SharabilityFilter();
        for (Item item : makeConfigurationDescriptor.getProjectItems()) {
            File file = item.getNormalizedFile();
            if (!sharabilityFilter.accept(file)) {
                set.add(file);
                File file2 = file.getParentFile();
                continue;
            }
            if (RemoteProjectSupport.isContained(file, set)) continue;
            set.add(file);
        }
    }

    private static boolean isContained(File file, Set<File> set) {
        String string = file.getAbsolutePath();
        for (File file2 : set) {
            String string2;
            if (!file2.isDirectory() || !string.startsWith(string2 = file2.getAbsolutePath() + File.separatorChar)) continue;
            return true;
        }
        return false;
    }
}

