/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommandSupport
extends RemoteConnectionSupport {
    private final StringBuilder out = new StringBuilder();
    private final StringBuilder err = new StringBuilder();
    private final String cmd;
    private final Map<String, String> env;
    private final String[] args;
    private boolean interrupted = false;

    public static int run(ExecutionEnvironment executionEnvironment, String string) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(executionEnvironment, string);
        return remoteCommandSupport.run();
    }

    public static int run(ExecutionEnvironment executionEnvironment, String string, String ... stringArray) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(executionEnvironment, string, null, stringArray);
        return remoteCommandSupport.run();
    }

    public RemoteCommandSupport(ExecutionEnvironment executionEnvironment, String string, Map<String, String> map, String ... stringArray) {
        super(executionEnvironment);
        this.cmd = string;
        this.env = map;
        this.args = stringArray;
    }

    public RemoteCommandSupport(ExecutionEnvironment executionEnvironment, String string, Map<String, String> map) {
        super(executionEnvironment);
        this.cmd = string;
        this.env = map;
        this.args = null;
    }

    public RemoteCommandSupport(ExecutionEnvironment executionEnvironment, String string) {
        this(executionEnvironment, string, null);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        if (!this.isFailedOrCancelled()) {
            Object object;
            RemoteUtil.LOGGER.fine("RemoteCommandSupport<Init>: Running [" + this.cmd + "] on " + this.executionEnvironment);
            if (SwingUtilities.isEventDispatchThread()) {
                object = "Running remote command in EDT: " + this.cmd;
                if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                    RemoteUtil.LOGGER.log(Level.FINE, (String)object, new Exception((String)object));
                } else {
                    RemoteUtil.LOGGER.warning((String)object);
                }
            }
            object = null;
            BufferedReader bufferedReader = null;
            try {
                String string;
                String string2;
                NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                if (this.args == null) {
                    nativeProcessBuilder.setCommandLine(this.cmd);
                } else {
                    nativeProcessBuilder.setExecutable(this.cmd);
                    nativeProcessBuilder.setArguments(this.args);
                }
                nativeProcessBuilder.getEnvironment().putAll(this.env);
                NativeProcess nativeProcess = nativeProcessBuilder.call();
                InputStream inputStream = nativeProcess.getInputStream();
                InputStream inputStream2 = nativeProcess.getErrorStream();
                if (inputStream == null) {
                    throw new IOException("process (" + nativeProcess.getClass().getName() + ") returned null input stream");
                }
                if (inputStream2 == null) {
                    throw new IOException("process (" + nativeProcess.getClass().getName() + ") returned null error stream");
                }
                object = new BufferedReader(new InputStreamReader(inputStream));
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    if (string2 == null) continue;
                    this.out.append(string2).append('\n');
                }
                int n = nativeProcess.waitFor();
                RemoteUtil.LOGGER.fine("RemoteCommandSupport: " + this.cmd + " on " + this.executionEnvironment + " finished; rc=" + n);
                while ((string = bufferedReader.readLine()) != null) {
                    if (string == null) continue;
                    this.err.append(string).append('\n');
                    if (!RemoteUtil.LOGGER.isLoggable(Level.FINEST)) continue;
                    RemoteUtil.LOGGER.finest("RemoteCommandSupport ERROR: " + string);
                }
                this.setExitStatus(n);
            }
            catch (InterruptedException interruptedException) {
                this.interrupted = true;
                RemoteUtil.LOGGER.log(Level.FINEST, "Interrupted", interruptedException);
            }
            catch (InterruptedIOException interruptedIOException) {
                this.interrupted = true;
                RemoteUtil.LOGGER.log(Level.FINEST, "Interrupted", interruptedIOException);
            }
            catch (IOException iOException) {
                RemoteUtil.LOGGER.warning("IO failure during running " + this.cmd);
            }
            finally {
                if (object != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
        return this.getExitStatus();
    }

    public String toString() {
        return this.getOutput();
    }

    public String getOutput() {
        return this.out.toString();
    }

    public String getErr() {
        return this.err.toString();
    }
}

