/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.lib.editor.codetemplates.CodeTemplateApiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurroundWithFix
implements Fix {
    private static String SURROUND_WITH = NbBundle.getMessage(SurroundWithFix.class, (String)"TXT_SurroundWithHint_Prefix");
    private CodeTemplate template;
    private JTextComponent component;

    public static List<Fix> getFixes(JTextComponent jTextComponent) {
        CodeTemplateManagerOperation codeTemplateManagerOperation;
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        if (!(jTextComponent.getDocument() instanceof GuardedDocument && (((GuardedDocument)jTextComponent.getDocument()).getGuardedBlockChain().compareBlock(jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd()) & 1) != 0 || (codeTemplateManagerOperation = CodeTemplateManagerOperation.get(jTextComponent.getDocument(), jTextComponent.getSelectionStart())) == null)) {
            codeTemplateManagerOperation.waitLoaded();
            Collection<? extends CodeTemplateFilter> collection = CodeTemplateManagerOperation.getTemplateFilters(jTextComponent, jTextComponent.getSelectionStart());
            for (CodeTemplate codeTemplate : codeTemplateManagerOperation.findSelectionTemplates()) {
                if (!SurroundWithFix.accept(codeTemplate, collection) && codeTemplate.getContexts() != null && !codeTemplate.getContexts().isEmpty()) continue;
                arrayList.add(new SurroundWithFix(codeTemplate, jTextComponent));
            }
        }
        return arrayList;
    }

    private SurroundWithFix(CodeTemplate codeTemplate, JTextComponent jTextComponent) {
        this.template = codeTemplate;
        this.component = jTextComponent;
    }

    public String getText() {
        String string = this.template.getDescription();
        if (string == null) {
            string = CodeTemplateApiPackageAccessor.get().getSingleLineText(this.template);
        }
        return SURROUND_WITH + string;
    }

    public ChangeInfo implement() {
        this.template.insert(this.component);
        return null;
    }

    private static boolean accept(CodeTemplate codeTemplate, Collection<? extends CodeTemplateFilter> collection) {
        for (CodeTemplateFilter codeTemplateFilter : collection) {
            if (codeTemplateFilter.accept(codeTemplate)) continue;
            return false;
        }
        return true;
    }
}

