/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.AbstractTreeDTD;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEventManager;

public class TreeDTD
extends AbstractTreeDTD
implements TreeDocumentRoot,
TreeDTDRoot {
    public static final String PROP_VERSION = "version";
    public static final String PROP_ENCODING = "encoding";
    private TreeEventManager eventManager;
    private String version;
    private String encoding;
    static /* synthetic */ Class class$org$netbeans$tax$spec$DTD$Child;

    public TreeDTD(String string, String string2) throws InvalidArgumentException {
        this.checkVersion(string);
        this.checkEncoding(string2);
        this.checkHeader(string, string2);
        this.version = string;
        this.encoding = string2;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDTD::init: encoding = " + this.encoding);
        }
        this.eventManager = new TreeEventManager();
    }

    public TreeDTD() throws InvalidArgumentException {
        this(null, null);
    }

    protected TreeDTD(TreeDTD treeDTD, boolean bl) {
        super(treeDTD, bl);
        this.version = treeDTD.version;
        this.encoding = treeDTD.encoding;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDTD::init [copy]: encoding = " + this.encoding);
        }
        this.eventManager = new TreeEventManager(treeDTD.eventManager);
    }

    public Object clone(boolean bl) {
        return new TreeDTD(this, bl);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeDTD treeDTD = (TreeDTD)object;
        if (!Util.equals(this.getVersion(), treeDTD.getVersion())) {
            return false;
        }
        return Util.equals(this.getEncoding(), treeDTD.getEncoding());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeDTD treeDTD = (TreeDTD)treeObject;
        try {
            this.setVersionImpl(treeDTD.getVersion());
            this.setEncodingImpl(treeDTD.getEncoding());
        }
        catch (Exception exception) {
            throw new CannotMergeException(treeObject, exception);
        }
    }

    public String getVersion() {
        return this.version;
    }

    private final void setVersionImpl(String string) {
        String string2 = this.version;
        this.version = string;
        this.firePropertyChange(PROP_VERSION, string2, string);
    }

    public final void setVersion(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.version, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkVersion(string);
        this.checkHeader(string, this.encoding);
        this.setVersionImpl(string);
    }

    protected final void checkVersion(String string) throws InvalidArgumentException {
        TreeUtilities.checkDTDVersion(string);
    }

    public String getEncoding() {
        return this.encoding;
    }

    private final void setEncodingImpl(String string) {
        String string2 = this.encoding;
        this.encoding = string;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDTD::setEncodingImpl: encoding = " + this.encoding);
        }
        this.firePropertyChange(PROP_ENCODING, string2, string);
    }

    public final void setEncoding(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.encoding, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkEncoding(string);
        this.checkHeader(this.version, string);
        this.setEncodingImpl(string);
    }

    protected final void checkEncoding(String string) throws InvalidArgumentException {
        TreeUtilities.checkDTDEncoding(string);
    }

    public final void setHeader(String string, String string2) throws ReadOnlyException, InvalidArgumentException {
        boolean bl;
        boolean bl2 = !Util.equals(this.version, string);
        boolean bl3 = bl = !Util.equals(this.encoding, string2);
        if (!bl2 && !bl) {
            return;
        }
        this.checkReadOnly();
        if (bl2) {
            this.checkVersion(string);
        }
        if (bl) {
            this.checkEncoding(string2);
        }
        this.checkHeader(string, string2);
        if (bl2) {
            this.setVersionImpl(string);
        }
        if (bl) {
            this.setEncodingImpl(string2);
        }
    }

    protected final void checkHeader(String string, String string2) throws InvalidArgumentException {
        if (string != null && string2 == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_dtd_header"), new NullPointerException());
        }
    }

    public TreeEventManager getRootEventManager() {
        return this.eventManager;
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected class ChildListContentManager
    extends AbstractTreeDTD.ChildListContentManager {
        protected ChildListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeDTD.this;
        }

        public void checkAssignableObject(Object object) {
            super.checkAssignableObject(object);
            this.checkAssignableClass(class$org$netbeans$tax$spec$DTD$Child == null ? (class$org$netbeans$tax$spec$DTD$Child = TreeDTD.class$("org.netbeans.tax.spec.DTD$Child")) : class$org$netbeans$tax$spec$DTD$Child, object);
        }
    }
}

