/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.editor.FolderBasedController;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class FolderBasedOptionPanel
extends JPanel
implements ActionListener {
    private final FolderBasedController controller;
    private JComboBox languageCombo;
    private JLabel languageLabel;
    private JPanel optionsPanel;

    FolderBasedOptionPanel(FolderBasedController folderBasedController) {
        this.controller = folderBasedController;
        this.initComponents();
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof String) {
                    object = EditorSettings.getDefault().getLanguageName((String)object);
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        };
        this.languageCombo.setRenderer(defaultListCellRenderer);
        this.languageCombo.addActionListener(this);
        this.update();
    }

    void update() {
        String string2;
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string2 : this.controller.getMimeTypes()) {
            defaultComboBoxModel.addElement(string2);
        }
        this.languageCombo.setModel(defaultComboBoxModel);
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        string2 = jTextComponent != null ? (String)jTextComponent.getDocument().getProperty("mimeType") : "";
        this.languageCombo.setSelectedItem(string2);
        if (!string2.equals(this.languageCombo.getSelectedItem()) && defaultComboBoxModel.getSize() > 0) {
            this.languageCombo.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.languageLabel = new JLabel();
        this.languageCombo = new JComboBox();
        this.optionsPanel = new JPanel();
        this.languageLabel.setLabelFor(this.languageCombo);
        Mnemonics.setLocalizedText((JLabel)this.languageLabel, (String)NbBundle.getMessage(FolderBasedOptionPanel.class, (String)"LBL_Language"));
        this.languageCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.languageLabel).addPreferredGap(0).add((Component)this.languageCombo, -2, -1, -2).addContainerGap(211, Short.MAX_VALUE)).add(2, (Component)this.optionsPanel, -1, 354, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.languageLabel).add((Component)this.languageCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.optionsPanel, -1, 308, Short.MAX_VALUE)));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OptionsPanelController optionsPanelController;
        this.optionsPanel.setVisible(false);
        this.optionsPanel.removeAll();
        String string = (String)this.languageCombo.getSelectedItem();
        if (string != null && (optionsPanelController = this.controller.getController(string)) != null) {
            JComponent jComponent = optionsPanelController.getComponent(this.controller.getLookup());
            this.optionsPanel.add((Component)jComponent, "Center");
            this.optionsPanel.setVisible(true);
        }
    }
}

