/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Position;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmRenameRefactoringPlugin
extends CsmModificationRefactoringPlugin {
    private final RenameRefactoring refactoring;
    private Collection<CsmObject> referencedObjects;

    public CsmRenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        super((AbstractRefactoring)renameRefactoring);
        this.refactoring = renameRefactoring;
    }

    @Override
    public Problem fastCheckParameters() {
        Problem problem = null;
        String string = this.refactoring.getNewName();
        String string2 = CsmRefactoringUtils.getSimpleText(this.getStartReferenceObject());
        if (string2.equals(string)) {
            problem = CsmRenameRefactoringPlugin.createProblem(problem, true, CsmRenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            return problem;
        }
        if (!CndLexerUtilities.isCppIdentifier((CharSequence)string)) {
            String string3 = CsmRenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String string4 = new MessageFormat(string3).format(new Object[]{string});
            problem = CsmRenameRefactoringPlugin.createProblem(problem, true, string4);
            return problem;
        }
        return problem;
    }

    @Override
    public Problem preCheck() {
        Problem problem = null;
        this.fireProgressListenerStart(1, 5);
        if (this.referencedObjects == null) {
            this.initReferencedObjects();
            this.fireProgressListenerStep();
        }
        if ((problem = this.isResovledElement(this.getStartReferenceObject())) != null) {
            return problem;
        }
        CsmObject csmObject = CsmRefactoringUtils.getReferencedElement(this.getStartReferenceObject());
        problem = this.checkIfModificationPossible(problem, csmObject, CsmRenameRefactoringPlugin.getString("ERR_Overrides_Fatal"), CsmRenameRefactoringPlugin.getString("ERR_OverridesOrOverriden"));
        this.fireProgressListenerStop();
        return problem;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)string);
    }

    private void initReferencedObjects() {
        CsmObject csmObject = CsmRefactoringUtils.getReferencedElement(this.getStartReferenceObject());
        if (csmObject != null) {
            this.referencedObjects = new LinkedHashSet<CsmObject>();
            if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                this.referencedObjects.addAll(this.getRenamingClassObjects((CsmClass)csmObject));
            } else if (CsmKindUtilities.isConstructor((CsmObject)csmObject) || CsmKindUtilities.isDestructor((CsmObject)csmObject)) {
                CsmFunction csmFunction = (CsmFunction)csmObject;
                CsmClass csmClass = CsmBaseUtilities.getFunctionClass((CsmFunction)csmFunction);
                if (csmClass != null) {
                    this.referencedObjects.addAll(this.getRenamingClassObjects(csmClass));
                }
            } else if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
                CsmMethod csmMethod = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)csmObject));
                this.referencedObjects.add((CsmObject)csmMethod);
                if (CsmVirtualInfoQuery.getDefault().isVirtual(csmMethod)) {
                    this.referencedObjects.addAll(CsmVirtualInfoQuery.getDefault().getOverridenMethods(csmMethod, true));
                    assert (!this.referencedObjects.isEmpty()) : "must be at least start object " + csmMethod;
                }
            } else {
                this.referencedObjects.add(csmObject);
            }
        }
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        Collection<CsmObject> collection = this.getRefactoredObjects();
        if (collection == null || collection.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        CsmFile csmFile = this.getStartCsmFile();
        for (CsmObject csmObject : collection) {
            Collection<CsmProject> collection2 = CsmRefactoringUtils.getRelatedCsmProjects(csmObject, null);
            CsmProject[] csmProjectArray = collection2.toArray(new CsmProject[collection2.size()]);
            this.refactoring.getContext().add((Object)csmProjectArray);
            hashSet.addAll(this.getRelevantFiles(csmFile, csmObject, (AbstractRefactoring)this.refactoring));
        }
        return hashSet;
    }

    private CsmFile getStartCsmFile() {
        CsmFile csmFile = CsmRefactoringUtils.getCsmFile(this.getStartReferenceObject());
        if (csmFile == null && this.getEditorContext() != null) {
            csmFile = this.getEditorContext().getFile();
        }
        return csmFile;
    }

    private Collection<CsmObject> getRefactoredObjects() {
        return this.referencedObjects == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.referencedObjects);
    }

    private Collection<? extends CsmObject> getRenamingClassObjects(CsmClass csmClass) {
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        if (csmClass != null) {
            arrayList.add(csmClass);
            for (CsmMember csmMember : csmClass.getMembers()) {
                if (CsmKindUtilities.isConstructor((CsmObject)csmMember)) {
                    arrayList.add(csmMember);
                    continue;
                }
                if (!CsmKindUtilities.isDestructor((CsmObject)csmMember)) continue;
                arrayList.add(csmMember);
            }
        }
        return arrayList;
    }

    @Override
    protected final void processFile(CsmFile csmFile, ModificationResult modificationResult, AtomicReference<Problem> atomicReference) {
        Collection<CsmObject> collection = this.getRefactoredObjects();
        assert (collection != null && collection.size() > 0) : "method must be called for resolved element";
        FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (CsmObject csmObject : collection) {
            Collection collection2 = CsmReferenceRepository.getDefault().getReferences(csmObject, csmFile, CsmReferenceKind.ALL, null);
            linkedHashSet.addAll(collection2);
        }
        if (linkedHashSet.size() > 0) {
            CsmObject csmObject;
            ArrayList arrayList = new ArrayList(linkedHashSet);
            Collections.sort(arrayList, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference csmReference, CsmReference csmReference2) {
                    return csmReference.getStartOffset() - csmReference2.getStartOffset();
                }
            });
            csmObject = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            this.processRefactoredReferences(arrayList, fileObject, (CloneableEditorSupport)csmObject, modificationResult);
        }
    }

    private void processRefactoredReferences(List<CsmReference> list, FileObject fileObject, CloneableEditorSupport cloneableEditorSupport, ModificationResult modificationResult) {
        String string = this.refactoring.getNewName();
        for (CsmReference csmReference : list) {
            String string2 = ((Object)csmReference.getText()).toString();
            String string3 = this.getDescription(csmReference, string2);
            ModificationResult.Difference difference = this.rename(csmReference, cloneableEditorSupport, string2, string, string3);
            assert (difference != null);
            modificationResult.addDifference(fileObject, difference);
        }
    }

    private String getDescription(CsmReference csmReference, String string) {
        String string2 = NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)"UpdateRef", (Object)string);
        return string2;
    }

    private ModificationResult.Difference rename(CsmReference csmReference, CloneableEditorSupport cloneableEditorSupport, String string, String string2, String string3) {
        if (string == null) {
            string = ((Object)csmReference.getText()).toString();
        }
        if (string2 == null) {
            string2 = this.refactoring.getNewName();
        }
        assert (string != null);
        assert (string2 != null);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(csmReference.getStartOffset(), Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(csmReference.getEndOffset(), Position.Bias.Backward);
        ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, positionRef, positionRef2, string, string2, string3);
        return difference;
    }
}

