/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.refactoring.codegen.ui.CheckTreeView;
import org.netbeans.modules.cnd.refactoring.codegen.ui.ElementNode;
import org.netbeans.modules.cnd.refactoring.support.DeclarationGenerator;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSelectorPanel
extends JPanel
implements ExplorerManager.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final CheckTreeView elementView;
    private final JCheckBox inline = new JCheckBox();
    private boolean inlineMethod;

    public ElementSelectorPanel(ElementNode.Description description, boolean bl, boolean bl2) {
        this.setLayout(new BorderLayout());
        this.elementView = new CheckTreeView();
        this.elementView.setRootVisible(false);
        this.elementView.setUseSubstringInQuickSearch(true);
        this.add((Component)((Object)this.elementView), "Center");
        if (bl2) {
            Mnemonics.setLocalizedText((AbstractButton)this.inline, (String)NbBundle.getMessage(ElementSelectorPanel.class, (String)"LBL_inline_implementation"));
            this.inlineMethod = NbPreferences.forModule(DeclarationGenerator.class).getBoolean("insert_code_inline_method", true);
            this.inline.setSelected(this.inlineMethod);
            this.inline.setEnabled(false);
            this.add((Component)this.inline, "South");
        } else {
            this.inlineMethod = false;
        }
        this.setRootElement(description, bl);
        Node node = this.manager.getRootContext();
        Node[] nodeArray = node.getChildren().getNodes();
        if (null != nodeArray && nodeArray.length > 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{nodeArray[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public boolean isMethodInline() {
        this.inlineMethod = this.inline.isSelected();
        NbPreferences.forModule(DeclarationGenerator.class).putBoolean("insert_code_inline_method", this.inlineMethod);
        return this.inlineMethod;
    }

    public List<CsmDeclaration> getTreeSelectedElements() {
        ArrayList<CsmDeclaration> arrayList = new ArrayList<CsmDeclaration>();
        for (Node node : this.manager.getSelectedNodes()) {
            if (!(node instanceof ElementNode)) continue;
            ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
            arrayList.add(description.getElementHandle());
        }
        return arrayList;
    }

    public List<CsmDeclaration> getSelectedElements() {
        ArrayList<CsmDeclaration> arrayList = new ArrayList<CsmDeclaration>();
        Node node = this.manager.getRootContext();
        ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
        this.getSelectedHandles(description, arrayList);
        return arrayList;
    }

    public void setRootElement(ElementNode.Description description, boolean bl) {
        Object object;
        if (description != null) {
            ElementNode elementNode = new ElementNode(description);
            elementNode.setSingleSelection(bl);
            object = elementNode;
        } else {
            object = Node.EMPTY;
        }
        this.manager.setRootContext(object);
    }

    public void doInitialExpansion(int n) {
        Node node = this.getExplorerManager().getRootContext();
        Node[] nodeArray = node.getChildren().getNodes(true);
        if (nodeArray == null) {
            return;
        }
        Node node2 = null;
        int n2 = 0;
        boolean bl = this.elementView.getScrollsOnExpand();
        this.elementView.setScrollsOnExpand(false);
        for (int i = 0; nodeArray != null && i < (n == -1 || n > nodeArray.length ? nodeArray.length : n); ++i) {
            this.elementView.expandRow(++n2);
            Node[] nodeArray2 = nodeArray[i].getChildren().getNodes(true);
            n2 += nodeArray2.length;
            if (node2 != null || nodeArray2.length <= 0) continue;
            node2 = this.getSelectedNode(nodeArray2);
        }
        this.elementView.setScrollsOnExpand(bl);
        try {
            if (node2 != null) {
                this.getExplorerManager().setSelectedNodes(new Node[]{node2});
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void getSelectedHandles(ElementNode.Description description, ArrayList<CsmDeclaration> arrayList) {
        if (description == null) {
            return;
        }
        List<ElementNode.Description> list = description.getSubs();
        if (list == null) {
            return;
        }
        for (ElementNode.Description description2 : list) {
            if (description2.isSelectable() && description2.isSelected()) {
                arrayList.add(description2.getElementHandle());
                continue;
            }
            this.getSelectedHandles(description2, arrayList);
        }
    }

    private Node getSelectedNode(Node[] nodeArray) {
        assert (nodeArray.length > 0) : "array must have elements";
        for (Node node : nodeArray) {
            ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
            if (description == null || !description.isSelected()) continue;
            return node;
        }
        return nodeArray[0];
    }
}

