/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.refactoring.PositionBoundsResolver;
import org.netbeans.modules.web.refactoring.WebRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebXmlRefactoring
implements WebRefactoring {
    protected final WebApp webModel;
    protected final FileObject webDD;

    protected WebXmlRefactoring(FileObject fileObject, WebApp webApp) {
        this.webDD = fileObject;
        this.webModel = webApp;
    }

    @Override
    public Problem preCheck() {
        if (this.webModel.getStatus() == 2) {
            return new Problem(false, NbBundle.getMessage(WebXmlRefactoring.class, (String)"TXT_WebXmlInvalidProblem"));
        }
        return null;
    }

    protected List<Servlet> getServlets(String string) {
        ArrayList<Servlet> arrayList = new ArrayList<Servlet>();
        for (Servlet servlet : this.webModel.getServlet()) {
            if (!string.equals(servlet.getServletClass())) continue;
            arrayList.add(servlet);
        }
        return arrayList;
    }

    protected List<Filter> getFilters(String string) {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.webModel.getFilter()) {
            if (!string.equals(filter.getFilterClass())) continue;
            arrayList.add(filter);
        }
        return arrayList;
    }

    protected List<Listener> getListeners(String string) {
        ArrayList<Listener> arrayList = new ArrayList<Listener>();
        for (Listener listener : this.webModel.getListener()) {
            if (!string.equals(listener.getListenerClass())) continue;
            arrayList.add(listener);
        }
        return arrayList;
    }

    protected List<EjbRef> getEjbRefs(String string, boolean bl) {
        ArrayList<EjbRef> arrayList = new ArrayList<EjbRef>();
        for (EjbRef ejbRef : this.webModel.getEjbRef()) {
            if (bl && string.equals(ejbRef.getRemote())) {
                arrayList.add(ejbRef);
                continue;
            }
            if (!string.equals(ejbRef.getHome())) continue;
            arrayList.add(ejbRef);
        }
        return arrayList;
    }

    protected List<EjbLocalRef> getEjbLocalRefs(String string, boolean bl) {
        ArrayList<EjbLocalRef> arrayList = new ArrayList<EjbLocalRef>();
        for (EjbLocalRef ejbLocalRef : this.webModel.getEjbLocalRef()) {
            if (bl && string.equals(ejbLocalRef.getLocalHome())) {
                arrayList.add(ejbLocalRef);
                continue;
            }
            if (!string.equals(ejbLocalRef.getLocal())) continue;
            arrayList.add(ejbLocalRef);
        }
        return arrayList;
    }

    private boolean packageEquals(String string, String string2) {
        int n = string2.lastIndexOf(".");
        if (n <= 0) {
            return false;
        }
        return string.equals(string2.substring(n));
    }

    protected static abstract class WebRefactoringElement
    extends SimpleRefactoringElementImplementation {
        protected final WebApp webApp;
        protected final FileObject webDD;

        public WebRefactoringElement(WebApp webApp, FileObject fileObject) {
            this.webApp = webApp;
            this.webDD = fileObject;
        }

        public void performChange() {
            this.doChange();
            this.writeDD();
        }

        private void writeDD() {
            try {
                this.webApp.write(this.webDD);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        protected abstract void doChange();

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.webDD;
        }

        public PositionBounds getPosition() {
            try {
                return new PositionBoundsResolver(DataObject.find((FileObject)this.webDD), this.getName()).getPositionBounds();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return null;
            }
        }

        public String getText() {
            return this.getDisplayText();
        }

        public void undoChange() {
            this.undo();
            this.writeDD();
        }

        protected abstract String getName();

        protected abstract void undo();
    }
}

