/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.ImageUtilities;

public class ScrollWidget
extends Widget {
    private static final int BAR_VERTICAL_SIZE = 16;
    private static final int BAR_HORIZONTAL_SIZE = 16;
    private static final Point POINT_EMPTY = new Point();
    private static final Rectangle RECTANGLE_EMPTY = new Rectangle();
    private static final Border BORDER_RAISED = BorderFactory.createBevelBorder(true);
    private static final Border BORDER_LOWERED = BorderFactory.createBevelBorder(false);
    private Widget viewport;
    private Widget view;
    private SliderWidget verticalSlider;
    private SliderWidget horizontalSlider;
    private Widget upArrow;
    private Widget downArrow;
    private Widget leftArrow;
    private Widget rightArrow;

    public ScrollWidget(Scene scene) {
        super(scene);
        this.setLayout(new ScrollLayout());
        this.setCheckClipping(true);
        this.viewport = new Widget(scene);
        this.viewport.setCheckClipping(true);
        this.addChild(this.viewport);
        this.upArrow = this.createUpArrow();
        this.addChild(this.upArrow);
        this.verticalSlider = this.createVerticalSlider();
        this.addChild(this.verticalSlider);
        this.downArrow = this.createDownArrow();
        this.addChild(this.downArrow);
        this.leftArrow = this.createLeftArrow();
        this.addChild(this.leftArrow);
        this.horizontalSlider = this.createHorizontalSlider();
        this.addChild(this.horizontalSlider);
        this.rightArrow = this.createRightArrow();
        this.addChild(this.rightArrow);
        this.upArrow.getActions().addAction(ActionFactory.createSelectAction(new UnitScrollProvider(0, -16)));
        this.downArrow.getActions().addAction(ActionFactory.createSelectAction(new UnitScrollProvider(0, 16)));
        this.leftArrow.getActions().addAction(ActionFactory.createSelectAction(new UnitScrollProvider(-16, 0)));
        this.rightArrow.getActions().addAction(ActionFactory.createSelectAction(new UnitScrollProvider(16, 0)));
        this.horizontalSlider.getActions().addAction(new BlockScrollAction(this.horizontalSlider, -64, 0));
        this.verticalSlider.getActions().addAction(new BlockScrollAction(this.verticalSlider, 0, -64));
        this.horizontalSlider.getActions().addAction(new SliderAction(this.horizontalSlider));
        this.verticalSlider.getActions().addAction(new SliderAction(this.verticalSlider));
    }

    public ScrollWidget(Scene scene, Widget widget) {
        this(scene);
        this.setView(widget);
    }

    private SliderWidget createVerticalSlider() {
        return new SliderWidget(this.getScene(), true);
    }

    private SliderWidget createHorizontalSlider() {
        return new SliderWidget(this.getScene(), false);
    }

    private Widget createUpArrow() {
        return new ButtonWidget(this.getScene(), ImageUtilities.loadImage((String)"org/netbeans/modules/visual/resources/arrow-up.png"));
    }

    private Widget createDownArrow() {
        return new ButtonWidget(this.getScene(), ImageUtilities.loadImage((String)"org/netbeans/modules/visual/resources/arrow-down.png"));
    }

    private Widget createLeftArrow() {
        return new ButtonWidget(this.getScene(), ImageUtilities.loadImage((String)"org/netbeans/modules/visual/resources/arrow-left.png"));
    }

    private Widget createRightArrow() {
        return new ButtonWidget(this.getScene(), ImageUtilities.loadImage((String)"org/netbeans/modules/visual/resources/arrow-right.png"));
    }

    public final Widget getView() {
        return this.view;
    }

    public final void setView(Widget widget) {
        if (this.view != null) {
            this.viewport.removeChild(this.view);
        }
        this.view = widget;
        if (this.view != null) {
            this.viewport.addChild(this.view);
        }
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle(this.calculateSize());
    }

    private Dimension calculateSize() {
        if (this.isPreferredBoundsSet()) {
            Rectangle rectangle = this.getPreferredBounds();
            Insets insets = this.getBorder().getInsets();
            return new Dimension(rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        }
        return this.view.getBounds().getSize();
    }

    private void translateView(int n, int n2) {
        Widget widget = this.getView();
        if (widget == null) {
            return;
        }
        Point point = this.view.getLocation();
        point.translate(-n, -n2);
        this.checkViewLocationInBounds(point, this.view, n, n2);
        widget.setPreferredLocation(point);
    }

    private void checkViewLocationInBounds(Point point, Widget widget, int n, int n2) {
        Rectangle rectangle = widget.getBounds();
        Rectangle rectangle2 = this.viewport.getBounds();
        if (n < 0 && point.x > rectangle.x) {
            point.x = rectangle.x;
        }
        if (n2 < 0 && point.y > rectangle.y) {
            point.y = rectangle.y;
        }
        if (n > 0 && point.x + rectangle.width < rectangle2.x + rectangle2.width) {
            point.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (n2 > 0 && point.y + rectangle.height < rectangle2.y + rectangle2.height) {
            point.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
    }

    private class SliderAction
    extends WidgetAction.Adapter {
        private SliderWidget slider;
        private Widget movingWidget = null;
        private Point dragSceneLocation = null;
        private Point originalSceneLocation = null;

        private SliderAction(SliderWidget sliderWidget) {
            this.slider = sliderWidget;
        }

        protected boolean isLocked() {
            return this.movingWidget != null;
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            Widget widget2;
            if (this.isLocked()) {
                return WidgetAction.State.createLocked(widget, this);
            }
            if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1 && (widget2 = ScrollWidget.this.getView()) != null && this.slider.getPartHitAt(widgetMouseEvent.getPoint()) == SliderWidget.Part.SLIDER) {
                this.movingWidget = widget;
                this.originalSceneLocation = widget2.getPreferredLocation();
                if (this.originalSceneLocation == null) {
                    this.originalSceneLocation = new Point();
                }
                this.dragSceneLocation = widget.convertLocalToScene(widgetMouseEvent.getPoint());
                return WidgetAction.State.createLocked(widget, this);
            }
            return WidgetAction.State.REJECTED;
        }

        public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            boolean bl = this.move(widget, widgetMouseEvent.getPoint());
            if (bl) {
                this.movingWidget = null;
            }
            return bl ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
        }

        public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return this.move(widget, widgetMouseEvent.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
        }

        private boolean move(Widget widget, Point point) {
            Widget widget2 = ScrollWidget.this.getView();
            if (this.movingWidget != widget || widget2 == null) {
                return false;
            }
            point = widget.convertLocalToScene(point);
            int n = 0;
            int n2 = 0;
            if (this.slider.isVertical()) {
                n2 = -((int)((float)(point.y - this.dragSceneLocation.y) / this.slider.getPixelIncrement()));
            } else {
                n = -((int)((float)(point.x - this.dragSceneLocation.x) / this.slider.getPixelIncrement()));
            }
            point.x = this.originalSceneLocation.x + n;
            point.y = this.originalSceneLocation.y + n2;
            ScrollWidget.this.checkViewLocationInBounds(point, widget2, -n, -n2);
            widget2.setPreferredLocation(point);
            return true;
        }
    }

    private class BlockScrollAction
    extends WidgetAction.Adapter {
        private SliderWidget slider;
        private int dx;
        private int dy;

        private BlockScrollAction(SliderWidget sliderWidget, int n, int n2) {
            this.slider = sliderWidget;
            this.dx = n;
            this.dy = n2;
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            if (widgetMouseEvent.getButton() == 1) {
                assert (this.slider == widget);
                SliderWidget.Part part = this.slider.getPartHitAt(widgetMouseEvent.getPoint());
                switch (part) {
                    case AFTER: {
                        ScrollWidget.this.translateView(-this.dx, -this.dy);
                        return WidgetAction.State.CHAIN_ONLY;
                    }
                    case BEFORE: {
                        ScrollWidget.this.translateView(this.dx, this.dy);
                        return WidgetAction.State.CHAIN_ONLY;
                    }
                }
            }
            return WidgetAction.State.REJECTED;
        }
    }

    private class UnitScrollProvider
    implements SelectProvider {
        private int dx;
        private int dy;

        private UnitScrollProvider(int n, int n2) {
            this.dx = n;
            this.dy = n2;
        }

        public boolean isAimingAllowed(Widget widget, Point point, boolean bl) {
            return true;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean bl) {
            return true;
        }

        public void select(Widget widget, Point point, boolean bl) {
            ScrollWidget.this.translateView(this.dx, this.dy);
        }
    }

    private static class SliderWidget
    extends Widget {
        private static final Color COLOR = new Color(5998542);
        private static final Border BORDER = BorderFactory.createBevelBorder(true, COLOR);
        private boolean vertical;
        private long minimumValue = 0L;
        private long maximumValue = 100L;
        private long startValue = 0L;
        private long endValue = 100L;

        private SliderWidget(Scene scene, boolean bl) {
            super(scene);
            this.vertical = bl;
            this.setOpaque(true);
            this.setBackground(Color.LIGHT_GRAY);
        }

        public boolean isVertical() {
            return this.vertical;
        }

        public long getMinimumValue() {
            return this.minimumValue;
        }

        public void setValues(long l, long l2, long l3, long l4) {
            this.minimumValue = l;
            this.maximumValue = l2;
            this.startValue = l3;
            this.endValue = l4;
            this.repaint();
        }

        public void setMinimumValue(long l) {
            this.minimumValue = l;
            this.repaint();
        }

        public long getMaximumValue() {
            return this.maximumValue;
        }

        public void setMaximumValue(long l) {
            this.maximumValue = l;
            this.repaint();
        }

        public long getStartValue() {
            return this.startValue;
        }

        public void setStartValue(long l) {
            this.startValue = l;
            this.repaint();
        }

        public long getEndValue() {
            return this.endValue;
        }

        public void setEndValue(long l) {
            this.endValue = l;
            this.repaint();
        }

        public Part getPartHitAt(Point point) {
            int n;
            long l;
            if (!this.isHitAt(point)) {
                return Part.OUTSIDE;
            }
            Rectangle rectangle = this.getClientArea();
            if (this.vertical) {
                l = rectangle.height;
                n = point.y - rectangle.y;
            } else {
                l = rectangle.width;
                n = point.x - rectangle.x;
            }
            long l2 = Math.min(Math.max(this.startValue, this.minimumValue), this.maximumValue);
            long l3 = Math.min(Math.max(this.endValue, this.minimumValue), this.maximumValue);
            int n2 = (int)((float)l * (float)(l2 - this.minimumValue) / (float)(this.maximumValue - this.minimumValue));
            int n3 = (int)((float)l * (float)(l3 - this.minimumValue) / (float)(this.maximumValue - this.minimumValue));
            if (n < n2) {
                return Part.BEFORE;
            }
            if (n >= n3) {
                return Part.AFTER;
            }
            return Part.SLIDER;
        }

        public float getPixelIncrement() {
            return (float)(this.vertical ? this.getClientArea().height : this.getClientArea().width) / (float)(this.maximumValue - this.minimumValue);
        }

        protected void paintWidget() {
            long l;
            Graphics2D graphics2D = this.getGraphics();
            Rectangle rectangle = this.getClientArea();
            long l2 = l = this.vertical ? (long)rectangle.height : (long)rectangle.width;
            if (this.minimumValue < this.maximumValue && this.startValue < this.endValue) {
                long l3 = Math.min(Math.max(this.startValue, this.minimumValue), this.maximumValue);
                int n = (int)((float)l * (float)(l3 - this.minimumValue) / (float)(this.maximumValue - this.minimumValue));
                long l4 = Math.min(Math.max(this.endValue, this.minimumValue), this.maximumValue);
                int n2 = (int)((float)l * (float)(l4 - this.minimumValue) / (float)(this.maximumValue - this.minimumValue));
                graphics2D.setColor(COLOR);
                if (n + 4 < n2) {
                    if (this.vertical) {
                        graphics2D.fillRect(rectangle.x + 2, rectangle.y + n + 2, rectangle.width - 4, n2 - n - 4);
                        BORDER.paint(graphics2D, new Rectangle(rectangle.x, rectangle.y + n, rectangle.width, n2 - n));
                    } else {
                        graphics2D.fillRect(rectangle.x + n + 2, rectangle.y + 2, n2 - n - 4, rectangle.height - 4);
                        BORDER.paint(graphics2D, new Rectangle(rectangle.x + n, rectangle.y, n2 - n, rectangle.height));
                    }
                } else if (this.vertical) {
                    graphics2D.fillRect(rectangle.x, rectangle.y + n, rectangle.width, n2 - n);
                } else {
                    graphics2D.fillRect(rectangle.x + n, rectangle.y, n2 - n, rectangle.height);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Part {
            OUTSIDE,
            BEFORE,
            SLIDER,
            AFTER;

        }
    }

    private static class ButtonWidget
    extends ImageWidget {
        private ButtonWidget(Scene scene, Image image) {
            super(scene, image);
            this.setOpaque(true);
            this.updateAiming(false);
        }

        protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
            if (objectState.isWidgetAimed() != objectState2.isWidgetAimed()) {
                this.updateAiming(objectState2.isWidgetAimed());
            }
        }

        private void updateAiming(boolean bl) {
            this.setBackground(bl ? Color.GRAY : Color.LIGHT_GRAY);
            this.setBorder(bl ? BORDER_LOWERED : BORDER_RAISED);
        }
    }

    private final class ScrollLayout
    implements Layout {
        private ScrollLayout() {
        }

        public void layout(Widget widget) {
            Cloneable cloneable;
            Point point;
            if (ScrollWidget.this.isPreferredBoundsSet()) {
                point = ScrollWidget.this.getPreferredBounds().getLocation();
                cloneable = ScrollWidget.this.getBorder().getInsets();
                point.translate(cloneable.left, cloneable.top);
            } else {
                point = new Point();
            }
            cloneable = ScrollWidget.this.view != null ? ScrollWidget.this.view.getPreferredBounds() : new Rectangle();
            Rectangle rectangle = ScrollWidget.this.view != null ? new Rectangle(ScrollWidget.this.view.getLocation(), ScrollWidget.this.calculateSize()) : new Rectangle();
            boolean bl = this.checkVertical((Rectangle)cloneable, rectangle);
            boolean bl2 = this.checkHorizontal((Rectangle)cloneable, rectangle);
            if (bl) {
                rectangle.width -= 16;
                bl2 = this.checkHorizontal((Rectangle)cloneable, rectangle);
            }
            if (bl2) {
                rectangle.height -= 16;
                if (!bl && (bl = this.checkVertical((Rectangle)cloneable, rectangle))) {
                    rectangle.width -= 16;
                }
            }
            ScrollWidget.this.viewport.resolveBounds(point, new Rectangle(rectangle.getSize()));
            int n = point.x;
            int n2 = point.x + rectangle.width;
            int n3 = point.y;
            int n4 = point.y + rectangle.height;
            if (bl) {
                ScrollWidget.this.upArrow.resolveBounds(new Point(n2, n3), new Rectangle(16, 16));
                ScrollWidget.this.downArrow.resolveBounds(new Point(n2, n4 - 16), new Rectangle(16, 16));
                ScrollWidget.this.verticalSlider.resolveBounds(new Point(n2, n3 + 16), new Rectangle(16, rectangle.height - 16 - 16));
            } else {
                ScrollWidget.this.upArrow.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
                ScrollWidget.this.downArrow.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
                ScrollWidget.this.verticalSlider.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
            }
            if (bl2) {
                ScrollWidget.this.leftArrow.resolveBounds(new Point(n, n4), new Rectangle(16, 16));
                ScrollWidget.this.rightArrow.resolveBounds(new Point(n2 - 16, n4), new Rectangle(16, 16));
                ScrollWidget.this.horizontalSlider.resolveBounds(new Point(n + 16, n4), new Rectangle(rectangle.width - 16 - 16, 16));
            } else {
                ScrollWidget.this.leftArrow.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
                ScrollWidget.this.rightArrow.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
                ScrollWidget.this.horizontalSlider.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
            }
            ScrollWidget.this.verticalSlider.setValues(((Rectangle)cloneable).y + rectangle.y, ((Rectangle)cloneable).y + rectangle.y + ((Rectangle)cloneable).height, 0L, rectangle.height);
            ScrollWidget.this.horizontalSlider.setValues(((Rectangle)cloneable).x + rectangle.x, ((Rectangle)cloneable).x + rectangle.x + ((Rectangle)cloneable).width, 0L, rectangle.width);
        }

        public boolean requiresJustification(Widget widget) {
            return false;
        }

        public void justify(Widget widget) {
        }

        private boolean checkHorizontal(Rectangle rectangle, Rectangle rectangle2) {
            return (rectangle.x < rectangle2.x || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) && rectangle2.width > 48;
        }

        private boolean checkVertical(Rectangle rectangle, Rectangle rectangle2) {
            return (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) && rectangle2.height > 48;
        }
    }
}

