/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.ServletWrapper;

public class Container
implements Cloneable {
    private ContextManager contextM;
    Context context;
    public static final int UNKNOWN_MAP = 0;
    public static final int PATH_MAP = 1;
    public static final int PREFIX_MAP = 2;
    public static final int EXTENSION_MAP = 3;
    public static final int DEFAULT_MAP = 4;
    int mapType = 0;
    String transport;
    String path;
    String proto;
    String[] vhosts;
    private Hashtable attributes = new Hashtable();
    Vector contextInterceptors = new Vector();
    Vector requestInterceptors = new Vector();
    ContextInterceptor[] cInterceptors;
    RequestInterceptor[] rInterceptors;
    ServletWrapper handler;
    String[] roles = null;
    String[] methods = null;
    Object[] notes = new Object[32];

    public void addContextInterceptor(ContextInterceptor ci) {
        this.contextInterceptors.addElement(ci);
    }

    public void addRequestInterceptor(RequestInterceptor ci) {
        this.requestInterceptors.addElement(ci);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Container getClone() {
        try {
            return (Container)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public ContextInterceptor[] getContextInterceptors() {
        if (this.cInterceptors == null || this.cInterceptors.length != this.contextInterceptors.size()) {
            this.cInterceptors = new ContextInterceptor[this.contextInterceptors.size()];
            int i = 0;
            while (i < this.cInterceptors.length) {
                this.cInterceptors[i] = (ContextInterceptor)this.contextInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.cInterceptors;
    }

    public ContextManager getContextManager() {
        if (this.contextM == null) {
            throw new RuntimeException("Assert: container.contextM==null");
        }
        return this.contextM;
    }

    public ServletWrapper getHandler() {
        return this.handler;
    }

    public int getMapType() {
        if (this.mapType != 0) {
            return this.mapType;
        }
        this.mapType = this.path == null || this.path.equals("") || this.path.equals("/") ? 4 : (this.path.startsWith("/") && this.path.endsWith("/*") ? 2 : (this.path.startsWith("*.") ? 3 : 1));
        return this.mapType;
    }

    public String[] getMethods() {
        return this.methods;
    }

    public Object getNote(int pos) {
        return this.notes[pos];
    }

    public String getPath() {
        return this.path;
    }

    public String getProtocol() {
        return this.proto;
    }

    public RequestInterceptor[] getRequestInterceptors() {
        if (this.rInterceptors == null || this.rInterceptors.length != this.requestInterceptors.size()) {
            this.rInterceptors = new RequestInterceptor[this.requestInterceptors.size()];
            int i = 0;
            while (i < this.rInterceptors.length) {
                this.rInterceptors[i] = (RequestInterceptor)this.requestInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.rInterceptors;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String getTransport() {
        return this.transport;
    }

    public String[] getVhosts() {
        return this.vhosts;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
    }

    public void setHandler(ServletWrapper h) {
        this.handler = h;
    }

    public void setMethods(String[] m) {
        this.methods = m;
    }

    public void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public void setPath(String path) {
        this.path = path == null ? "" : path.trim();
    }

    public void setProtocol(String protocol) {
        this.proto = protocol;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public void setVhosts(String[] vhosts) {
        this.vhosts = vhosts;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Ct (");
        if (this.handler != null) {
            sb.append(this.handler.toString());
        }
        if (this.roles != null) {
            sb.append(" Roles: ");
            int i = 0;
            while (i < this.roles.length) {
                sb.append(" ").append(this.roles[i]);
                ++i;
            }
        }
        sb.append(" )");
        return sb.toString();
    }
}

