/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.testrunner.api.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.output.OutputDocument;
import org.netbeans.modules.gsf.testrunner.output.OutputEditorKit;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class ResultPanelOutput
extends JScrollPane
implements ActionListener {
    private static final boolean LOG = false;
    static final Color selectedFg;
    static final Color unselectedFg;
    static final Color selectedErr;
    static final Color unselectedErr;
    private static final int UPDATE_DELAY = 300;
    private final JEditorPane textPane = new JEditorPane();
    private final Document doc;
    private final ResultDisplayHandler displayHandler;
    private Timer timer = null;
    private volatile boolean timerRunning = false;

    ResultPanelOutput(ResultDisplayHandler resultDisplayHandler) {
        this.textPane.setFont(new Font("monospaced", 0, this.getFont().getSize()));
        this.textPane.setEditorKit(new OutputEditorKit());
        this.textPane.setEditable(false);
        this.textPane.getCaret().setVisible(true);
        this.textPane.getCaret().setBlinkRate(0);
        this.textPane.setCursor(Cursor.getPredefinedCursor(2));
        this.setViewportView(this.textPane);
        Color color = UIManager.getColor("TextPane.background");
        if (color != null) {
            this.textPane.setBackground(color);
        }
        this.doc = this.textPane.getDocument();
        AccessibleContext accessibleContext = this.textPane.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_OutputTextPane"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_OutputTextPane"));
        this.displayHandler = resultDisplayHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object[] objectArray;
        super.addNotify();
        Object object = this.displayHandler.getOutputQueueLock();
        synchronized (object) {
            objectArray = this.displayHandler.consumeOutput();
            if (objectArray.length == 0) {
                // empty if block
            }
        }
        if (objectArray.length != 0) {
            this.displayOutput(objectArray);
            this.startTimer();
        }
    }

    void outputAvailable() {
        Object[] objectArray = this.displayHandler.consumeOutput();
        assert (objectArray.length != 0);
        new OutputDisplayer(objectArray).run();
        if (!this.timerRunning) {
            this.startTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        assert (EventQueue.isDispatchThread());
        Object[] objectArray = this.displayHandler.consumeOutput();
        if (objectArray.length != 0) {
            this.displayOutput(objectArray);
        } else {
            Object object = this.displayHandler.getOutputQueueLock();
            synchronized (object) {
                this.stopTimer();
            }
        }
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer(300, this);
        }
        this.timerRunning = true;
        this.timer.start();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timerRunning = false;
        }
    }

    void displayOutput(Object[] objectArray) {
        Object object;
        assert (EventQueue.isDispatchThread());
        int n = 0;
        while ((object = objectArray[n++]) != null) {
            boolean bl = false;
            if (object == Boolean.TRUE) {
                object = objectArray[n++];
                bl = true;
            }
            this.displayOutputLine(object.toString(), bl);
        }
    }

    private void displayOutputLine(String string, boolean bl) {
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == stringArray.length - 1) {
                stringArray[i] = stringArray[i] + "\n";
            }
            try {
                this.doc.insertString(this.doc.getLength(), stringArray[i], bl ? OutputDocument.attrs : null);
                continue;
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(65536, (Throwable)badLocationException);
            }
        }
    }

    private void clear() {
        assert (EventQueue.isDispatchThread());
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(65536, (Throwable)badLocationException);
        }
    }

    public boolean requestFocusInWindow() {
        return this.textPane.requestFocusInWindow();
    }

    static {
        Color color = UIManager.getColor("nb.output.foreground.selected");
        if (color == null && (color = UIManager.getColor("textText")) == null) {
            color = Color.BLACK;
        }
        selectedFg = color;
        color = UIManager.getColor("nb.output.foreground");
        if (color == null) {
            color = selectedFg;
        }
        unselectedFg = color;
        color = UIManager.getColor("nb.output.err.foreground.selected");
        if (color == null) {
            color = new Color(164, 0, 0);
        }
        selectedErr = color;
        color = UIManager.getColor("nb.output.err.foreground");
        if (color == null) {
            color = selectedErr;
        }
        unselectedErr = color;
    }

    final class OutputDisplayer
    implements Runnable {
        private final Object[] output;

        OutputDisplayer(Object[] objectArray) {
            this.output = objectArray;
        }

        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
                return;
            }
            ResultPanelOutput.this.displayOutput(this.output);
        }
    }
}

