/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Segment;
import com.sun.perseus.model.TraitAnimationNode;

class StringSegment
implements Segment {
    String[] start;
    String[] end;

    StringSegment() {
    }

    public Object[] getStart() {
        return this.start;
    }

    public Object[] getEnd() {
        return this.end;
    }

    public void setZeroStart() {
        for (int i = 0; i < this.start.length; ++i) {
            this.start[i] = "";
        }
    }

    public void setStart(Object[] newStart) {
        this.start = (String[])newStart;
    }

    public void collapse(Segment seg, TraitAnimationNode anim) {
        StringSegment mseg = (StringSegment)seg;
        if (mseg.end.length != this.end.length) {
            throw new IllegalArgumentException();
        }
        this.end = mseg.end;
    }

    public void addToEnd(Object[] by) {
        throw new IllegalArgumentException();
    }

    public boolean isAdditive() {
        return false;
    }

    public String[] compute(float p) {
        if (p == 1.0f) {
            return this.end;
        }
        return this.start;
    }

    public String toString() {
        int ci;
        StringBuffer sb = new StringBuffer();
        sb.append("StringSegment[");
        if (this.start == null) {
            sb.append("null");
        } else {
            sb.append("start[" + this.start.length + "] : {");
            for (ci = 0; ci < this.start.length; ++ci) {
                sb.append("\"" + this.start[ci] + "\"");
                if (ci >= this.start.length - 1) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        if (this.end == null) {
            sb.append(" null");
        } else {
            sb.append(" end[" + this.end.length + "] : {");
            for (ci = 0; ci < this.end.length; ++ci) {
                sb.append("\"" + this.end[ci] + "\"");
                if (ci >= this.end.length - 1) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public final float getLength() {
        return 1.0f;
    }

    public final void initialize() {
    }
}

