/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.impl.services.UIDFilter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyCsmCollection<Tuid, Tfact extends Tuid>
implements Collection<Tfact> {
    private final Collection<CsmUID<Tuid>> uids;
    private final boolean allowNullsAndSkip;

    public LazyCsmCollection(Collection<CsmUID<Tuid>> collection, boolean bl) {
        this.uids = collection;
        this.allowNullsAndSkip = bl;
    }

    private Tfact convertToObject(CsmUID<? extends Tfact> csmUID) {
        return UIDCsmConverter.UIDtoCsmObject(csmUID);
    }

    @Override
    public int size() {
        return this.uids.size();
    }

    @Override
    public boolean isEmpty() {
        return this.uids.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        for (Tfact Tfact : this) {
            if (object != Tfact && (object == null || !object.equals(Tfact))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Tfact> iterator() {
        return this.allowNullsAndSkip ? new MySafeIterator() : new MyIterator();
    }

    public Iterator<Tfact> iterator(CsmSelect.CsmFilter csmFilter) {
        return new MySafeIterator(csmFilter);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator<Tfact> iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        if (n < this.size()) {
            Object[] objectArray2 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            objectArray = objectArray2;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator<Tfact> iterator = this.iterator();
        T[] TArray = objectArray;
        int n2 = 0;
        while (iterator.hasNext()) {
            TArray[n2] = iterator.next();
            ++n2;
        }
        if (n2 < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
            System.arraycopy(TArray, 0, objectArray, 0, n2);
        }
        return objectArray;
    }

    @Override
    public boolean add(Tfact Tfact) {
        return this.uids.add(UIDs.get(Tfact));
    }

    @Override
    public boolean remove(Object object) {
        return this.uids.remove(UIDs.get((Object)object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Tfact> collection) {
        boolean bl = false;
        if (collection instanceof LazyCsmCollection) {
            LazyCsmCollection lazyCsmCollection = (LazyCsmCollection)collection;
            return this.uids.addAll(lazyCsmCollection.uids);
        }
        Iterator<Tfact> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<Tfact> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<Tfact> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.uids.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<Tfact> iterator = this.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            Tfact Tfact = iterator.next();
            stringBuilder.append(Tfact == this ? "(this Collection)" : String.valueOf(Tfact));
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MySafeIterator
    implements Iterator<Tfact> {
        private Iterator<CsmUID<Tuid>> it;
        private Tfact next;
        private CsmSelect.CsmFilter filter;

        private MySafeIterator() {
            this((CsmSelect.CsmFilter)null);
        }

        private MySafeIterator(CsmSelect.CsmFilter csmFilter) {
            this.filter = csmFilter;
            this.it = LazyCsmCollection.this.uids.iterator();
            this.next = this.getNextNonNull();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        private Tfact getNextNonNull() {
            Object object = null;
            while (object == null && this.it.hasNext()) {
                CsmUID csmUID = this.it.next();
                if (csmUID == null || this.filter != null && !((UIDFilter)this.filter).accept(csmUID)) continue;
                object = LazyCsmCollection.this.convertToObject(csmUID);
            }
            return object;
        }

        @Override
        public Tfact next() {
            Object Tfact = this.next;
            this.next = this.getNextNonNull();
            return Tfact;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator
    implements Iterator<Tfact> {
        private Iterator<CsmUID<Tuid>> it;

        private MyIterator() {
            this.it = LazyCsmCollection.this.uids.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Tfact next() {
            CsmUID csmUID = this.it.next();
            Object object = LazyCsmCollection.this.convertToObject(csmUID);
            assert (object != null) : "no object for UID " + csmUID;
            return object;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

