/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectSettingsValidatorKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSettingsValidator {
    private static final boolean TRACE = Boolean.getBoolean("cnd.modelimpl.validator.trace");
    private final ProjectBase csmProject;
    private NativeProject nativeProject;
    private Data data;

    public ProjectSettingsValidator(ProjectBase projectBase) {
        this.csmProject = projectBase;
        Object object = projectBase.getPlatformProject();
        if (object instanceof NativeProject) {
            this.nativeProject = (NativeProject)object;
        }
    }

    public void storeSettings() {
        if (this.nativeProject == null) {
            return;
        }
        long l = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("ProjectSettingsValidator.storeSettings for %s\n", this.csmProject.getName());
            l = System.currentTimeMillis();
        }
        this.data = new Data();
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> arrayList2 = new ArrayList<NativeFileItem>();
        for (NativeFileItem nativeFileItem : this.nativeProject.getAllFiles()) {
            if (nativeFileItem.isExcluded()) continue;
            switch (nativeFileItem.getLanguage()) {
                case C: 
                case CPP: {
                    arrayList.add(nativeFileItem);
                    break;
                }
                case C_HEADER: {
                    arrayList2.add(nativeFileItem);
                    break;
                }
            }
        }
        this.updateMap(arrayList2);
        this.updateMap(arrayList);
        ProjectSettingsValidatorKey projectSettingsValidatorKey = new ProjectSettingsValidatorKey(((Object)this.csmProject.getUniqueName()).toString());
        RepositoryUtils.put(projectSettingsValidatorKey, this.data);
        if (TraceFlags.TIMING) {
            l = System.currentTimeMillis() - l;
            System.err.printf("ProjectSettingsValidator.storeSettings for %s took %d ms\n", this.csmProject.getName(), l);
        }
    }

    private void updateMap(List<NativeFileItem> list) {
        for (NativeFileItem nativeFileItem : list) {
            long l = this.calculateCrc(nativeFileItem);
            this.data.setCrc(nativeFileItem.getFile().getAbsolutePath(), l);
        }
    }

    public void restoreSettings() {
        if (this.nativeProject == null) {
            return;
        }
        ProjectSettingsValidatorKey projectSettingsValidatorKey = new ProjectSettingsValidatorKey(((Object)this.csmProject.getUniqueName()).toString());
        this.data = (Data)RepositoryUtils.get(projectSettingsValidatorKey);
        if (this.data == null) {
            this.data = new Data();
            DiagnosticExceptoins.register(new IllegalStateException("Can not get project settings validator data by the key " + projectSettingsValidatorKey));
        }
    }

    public boolean exists(FileImpl fileImpl) {
        return this.data.exists(fileImpl.getAbsolutePath());
    }

    public boolean arePropertiesChanged(NativeFileItem nativeFileItem) {
        if (this.nativeProject == null) {
            return false;
        }
        assert (this.data != null);
        long l = this.data.getCrc(nativeFileItem.getFile().getAbsolutePath());
        long l2 = this.calculateCrc(nativeFileItem);
        if (TRACE) {
            System.err.printf("arePropertiesChanged %s OLD=%d CUR=%d %b\n", nativeFileItem.getFile().getName(), l, l2, l != l2);
        }
        return l != l2;
    }

    private long calculateCrc(NativeFileItem nativeFileItem) {
        if (TRACE) {
            System.err.printf(">>> CRC %s\n", nativeFileItem.getFile().getName());
        }
        Adler32 adler32 = new Adler32();
        this.updateCrc((Checksum)adler32, nativeFileItem.getLanguage().toString());
        this.updateCrc((Checksum)adler32, nativeFileItem.getLanguageFlavor().toString());
        this.updateCrc((Checksum)adler32, nativeFileItem.getSystemIncludePaths());
        this.updateCrc((Checksum)adler32, nativeFileItem.getUserIncludePaths());
        this.updateCrc((Checksum)adler32, nativeFileItem.getSystemMacroDefinitions());
        this.updateCrc((Checksum)adler32, nativeFileItem.getUserMacroDefinitions());
        if (TRACE) {
            System.err.printf("<<< CRC %s %d\n", nativeFileItem.getFile().getName(), adler32.getValue());
        }
        return adler32.getValue();
    }

    private void updateCrc(Checksum checksum, String string) {
        checksum.update(string.getBytes(), 0, string.length());
        if (TRACE) {
            System.err.printf("\tupdateCrc %s -> %d\n", string, checksum.getValue());
        }
    }

    private void updateCrc(Checksum checksum, List<String> list) {
        for (String string : list) {
            this.updateCrc(checksum, string);
        }
    }

    public static PersistentFactory getPersistentFactory() {
        return new ValidatorPersistentFactory();
    }

    private static class ValidatorPersistentFactory
    implements PersistentFactory {
        private ValidatorPersistentFactory() {
        }

        public boolean canWrite(Persistent persistent) {
            assert (persistent instanceof Data);
            return true;
        }

        public void write(DataOutput dataOutput, Persistent persistent) throws IOException {
            assert (persistent instanceof Data);
            ((Data)persistent).write(dataOutput);
        }

        public Persistent read(DataInput dataInput) throws IOException {
            return new Data(dataInput);
        }
    }

    private static class Data
    implements Persistent,
    SelfPersistent {
        private Map<CharSequence, Long> map = new HashMap<CharSequence, Long>();

        public Data() {
        }

        public long getCrc(CharSequence charSequence) {
            Long l = this.map.get(FilePathCache.getManager().getString(charSequence));
            return l == null ? 0L : l;
        }

        public boolean exists(CharSequence charSequence) {
            return this.map.containsKey(FilePathCache.getManager().getString(charSequence));
        }

        public void setCrc(CharSequence charSequence, long l) {
            this.map.put(FilePathCache.getManager().getString(charSequence), l);
        }

        public Data(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            for (int i = 0; i < n; ++i) {
                CharSequence charSequence = PersistentUtils.readUTF(dataInput, FilePathCache.getManager());
                long l = dataInput.readLong();
                this.map.put(charSequence, l);
            }
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.map.size());
            for (Map.Entry<CharSequence, Long> entry : this.map.entrySet()) {
                PersistentUtils.writeUTF(entry.getKey(), dataOutput);
                dataOutput.writeLong(entry.getValue());
            }
        }
    }
}

