/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;

public class ErrorPanel
extends JPanel {
    private Error error;
    private ErrorLabel errorLabel;
    private String errorMessage;

    public ErrorPanel(final ToolBarDesignEditor toolBarDesignEditor) {
        this.initComponents();
        this.errorLabel = new ErrorLabel();
        this.errorLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Error.ErrorLocation errorLocation;
                Error error = ErrorPanel.this.getError();
                if (error != null && (errorLocation = error.getErrorLocation()) != null) {
                    SectionPanel sectionPanel = ((SectionView)toolBarDesignEditor.getContentView()).findSectionPanel(errorLocation.getKey());
                    if (sectionPanel.getInnerPanel() == null) {
                        sectionPanel.open();
                    }
                    sectionPanel.scroll();
                    JComponent jComponent = sectionPanel.getErrorComponent(errorLocation.getComponentId());
                    if (jComponent != null) {
                        jComponent.requestFocus();
                    }
                }
            }
        });
        this.add((Component)this.errorLabel, "Center");
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Error getError() {
        return this.error;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void setError(Error error) {
        switch (error.getErrorType()) {
            case 0: {
                this.errorMessage = "Error: " + error.getErrorMessage();
                break;
            }
            case 1: {
                this.errorMessage = "Warning: " + error.getErrorMessage();
                break;
            }
            case 2: {
                this.errorMessage = "Missing Value: " + error.getErrorMessage();
                break;
            }
            case 3: {
                this.errorMessage = "Duplicate Value: " + error.getErrorMessage();
            }
        }
        this.error = error;
        this.errorLabel.setText(this.errorMessage);
        this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/xml/multiview/resources/error-glyph.gif")));
    }

    public void clearError() {
        this.error = null;
        this.errorLabel.setIcon(null);
        this.errorLabel.setText("");
        this.errorMessage = "";
    }

    private class ErrorLabel
    extends JLabel {
        ErrorLabel() {
            this.setForeground(UIManager.getDefaults().getColor("ToolBar.dockingForeground"));
            this.setHorizontalAlignment(2);
            this.setText("");
        }

        public void setText(String string) {
            if (string.length() == 0) {
                super.setText(" ");
            } else {
                super.setText("<html><u>" + string + "</u></html>");
            }
        }
    }
}

