/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.impl.ComplexValueSettingsFactory;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.openide.text.Annotation;
import org.openide.text.AttributedCharacters;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class NbEditorDocument
extends GuardedDocument
implements NbDocument.PositionBiasable,
NbDocument.WriteLockable,
NbDocument.Printable,
NbDocument.CustomEditor,
NbDocument.CustomToolbar,
NbDocument.Annotatable {
    public static final String INDENT_ENGINE = "indentEngine";
    private HashMap annoMap;
    private WeakHashMap annoBlackList;

    public NbEditorDocument(Class clazz) {
        super(clazz);
        this.init();
    }

    public NbEditorDocument(String string) {
        super(string);
        this.init();
    }

    private void init() {
        this.addStyleToLayerMapping("NbBreakpointStyle", "NbBreakpointStyleLayer:10");
        this.addStyleToLayerMapping("NbErrorStyle", "NbErrorStyleLayer:20");
        this.addStyleToLayerMapping("NbCurrentStyle", "NbCurrentStyleLayer:30");
        this.setNormalStyleName("NbNormalStyle");
        this.annoMap = new HashMap(20);
        this.annoBlackList = new WeakHashMap();
        this.putProperty(INDENT_ENGINE, new BaseDocument.PropertyEvaluator(){

            public Object getValue() {
                MimePath mimePath = MimePath.parse((String)((String)NbEditorDocument.this.getProperty("mimeType")));
                return ComplexValueSettingsFactory.getIndentEngine(mimePath);
            }
        });
    }

    public int getShiftWidth() {
        return IndentUtils.indentLevelSize((Document)((Object)this));
    }

    public int getTabSize() {
        return IndentUtils.tabSize((Document)((Object)this));
    }

    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        if (attributeSet != null) {
            Object object = attributeSet.getAttribute(NbDocument.GUARDED);
            if (object != null && object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    super.setCharacterAttributes(n, n2, (AttributeSet)guardedSet, bl);
                } else {
                    super.setCharacterAttributes(n, n2, (AttributeSet)unguardedSet, bl);
                }
            } else {
                super.setCharacterAttributes(n, n2, attributeSet, bl);
            }
        }
    }

    public AttributedCharacterIterator[] createPrintIterators() {
        NbPrintContainer nbPrintContainer = new NbPrintContainer();
        this.print(nbPrintContainer);
        return nbPrintContainer.getIterators();
    }

    public Component createEditor(JEditorPane jEditorPane) {
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jEditorPane);
        if (editorUI == null) {
            TextUI textUI = jEditorPane.getUI();
            EditorKit editorKit = jEditorPane.getEditorKit();
            throw new IllegalStateException("NbEditorDocument.createEditor(): ui=" + textUI + ", kit=" + editorKit + ", pane=" + jEditorPane);
        }
        return editorUI.getExtComponent();
    }

    public JToolBar createToolbar(JEditorPane jEditorPane) {
        return Utilities.getEditorUI((JTextComponent)jEditorPane).getToolBarComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(Position position, int n, Annotation annotation) {
        Integer n2 = (Integer)this.annoBlackList.get(annotation);
        if (n2 != null) {
            if (n2 == -1) {
                this.annoBlackList.remove(annotation);
                return;
            }
            if (n2 < -1) {
                this.annoBlackList.put(annotation, new Integer(n2 + 1));
                return;
            }
        }
        this.readLock();
        try {
            int n3 = this.getLength();
            int n4 = position.getOffset();
            n4 = Math.min(n4, n3);
            try {
                position = this.createPosition(n4);
            }
            catch (BadLocationException badLocationException) {
                position = null;
            }
            AnnotationDescDelegate annotationDescDelegate = (AnnotationDescDelegate)((Object)this.annoMap.get(annotation));
            if (annotationDescDelegate != null) {
                annotationDescDelegate.detachListeners();
                this.getAnnotations().removeAnnotation((AnnotationDesc)annotationDescDelegate);
                this.annoMap.remove(annotation);
                this.annoBlackList.put(annotation, new Integer(n2 != null ? n2 + 1 : 1));
            }
            if (annotation.getAnnotationType() != null) {
                annotationDescDelegate = new AnnotationDescDelegate((BaseDocument)this, position, n, annotation);
                this.annoMap.put(annotation, annotationDescDelegate);
                this.getAnnotations().addAnnotation((AnnotationDesc)annotationDescDelegate);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(Annotation annotation) {
        if (annotation == null) {
            return;
        }
        Integer n = (Integer)this.annoBlackList.get(annotation);
        if (n != null) {
            if (n == 1) {
                this.annoBlackList.remove(annotation);
                return;
            }
            if (n > 1) {
                this.annoBlackList.put(annotation, new Integer(n - 1));
                return;
            }
        }
        this.readLock();
        try {
            if (annotation.getAnnotationType() != null) {
                AnnotationDescDelegate annotationDescDelegate = (AnnotationDescDelegate)((Object)this.annoMap.get(annotation));
                if (annotationDescDelegate == null) {
                    this.annoBlackList.put(annotation, new Integer(n != null ? n - 1 : -1));
                    return;
                }
                annotationDescDelegate.detachListeners();
                this.getAnnotations().removeAnnotation((AnnotationDesc)annotationDescDelegate);
                this.annoMap.remove(annotation);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    Map getAnnoMap() {
        return this.annoMap;
    }

    protected Dictionary createDocumentProperties(Dictionary dictionary) {
        return new BaseDocument.LazyPropertyMap(dictionary){

            public Object put(Object object, Object object2) {
                Object object3 = super.put(object, object2);
                if ("stream".equals(object)) {
                    assert (object2 != null);
                    if (object3 == null) {
                        IndentUtils.indentLevelSize((Document)((Object)NbEditorDocument.this));
                    } else assert (object3.equals(object2));
                }
                return object3;
            }
        };
    }

    class NbPrintContainer
    extends AttributedCharacters
    implements PrintContainer {
        ArrayList acl = new ArrayList();
        AttributedCharacters a = new AttributedCharacters();

        NbPrintContainer() {
        }

        public void add(char[] cArray, Font font, Color color, Color color2) {
            this.a.append(cArray, font, color);
        }

        public void eol() {
            this.acl.add(this.a);
            this.a = new AttributedCharacters();
        }

        public boolean initEmptyLines() {
            return true;
        }

        public AttributedCharacterIterator[] getIterators() {
            int n = this.acl.size();
            AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[n];
            for (int i = 0; i < n; ++i) {
                AttributedCharacters attributedCharacters = (AttributedCharacters)this.acl.get(i);
                attributedCharacterIteratorArray[i] = attributedCharacters.iterator();
            }
            return attributedCharacterIteratorArray;
        }
    }

    static class AnnotationDescDelegate
    extends AnnotationDesc
    implements Lookup.Provider {
        private Annotation delegate;
        private PropertyChangeListener l;
        private Position pos;
        private BaseDocument doc;

        AnnotationDescDelegate(BaseDocument baseDocument, Position position, int n, Annotation annotation) {
            super(position.getOffset(), n);
            this.pos = position;
            this.delegate = annotation;
            this.doc = baseDocument;
            this.updateAnnotationType();
            this.l = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == null || "shortDescription".equals(propertyChangeEvent.getPropertyName())) {
                        AnnotationDescDelegate.this.firePropertyChange("shortDescription", null, null);
                    }
                    if (propertyChangeEvent.getPropertyName() == null || "moveToFront".equals(propertyChangeEvent.getPropertyName())) {
                        AnnotationDescDelegate.this.firePropertyChange("moveToFront", null, null);
                    }
                    if (propertyChangeEvent.getPropertyName() == null || "annotationType".equals(propertyChangeEvent.getPropertyName())) {
                        AnnotationDescDelegate.this.updateAnnotationType();
                        AnnotationDescDelegate.this.firePropertyChange("annotationType", null, null);
                    }
                }
            };
            this.delegate.addPropertyChangeListener(this.l);
        }

        public String getAnnotationType() {
            return this.delegate.getAnnotationType();
        }

        public String getShortDescription() {
            return this.delegate.getShortDescription();
        }

        void detachListeners() {
            this.delegate.removePropertyChangeListener(this.l);
        }

        public int getOffset() {
            return this.pos.getOffset();
        }

        public int getLine() {
            try {
                return Utilities.getLineOffset((BaseDocument)this.doc, (int)this.pos.getOffset());
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.delegate);
        }
    }
}

