/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.commands.FrameworkCommand;
import org.netbeans.modules.php.spi.commands.FrameworkCommandSupport;
import org.netbeans.modules.php.symfony.SymfonyPhpFrameworkProvider;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandSupport;
import org.netbeans.modules.php.symfony.ui.options.SymfonyOptions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymfonyScript
extends PhpProgram {
    public static final String SCRIPT_NAME = "symfony";
    public static final String OPTIONS_SUB_PATH = "Symfony";
    public static final String CMD_INIT_PROJECT = "generate:project";
    public static final String CMD_CLEAR_CACHE = "cache:clear";
    public static final String CMD_INIT_APP = "generate:app";

    public SymfonyScript(String string) {
        super(string);
    }

    public static SymfonyScript getDefault() throws PhpProgram.InvalidPhpProgramException {
        String string = SymfonyOptions.getInstance().getSymfony();
        String string2 = SymfonyScript.validate(string);
        if (string2 != null) {
            throw new PhpProgram.InvalidPhpProgramException(string2);
        }
        return new SymfonyScript(string);
    }

    public static SymfonyScript forPhpModule(PhpModule phpModule, boolean bl) throws PhpProgram.InvalidPhpProgramException {
        String string = new File(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()), SCRIPT_NAME).getAbsolutePath();
        String string2 = SymfonyScript.validate(string);
        if (string2 != null) {
            if (bl) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SymfonyScript.class, (String)"MSG_InvalidProjectSymfonyScript", (Object)string2), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            return SymfonyScript.getDefault();
        }
        return new SymfonyScript(string);
    }

    public static String getOptionsPath() {
        return "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/" + SymfonyScript.getOptionsSubPath();
    }

    public static String getOptionsSubPath() {
        return OPTIONS_SUB_PATH;
    }

    public String validate() {
        if (!StringUtils.hasText((String)this.getProgram())) {
            return NbBundle.getMessage(SymfonyScript.class, (String)"MSG_NoSymfony");
        }
        File file = new File(this.getProgram());
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(SymfonyScript.class, (String)"MSG_SymfonyNotAbsolutePath");
        }
        if (!file.isFile()) {
            return NbBundle.getMessage(SymfonyScript.class, (String)"MSG_SymfonyNotFile");
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(SymfonyScript.class, (String)"MSG_SymfonyCannotRead");
        }
        return null;
    }

    public static String validate(String string) {
        return new SymfonyScript(string).validate();
    }

    public boolean initProject(PhpModule phpModule, String[] stringArray) {
        String string = phpModule.getDisplayName();
        String[] stringArray2 = SymfonyScript.mergeArrays({string}, stringArray);
        SymfonyCommandSupport symfonyCommandSupport = SymfonyPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule);
        ExternalProcessBuilder externalProcessBuilder = symfonyCommandSupport.createSilentCommand(CMD_INIT_PROJECT, stringArray2);
        if (externalProcessBuilder == null) {
            return false;
        }
        ExecutionDescriptor executionDescriptor = symfonyCommandSupport.getDescriptor();
        SymfonyScript.runService(externalProcessBuilder, executionDescriptor, symfonyCommandSupport.getOutputTitle(CMD_INIT_PROJECT, stringArray2), false);
        return SymfonyPhpFrameworkProvider.getInstance().isInPhpModule(phpModule);
    }

    public void initApp(PhpModule phpModule, String string, String[] stringArray) {
        assert (StringUtils.hasText((String)string));
        assert (stringArray != null);
        String[] stringArray2 = SymfonyScript.mergeArrays(stringArray, {string});
        SymfonyCommandSupport symfonyCommandSupport = SymfonyPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule);
        ExternalProcessBuilder externalProcessBuilder = symfonyCommandSupport.createCommand(CMD_INIT_APP, stringArray2);
        assert (externalProcessBuilder != null);
        ExecutionDescriptor executionDescriptor = symfonyCommandSupport.getDescriptor();
        SymfonyScript.runService(externalProcessBuilder, executionDescriptor, symfonyCommandSupport.getOutputTitle(CMD_INIT_APP, stringArray2), true);
    }

    public static String getHelp(PhpModule phpModule, FrameworkCommand frameworkCommand) {
        assert (phpModule != null);
        assert (frameworkCommand != null);
        SymfonyCommandSupport symfonyCommandSupport = SymfonyPhpFrameworkProvider.getInstance().getFrameworkCommandSupport(phpModule);
        ExternalProcessBuilder externalProcessBuilder = symfonyCommandSupport.createSilentCommand("help", new String[]{frameworkCommand.getCommand()});
        assert (externalProcessBuilder != null);
        final HelpLineProcessor helpLineProcessor = new HelpLineProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new FrameworkCommandSupport.ProxyInputProcessorFactory(new ExecutionDescriptor.InputProcessorFactory[]{ANSI_STRIPPING_FACTORY, new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                return InputProcessors.bridge((LineProcessor)helpLineProcessor);
            }
        }}));
        SymfonyScript.runService(externalProcessBuilder, executionDescriptor, "getting help for: " + frameworkCommand.getPreview(), true);
        return helpLineProcessor.getHelp();
    }

    static <T> T[] mergeArrays(T[] ... TArray) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T[] TArray2 : TArray) {
            linkedList.addAll(Arrays.asList(TArray2));
        }
        T[][] TArray3 = (Object[])Array.newInstance(TArray[0].getClass().getComponentType(), linkedList.size());
        return linkedList.toArray((T[])TArray3);
    }

    private static void runService(ExternalProcessBuilder externalProcessBuilder, ExecutionDescriptor executionDescriptor, String string, boolean bl) {
        try {
            SymfonyScript.executeAndWait((ExternalProcessBuilder)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)string);
        }
        catch (ExecutionException executionException) {
            if (bl) {
                UiUtils.processExecutionException((ExecutionException)executionException, (String)SymfonyScript.getOptionsSubPath());
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    static class HelpLineProcessor
    implements LineProcessor {
        private final StringBuilder buffer = new StringBuilder();

        HelpLineProcessor() {
        }

        public void processLine(String string) {
            this.buffer.append(string);
            this.buffer.append("\n");
        }

        public void reset() {
        }

        public void close() {
        }

        public String getHelp() {
            return this.buffer.toString().trim() + "\n";
        }
    }
}

