/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.nb.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.parsing.spi.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonAnalyzer
extends JsAnalyzer {
    @Override
    public List<? extends StructureItem> scan(ParserResult parserResult) {
        Node node;
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        JsAnalyzer.AnalysisResult analysisResult = jsParseResult.getStructure();
        List<? extends AstElement> list = analysisResult.getElements();
        ArrayList<StructureItem> arrayList = new ArrayList<StructureItem>(list.size());
        if (JsUtils.isJsonFile(jsParseResult.getSnapshot().getSource().getFileObject()) && jsParseResult.getRootNode() != null && (node = jsParseResult.getRootNode().getFirstChild()) != null && node.getType() == 66) {
            this.addJsonItems(false, node, arrayList, jsParseResult);
            return arrayList;
        }
        return super.scan(parserResult);
    }

    private void addJsonItems(boolean bl, Node node, List<StructureItem> list, JsParseResult jsParseResult) {
        String string;
        if (bl && (node.getType() == 66 || node.getType() == 65)) {
            return;
        }
        if (node.getType() == 165) {
            string = node.getString();
            Node node2 = AstUtilities.getLabelledNode(node);
            boolean bl2 = false;
            if (node2 != null && (node2.getType() == 66 || node2.getType() == 65)) {
                bl2 = true;
            }
            JsAnalyzer.JsFakeStructureItem jsFakeStructureItem = new JsAnalyzer.JsFakeStructureItem(string, bl2 ? ElementKind.METHOD : ElementKind.PROPERTY, null, jsParseResult);
            list.add(jsFakeStructureItem);
            jsFakeStructureItem.begin = node.getSourceStart();
            jsFakeStructureItem.end = node.getSourceEnd();
            if (bl2) {
                jsFakeStructureItem.children = new ArrayList<StructureItem>();
                list = jsFakeStructureItem.children;
                this.addJsonItems(false, node2, jsFakeStructureItem.children, jsParseResult);
            }
        }
        if (node.hasChildren()) {
            for (string = node.getFirstChild(); string != null; string = string.getNext()) {
                this.addJsonItems(true, (Node)string, list, jsParseResult);
            }
        }
    }

    private void addJsonFolds(boolean bl, Node node, List<OffsetRange> list) {
        OffsetRange offsetRange;
        if (node.getType() == 66) {
            if (bl) {
                bl = false;
            } else {
                offsetRange = AstUtilities.getRange(node);
                list.add(offsetRange);
            }
        }
        if (node.hasChildren()) {
            for (offsetRange = node.getFirstChild(); offsetRange != null; offsetRange = offsetRange.getNext()) {
                this.addJsonFolds(bl, (Node)offsetRange, list);
            }
        }
    }

    @Override
    public Map<String, List<OffsetRange>> folds(ParserResult parserResult) {
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        BaseDocument baseDocument = (BaseDocument)jsParseResult.getSnapshot().getSource().getDocument(false);
        if (baseDocument == null) {
            return Collections.emptyMap();
        }
        Node node = jsParseResult.getRootNode();
        if (node != null) {
            this.addJsonFolds(true, node, arrayList);
        }
        return hashMap;
    }

    @Override
    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false);
    }
}

