/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.resources;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.ClassSupport;

public final class ResourcesSupport {
    private static final InfoPresenter.Resolver RESOURCE_RESOLVER = new ResourceResolver();

    public static InfoPresenter createResourceInfoResolver() {
        return InfoPresenter.create((InfoPresenter.Resolver)RESOURCE_RESOLVER);
    }

    private ResourcesSupport() {
    }

    private static class ResourceResolver
    implements InfoPresenter.Resolver {
        private ResourceResolver() {
        }

        public String getDisplayName(DesignComponent designComponent, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return ClassSupport.resolveDisplayName(designComponent);
                }
                case SECONDARY: {
                    return MidpTypes.getSimpleClassName(designComponent.getType());
                }
                case TERTIARY: {
                    return "<HTML>" + InfoPresenter.getHtmlDisplayName((DesignComponent)designComponent);
                }
            }
            throw new IllegalStateException();
        }

        public DesignEventFilter getEventFilter(DesignComponent designComponent) {
            return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(designComponent, false);
        }

        public boolean isEditable(DesignComponent designComponent) {
            return true;
        }

        public String getEditableName(DesignComponent designComponent) {
            if (designComponent == null) {
                throw Debug.error((Object[])new Object[]{"Component cannot be null"});
            }
            return (String)designComponent.readProperty("instanceName").getPrimitiveValue();
        }

        public void setEditableName(DesignComponent designComponent, String string) {
            if (designComponent == null || string == null) {
                throw Debug.error((Object[])new Object[]{"Component or name cannot be null"});
            }
            designComponent.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(designComponent, string));
        }

        public Image getIcon(DesignComponent designComponent, InfoPresenter.IconType iconType) {
            if (InfoPresenter.IconType.COLOR_16x16.equals((Object)iconType)) {
                for (ComponentDescriptor componentDescriptor = designComponent.getComponentDescriptor(); componentDescriptor != null; componentDescriptor = componentDescriptor.getSuperDescriptor()) {
                    Image image = MidpTypes.getRegisteredIcon(componentDescriptor.getTypeDescriptor().getThisType());
                    if (image == null) continue;
                    return image;
                }
            }
            return null;
        }
    }
}

