/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.midp.components.ProjectResourceResolver;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MidpProjectSupport {
    private static final Lookup.Result<ProjectResourceResolver> resolvers = Lookup.getDefault().lookupResult(ProjectResourceResolver.class);

    private MidpProjectSupport() {
    }

    public static Collection<? extends ProjectResourceResolver> getAllResolvers() {
        return resolvers.allInstances();
    }

    public static void addLibraryToProject(final DesignDocument designDocument, final String ... stringArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Project project = MidpProjectSupport.getProjectForDocument(designDocument);
                if (project == null) {
                    return;
                }
                ProjectClassPathExtender projectClassPathExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
                LibraryManager libraryManager = LibraryManager.getDefault();
                for (String string : stringArray) {
                    Library library = libraryManager.getLibrary(string);
                    if (library == null) continue;
                    try {
                        projectClassPathExtender.addLibrary(library);
                    }
                    catch (IOException iOException) {
                        Debug.warning((Object[])new Object[]{iOException});
                    }
                }
            }
        });
    }

    public static void addArchiveFileToProject(final DesignDocument designDocument, final FileObject ... fileObjectArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Project project = MidpProjectSupport.getProjectForDocument(designDocument);
                if (project == null) {
                    return;
                }
                ProjectClassPathExtender projectClassPathExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
                for (FileObject fileObject : fileObjectArray) {
                    if (fileObject == null || !fileObject.isValid()) continue;
                    try {
                        projectClassPathExtender.addArchiveFile(fileObject);
                    }
                    catch (IOException iOException) {
                        Debug.warning((Object[])new Object[]{iOException});
                    }
                }
            }
        });
    }

    public static Project getProjectForDocument(DesignDocument designDocument) {
        if (designDocument == null) {
            return null;
        }
        DataObjectContext dataObjectContext = org.netbeans.modules.vmd.api.io.ProjectUtils.getDataObjectContextForDocument((DesignDocument)designDocument);
        if (dataObjectContext == null) {
            return null;
        }
        return org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DataObjectContext)dataObjectContext);
    }

    public static Map<FileObject, FileObject> getFileObjectsForRelativeResourcePath(DesignDocument designDocument, String string) {
        Object object;
        Object object2;
        assert (designDocument != null);
        assert (string != null);
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        HashMap<FileObject, FileObject> hashMap = new HashMap<FileObject, FileObject>();
        DataObjectContext dataObjectContext = org.netbeans.modules.vmd.api.io.ProjectUtils.getDataObjectContextForDocument((DesignDocument)designDocument);
        if (dataObjectContext == null) {
            return Collections.emptyMap();
        }
        DataObject dataObject = dataObjectContext.getDataObject();
        assert (dataObject != null);
        FileObject fileObject = dataObject.getPrimaryFile();
        assert (fileObject != null);
        Project project = MidpProjectSupport.getProjectForDocument(designDocument);
        if (project == null || fileObject == null || !fileObject.isValid()) {
            return new HashMap<FileObject, FileObject>(0);
        }
        List<ClassPath> list = MidpProjectSupport.getClassPath(project, fileObject);
        assert (list != null);
        for (ClassPath object3 : list) {
            for (FileObject fileObject2 : object2 = object3.getRoots()) {
                object = fileObject2.getChildren(true);
                while (object.hasMoreElements()) {
                    FileObject fileObject3 = (FileObject)object.nextElement();
                    String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject3);
                    if (!string.equals(string2)) continue;
                    hashMap.put(fileObject3, fileObject2);
                }
            }
        }
        for (ProjectResourceResolver projectResourceResolver : resolvers.allInstances()) {
            object2 = projectResourceResolver.getResourceRoots(project, designDocument.getDocumentInterface().getProjectType());
            if (object2 == null) continue;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject4 = (FileObject)iterator.next();
                Enumeration enumeration = fileObject4.getChildren(true);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2;
                    fileObject2 = (FileObject)enumeration.nextElement();
                    object = FileUtil.getRelativePath((FileObject)fileObject4, (FileObject)fileObject2);
                    if (!string.equals(object)) continue;
                    hashMap.put(fileObject2, fileObject4);
                }
            }
        }
        return hashMap;
    }

    public static Map<FileObject, String> getImagesForProject(DesignDocument designDocument, boolean bl) {
        String string = "jpeg";
        String string2 = "jpg";
        String string3 = "gif";
        String string4 = "png";
        assert (designDocument != null);
        Map<FileObject, String> map = null;
        map = bl ? MidpProjectSupport.getAllFilesForProjectByExt(designDocument, Arrays.asList(string4)) : MidpProjectSupport.getAllFilesForProjectByExt(designDocument, Arrays.asList(string, string2, string3, string4));
        return map;
    }

    public static Map<FileObject, String> getAllFilesForProjectByExt(DesignDocument designDocument, Collection<String> collection) {
        Object object;
        assert (collection != null);
        assert (designDocument != null);
        WeakHashMap<FileObject, String> weakHashMap = new WeakHashMap<FileObject, String>();
        DataObjectContext dataObjectContext = org.netbeans.modules.vmd.api.io.ProjectUtils.getDataObjectContextForDocument((DesignDocument)designDocument);
        if (dataObjectContext == null) {
            return Collections.EMPTY_MAP;
        }
        DataObject dataObject = dataObjectContext.getDataObject();
        if (dataObject == null) {
            return Collections.EMPTY_MAP;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject == null) {
            return Collections.EMPTY_MAP;
        }
        Project project = MidpProjectSupport.getProjectForDocument(designDocument);
        List<ClassPath> list = MidpProjectSupport.getClassPath(project, fileObject);
        if (list == null) {
            return Collections.EMPTY_MAP;
        }
        for (ClassPath object2 : list) {
            for (FileObject fileObject2 : object = object2.getRoots()) {
                MidpProjectSupport.extractFiles(fileObject2, fileObject2, weakHashMap, collection);
            }
        }
        for (ProjectResourceResolver projectResourceResolver : resolvers.allInstances()) {
            object = projectResourceResolver.getResourceRoots(project, designDocument.getDocumentInterface().getProjectType());
            if (object == null) continue;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject3 = (FileObject)iterator.next();
                MidpProjectSupport.extractFiles(fileObject3, fileObject3, weakHashMap, collection);
            }
        }
        return weakHashMap;
    }

    private static void extractFiles(FileObject fileObject, FileObject fileObject2, Map<FileObject, String> map, Collection<String> collection) {
        if (fileObject2.isFolder()) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
                MidpProjectSupport.extractFiles(fileObject, fileObject3, map, collection);
            }
        } else {
            String string = fileObject2.getExt();
            for (String string2 : collection) {
                if (!string2.equalsIgnoreCase(string)) continue;
                String string3 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                map.put(fileObject2, "/" + string3);
            }
        }
    }

    private static List<ClassPath> getClassPath(Project project, FileObject fileObject) {
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        arrayList.add(classPathProvider.findClassPath(fileObject, "classpath/compile"));
        arrayList.add(classPathProvider.findClassPath(fileObject, "classpath/source"));
        return arrayList;
    }

    public static ClasspathInfo getClasspathInfo(Project project) {
        SourceGroup sourceGroup = MidpProjectSupport.getSourceGroup(project);
        if (sourceGroup == null) {
            return null;
        }
        FileObject fileObject = sourceGroup.getRootFolder();
        return ClasspathInfo.create((FileObject)fileObject);
    }

    public static SourceGroup getSourceGroup(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            return null;
        }
        return sourceGroupArray[0];
    }
}

