/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.serialization.ComponentElement;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandler;
import org.netbeans.modules.vmd.api.io.serialization.DocumentSerializationController;
import org.netbeans.modules.vmd.api.io.serialization.PropertyElement;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ControllersCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.DisplayablesCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.PointsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.components.general.RootCD;
import org.netbeans.modules.vmd.midp.components.items.ItemCD;
import org.netbeans.modules.vmd.midp.palette.wizard.ComponentInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidpDocumentSerializationController
extends DocumentSerializationController {
    public static final String VERSION_1 = "1";
    private Collection<String> unresolved = new HashSet<String>();

    public void approveComponents(DataObjectContext dataObjectContext, DesignDocument designDocument, String string, final Collection<ComponentElement> collection, DocumentErrorHandler documentErrorHandler) {
        final DescriptorRegistry descriptorRegistry = designDocument.getDescriptorRegistry();
        descriptorRegistry.readAccess(new Runnable(){

            public void run() {
                for (ComponentElement componentElement : collection) {
                    String string = componentElement.getTypeID().getString();
                    if (!MidpTypes.isValidFQNClassName(string) || descriptorRegistry.getComponentDescriptor(new TypeID(TypeID.Kind.COMPONENT, string)) != null) continue;
                    MidpDocumentSerializationController.this.unresolved.add(string);
                }
            }
        });
        if (!this.unresolved.isEmpty()) {
            Map<String, ComponentInstaller.Item> map = ComponentInstaller.search(ProjectUtils.getProject((DataObjectContext)dataObjectContext));
            ArrayList<ComponentInstaller.Item> arrayList = new ArrayList<ComponentInstaller.Item>();
            for (String string2 : this.unresolved) {
                ComponentInstaller.Item item = map.get(string2);
                if (item == null) continue;
                arrayList.add(item);
            }
            ComponentInstaller.install(map, arrayList);
        }
    }

    public void approveProperties(DataObjectContext dataObjectContext, DesignDocument designDocument, String string, DesignComponent designComponent, Collection<PropertyElement> collection, DocumentErrorHandler documentErrorHandler) {
        if (!"vmd-midp".equals(dataObjectContext.getProjectType()) || !VERSION_1.equals(string)) {
            return;
        }
        if (designDocument.getDescriptorRegistry().isInHierarchy(ItemCD.TYPEID, designComponent.getType())) {
            ArrayList<PropertyElement> arrayList = new ArrayList<PropertyElement>();
            ArrayList<PropertyElement> arrayList2 = new ArrayList<PropertyElement>();
            for (PropertyElement propertyElement : collection) {
                if (!"itemCommandlistener".equals(propertyElement.getPropertyName())) continue;
                arrayList.add(propertyElement);
                arrayList2.add(PropertyElement.create((String)"itemCommandListener", (TypeID)propertyElement.getTypeID(), (String)propertyElement.getSerialized()));
                break;
            }
            collection.removeAll(arrayList);
            collection.addAll(arrayList2);
            for (PropertyElement propertyElement : collection) {
                propertyElement.getSerialized();
            }
        }
    }

    public void postValidateDocument(DataObjectContext dataObjectContext, DesignDocument designDocument, String string, DocumentErrorHandler documentErrorHandler) {
        if (!"vmd-midp".equals(dataObjectContext.getProjectType()) || !VERSION_1.equals(string)) {
            return;
        }
        DesignComponent designComponent = designDocument.getRootComponent();
        if (designComponent == null) {
            designComponent = designDocument.createComponent(RootCD.TYPEID);
            designDocument.setRootComponent(designComponent);
        }
        MidpDocumentSupport.getCategoryComponent(designDocument, CommandsCategoryCD.TYPEID);
        MidpDocumentSupport.getCategoryComponent(designDocument, ControllersCategoryCD.TYPEID);
        MidpDocumentSupport.getCategoryComponent(designDocument, DisplayablesCategoryCD.TYPEID);
        MidpDocumentSupport.getCategoryComponent(designDocument, PointsCategoryCD.TYPEID);
        MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID);
    }
}

