/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTBaseMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroCache;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTFileMacroMap
extends APTBaseMacroMap {
    private static final Map<CharSequence, APTMacro> NO_CACHE = Collections.unmodifiableMap(new HashMap(0));
    private static final int INITIAL_CACHE_SIZE = 512;
    private APTMacroMap sysMacroMap;
    private Map<CharSequence, APTMacro> macroCache = NO_CACHE;
    private int crc1 = 0;
    private int crc2 = 0;
    private LinkedList<CharSequence> expandingMacros = new LinkedList();
    private static final APTMacroCache cache = APTMacroCache.getManager();

    public APTFileMacroMap() {
    }

    public APTFileMacroMap(APTMacroMap aPTMacroMap, List<String> list) {
        if (aPTMacroMap == null) {
            aPTMacroMap = APTBaseMacroMap.EMPTY;
        }
        this.sysMacroMap = aPTMacroMap;
        this.macroCache = new HashMap<CharSequence, APTMacro>(512);
        this.fill(list, false);
    }

    @Override
    public APTMacro getMacro(APTToken aPTToken) {
        CharSequence charSequence = aPTToken.getTextID();
        this.initCache();
        APTMacro aPTMacro = this.macroCache.get(charSequence);
        if (aPTMacro == null) {
            if (aPTMacro == null && this.sysMacroMap != null) {
                aPTMacro = this.sysMacroMap.getMacro(aPTToken);
            }
            if (aPTMacro == null) {
                aPTMacro = APTMacroMapSnapshot.UNDEFINED_MACRO;
            }
            if (aPTMacro.getKind() != APTMacro.Kind.POSITION_PREDEFINED) {
                this.macroCache.put(charSequence, aPTMacro);
            }
        }
        return aPTMacro != APTMacroMapSnapshot.UNDEFINED_MACRO ? aPTMacro : null;
    }

    @Override
    protected void putMacro(CharSequence charSequence, APTMacro aPTMacro) {
        int n;
        this.initCache();
        super.putMacro(charSequence, aPTMacro);
        APTMacro aPTMacro2 = this.macroCache.put(charSequence, aPTMacro);
        int n2 = charSequence.hashCode();
        if (aPTMacro2 != null) {
            n = aPTMacro2.hashCode();
            this.crc1 -= n2 + n;
            this.crc2 -= n2 ^ n;
        }
        if (aPTMacro != APTMacroMapSnapshot.UNDEFINED_MACRO) {
            n = aPTMacro.hashCode();
            this.crc1 += n2 + n;
            this.crc2 += n2 ^ n;
        }
    }

    @Override
    protected APTMacro createMacro(CharSequence charSequence, APTDefine aPTDefine, APTMacro.Kind kind) {
        APTMacro aPTMacro = new APTMacroImpl(charSequence, aPTDefine, kind);
        if (APTTraceFlags.APT_SHARE_MACROS) {
            aPTMacro = cache.getMacro(aPTMacro);
        }
        return aPTMacro;
    }

    @Override
    protected APTMacroMapSnapshot makeSnapshot(APTMacroMapSnapshot aPTMacroMapSnapshot) {
        return new APTMacroMapSnapshot(aPTMacroMapSnapshot);
    }

    @Override
    public APTMacroMap.State getState() {
        this.changeActiveSnapshotIfNeeded();
        return new FileStateImpl(this.active.parent, this.sysMacroMap, this.crc1, this.crc2);
    }

    @Override
    public void setState(APTMacroMap.State state) {
        this.active = this.makeSnapshot(((APTBaseMacroMap.StateImpl)state).snap);
        this.crc1 = 0;
        this.crc2 = 0;
        if (state instanceof FileStateImpl) {
            FileStateImpl fileStateImpl = (FileStateImpl)state;
            this.sysMacroMap = fileStateImpl.sysMacroMap;
            this.crc1 = fileStateImpl.crc1;
            this.crc2 = fileStateImpl.crc2;
        }
        this.macroCache = NO_CACHE;
    }

    private void initCache() {
        if (this.macroCache == NO_CACHE) {
            this.macroCache = new HashMap<CharSequence, APTMacro>(512);
            APTMacroMapSnapshot.addAllMacros(this.active, this.macroCache);
            if (this.crc1 == 0 && this.crc2 == 0) {
                for (Map.Entry<CharSequence, APTMacro> entry : this.macroCache.entrySet()) {
                    int n = entry.getKey().hashCode();
                    int n2 = entry.getValue().hashCode();
                    this.crc1 += n + n2;
                    this.crc2 += n ^ n2;
                }
            }
        }
    }

    public APTHandlersSupport.StateKey getStateKey() {
        return new APTHandlersSupport.StateKey(this.crc1, this.crc2);
    }

    @Override
    public boolean pushExpanding(APTToken aPTToken) {
        assert (aPTToken != null);
        if (!this.isExpanding(aPTToken)) {
            this.expandingMacros.addLast(aPTToken.getTextID());
            return true;
        }
        return false;
    }

    @Override
    public void popExpanding() {
        block2: {
            try {
                this.expandingMacros.removeLast();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"why pop from empty stack?");
            }
        }
    }

    @Override
    public boolean isExpanding(APTToken aPTToken) {
        try {
            return this.expandingMacros.contains(aPTToken.getTextID());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            assert (false) : "why ask empty stack?";
            return false;
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Own Map:\n");
        stringBuilder.append(super.toString());
        stringBuilder.append("System Map:\n");
        stringBuilder.append(this.sysMacroMap);
        return stringBuilder.toString();
    }

    public static class FileStateImpl
    extends APTBaseMacroMap.StateImpl {
        private final APTMacroMap sysMacroMap;
        private final int crc1;
        private final int crc2;

        private FileStateImpl(APTMacroMapSnapshot aPTMacroMapSnapshot, APTMacroMap aPTMacroMap, int n, int n2) {
            super(aPTMacroMapSnapshot);
            this.sysMacroMap = aPTMacroMap;
            this.crc1 = n;
            this.crc2 = n2;
        }

        private FileStateImpl(FileStateImpl fileStateImpl, boolean bl) {
            super(fileStateImpl, bl);
            this.sysMacroMap = fileStateImpl.sysMacroMap;
            this.crc1 = fileStateImpl.crc1;
            this.crc2 = fileStateImpl.crc2;
        }

        APTHandlersSupport.StateKey getStateKey() {
            return new APTHandlersSupport.StateKey(this.crc1, this.crc2);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("FileState\n");
            stringBuilder.append("Snapshot\n");
            stringBuilder.append(super.toString());
            stringBuilder.append("\nSystem MacroMap\n");
            stringBuilder.append(this.sysMacroMap);
            return stringBuilder.toString();
        }

        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            dataOutput.writeInt(this.crc1);
            dataOutput.writeInt(this.crc2);
            APTSerializeUtils.writeSystemMacroMap(this.sysMacroMap, dataOutput);
        }

        public FileStateImpl(DataInput dataInput) throws IOException {
            super(dataInput);
            this.crc1 = dataInput.readInt();
            this.crc2 = dataInput.readInt();
            APTMacroMap aPTMacroMap = APTSerializeUtils.readSystemMacroMap(dataInput);
            this.sysMacroMap = aPTMacroMap == null ? APTBaseMacroMap.EMPTY : aPTMacroMap;
        }

        public APTBaseMacroMap.StateImpl copyCleaned() {
            return new FileStateImpl(this, true);
        }
    }
}

