/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.runprofiles;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.DirectoryChooserPanel;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.configurations.ui.ListenableIntNodeProp;
import org.netbeans.modules.cnd.makeproject.runprofiles.RunProfileXMLCodec;
import org.netbeans.modules.cnd.makeproject.runprofiles.ui.EnvPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RunProfile
implements ConfigurationAuxObject {
    private static final boolean NO_EXEPTION = Boolean.getBoolean("org.netbeans.modules.cnd.makeproject.api.runprofiles");
    public static final String PROFILE_ID = "runprofile";
    public static final String PROP_RUNARGS_CHANGED = "runargs-ch";
    public static final String PROP_RUNDIR_CHANGED = "rundir-ch";
    public static final String PROP_ENVVARS_CHANGED = "envvars-ch";
    private PropertyChangeSupport pcs = null;
    private boolean needSave = false;
    private RunProfile cloneOf;
    private boolean defaultProfile;
    private String argsFlat;
    private boolean argsFlatValid = false;
    private String[] argsArray;
    private boolean argsArrayValid = false;
    private String baseDir;
    private String runDir;
    private boolean buildFirst;
    private Env environment;
    private String dorun;
    public static final int CONSOLE_TYPE_DEFAULT = 0;
    public static final int CONSOLE_TYPE_EXTERNAL = 1;
    public static final int CONSOLE_TYPE_OUTPUT_WINDOW = 2;
    private static final String[] consoleTypeNames = new String[]{RunProfile.getString("ConsoleType_Default"), RunProfile.getString("ConsoleType_External"), RunProfile.getString("ConsoleType_Output")};
    private IntConfiguration consoleType;
    private IntConfiguration terminalType;
    private HashMap<String, String> termPaths;
    private HashMap<String, String> termOptions;
    private final int platform;
    public static final int REMOVE_INSTRUMENTATION_ASK = 0;
    public static final int REMOVE_INSTRUMENTATION_YES = 1;
    public static final int REMOVE_INSTRUMENTATION_NO = 2;
    private static final String[] removeInstrumentationNames = new String[]{RunProfile.getString("RemoveInstrumentation_Ask"), RunProfile.getString("RemoveInstrumentation_Yes"), RunProfile.getString("RemoveInstrumentation_No")};
    private IntConfiguration removeInstrumentation;
    private static Boolean hasTHAModule = null;

    @Deprecated
    public RunProfile(String string) {
        this(string, Platform.getDefaultPlatform());
    }

    public RunProfile(String string, int n) {
        this.platform = n;
        this.baseDir = string;
        this.pcs = null;
        this.initialize();
    }

    public RunProfile(String string, PropertyChangeSupport propertyChangeSupport) {
        this.platform = Platform.getDefaultPlatform();
        this.baseDir = string;
        this.pcs = propertyChangeSupport;
        this.initialize();
    }

    public void initialize() {
        this.environment = new Env();
        this.defaultProfile = false;
        this.argsFlat = "";
        this.argsFlatValid = true;
        this.argsArrayValid = false;
        this.runDir = "";
        this.buildFirst = true;
        this.dorun = this.getDorunScript();
        this.termPaths = new HashMap();
        this.termOptions = new HashMap();
        this.consoleType = new IntConfiguration(null, 0, consoleTypeNames, null);
        this.terminalType = new IntConfiguration(null, 0, this.setTerminalTypeNames(), null);
        this.removeInstrumentation = new IntConfiguration(null, 0, removeInstrumentationNames, null);
        this.clearChanged();
    }

    private String escapeDir(String string) {
        String string2;
        if (string != null && !(string = string.trim()).startsWith(string2 = "\"")) {
            string = string2 + string + string2;
        }
        return string;
    }

    private String getDorunScript() {
        File file = InstalledFileLocator.getDefault().locate("bin/dorun.sh", null, false);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        if (!NO_EXEPTION) {
            throw new IllegalStateException(RunProfile.getString("Err_MissingDorunScript"));
        }
        return null;
    }

    private boolean isWindows() {
        return this.platform == 3;
    }

    private String[] setTerminalTypeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = RunProfile.getString("TerminalType_Default");
        arrayList.add(string);
        if (this.isWindows()) {
            String string2 = RunProfile.getString("TerminalType_CommandWindow");
            arrayList.add(string2);
            this.termPaths.put(string2, "cmd.exe");
            this.termPaths.put(string, "cmd.exe");
            this.termOptions.put(string2, "/c start sh \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + " \" -f \"{0}\" {1} {2}");
            this.termOptions.put(string, "/c start sh \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + " \" -f \"{0}\" {1} {2}");
        } else {
            String string3;
            String string4 = Path.getPathAsString() + ":/usr/X11/bin:/usr/X/bin:/usr/X11R6/bin:/opt/gnome/bin" + ":/usr/gnome/bin:/opt/kde/bin:/opt/kde4/bin:/opt/kde3/bin:/usr/kde/bin:/usr/openwin/bin";
            String string5 = this.searchPath(string4, "gnome-terminal", "/usr/bin");
            if (string5 != null) {
                string3 = RunProfile.getString("TerminalType_GNOME");
                arrayList.add(string3);
                this.termPaths.put(string3, string5);
                this.termPaths.put(string, string5);
                String string6 = "--disable-factory --hide-menubar --title=\"{1} {3}\" -x \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" " + "-f \"{0}\" {1} {2}";
                this.termOptions.put(string3, string6);
                this.termOptions.put(string, string6);
            }
            if ((string5 = this.searchPath(string4, "konsole")) != null) {
                string3 = RunProfile.getString("TerminalType_KDE");
                arrayList.add(string3);
                this.termPaths.put(string3, string5);
                this.termOptions.put(string3, "--workdir " + this.escapeDir(this.baseDir) + " -e \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" -f \"{0}\" {1} {2}");
                if (this.termPaths.get(string) == null) {
                    this.termPaths.put(string, string5);
                    this.termOptions.put(string, "--workdir " + this.escapeDir(this.baseDir) + " -e \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" -f \"{0}\" {1} {2}");
                }
            }
            if ((string5 = this.searchPath(string4, "xterm", Utilities.getOperatingSystem() == 8 ? "/usr/openwin/bin" : "/usr/bin")) != null) {
                string3 = RunProfile.getString("TerminalType_XTerm");
                arrayList.add(string3);
                this.termPaths.put(string3, string5);
                this.termOptions.put(string3, "-e \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" -f \"{0}\" {1} {2}");
                if (this.termPaths.get(string) == null) {
                    this.termPaths.put(string, string5);
                    this.termOptions.put(string, "-e \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" -f \"{0}\" {1} {2}");
                }
            }
            if (this.termPaths.get(string) == null) {
                arrayList.add(RunProfile.getString("TerminalType_None"));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String searchPath(String string, String string2) {
        return this.searchPath(string, string2, null);
    }

    private String searchPath(final String string, final String string2, String string3) {
        Object object;
        if (string3 != null && ((File)(object = new File(string3, string2))).exists()) {
            return ((File)object).getAbsolutePath();
        }
        object = new String[]{null};
        Thread thread = new Thread(new Runnable((String[])object){
            final /* synthetic */ String[] val$patharray;
            {
                this.val$patharray = stringArray;
            }

            public void run() {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    File file = new File(string3, string2);
                    if (!file.exists()) continue;
                    this.val$patharray[0] = file.getAbsolutePath();
                    break;
                }
            }
        });
        thread.start();
        try {
            thread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return object[0];
    }

    public String getTerminalPath() {
        return this.termPaths.get(this.getTerminalType().getName());
    }

    public String getTerminalOptions() {
        return this.termOptions.get(this.getTerminalType().getName());
    }

    public boolean shared() {
        return false;
    }

    public String getId() {
        return PROFILE_ID;
    }

    public void setCloneOf(RunProfile runProfile) {
        this.cloneOf = runProfile;
    }

    public RunProfile getCloneOf() {
        return this.cloneOf;
    }

    public boolean isDefault() {
        return this.defaultProfile;
    }

    public void setDefault(boolean bl) {
        this.defaultProfile = bl;
    }

    public void setArgs(String string) {
        String string2 = this.getArgsFlat();
        this.argsFlat = string;
        this.argsFlatValid = true;
        this.argsArrayValid = false;
        if (this.pcs != null && !IpeUtils.sameString((String)string2, (String)string)) {
            this.pcs.firePropertyChange(PROP_RUNARGS_CHANGED, string2, string);
        }
        this.needSave = true;
    }

    public void setArgs(String[] stringArray) {
        String[] stringArray2 = this.getArgsArray();
        this.argsArray = stringArray;
        this.argsFlatValid = false;
        this.argsArrayValid = true;
        if (this.pcs != null && !IpeUtils.sameStringArray((String[])stringArray2, (String[])stringArray)) {
            this.pcs.firePropertyChange(PROP_RUNARGS_CHANGED, stringArray2, stringArray);
        }
        this.needSave = true;
    }

    public void setArgsRaw(String string) {
        this.argsFlat = string;
        this.argsFlatValid = true;
        this.argsArrayValid = false;
        this.needSave = true;
    }

    public String getArgsFlat() {
        if (!this.argsFlatValid) {
            this.argsFlat = "";
            for (int i = 0; i < this.argsArray.length; ++i) {
                this.argsFlat = this.argsFlat + IpeUtils.quoteIfNecessary((String)this.argsArray[i]);
                if (i >= this.argsArray.length - 1) continue;
                this.argsFlat = this.argsFlat + " ";
            }
            this.argsFlatValid = true;
        }
        return this.argsFlat;
    }

    public String[] getArgsArray() {
        if (!this.argsArrayValid) {
            this.argsArray = Utilities.parseParameters((String)this.argsFlat);
            this.argsArrayValid = true;
        }
        return this.argsArray;
    }

    public String[] getArgv(String string) {
        String[] stringArray = new String[this.getArgsArray().length + 1];
        stringArray[0] = string;
        for (int i = 0; i < this.getArgsArray().length; ++i) {
            stringArray[i + 1] = this.getArgsArray()[i];
        }
        return stringArray;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String string) {
        assert (string != null && IpeUtils.isPathAbsolute((String)string));
        this.baseDir = string;
    }

    public String getRunDir() {
        if (this.runDir == null) {
            this.runDir = "";
        }
        return this.runDir;
    }

    public void setRunDir(String string) {
        if (string == null) {
            string = "";
        }
        if (this.runDir != null && this.runDir.equals(string)) {
            return;
        }
        this.runDir = string;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_RUNDIR_CHANGED, null, this);
        }
        this.needSave = true;
    }

    public String getRunDirectory() {
        String string;
        String string2;
        File file;
        String string3 = this.getRunDir();
        if (string3.length() == 0) {
            string3 = ".";
        }
        if (!(file = new File(string2 = IpeUtils.isPathAbsolute((String)string3) ? string3 : this.getBaseDir() + "/" + string3)).exists() || !file.isDirectory()) {
            return string2;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = string2;
        }
        return string;
    }

    public void setRunDirectory(String string) {
        if (string == null || string.length() == 0) {
            string = ".";
        }
        this.setRunDir(IpeUtils.toAbsoluteOrRelativePath((String)this.getBaseDir(), (String)string));
    }

    public void setBuildFirst(boolean bl) {
        this.buildFirst = bl;
    }

    public boolean getBuildFirst() {
        return this.buildFirst;
    }

    public Env getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Env env) {
        Env env2 = this.environment;
        this.environment = env;
        if (this.pcs != null && !this.environment.equals(env2)) {
            this.pcs.firePropertyChange(PROP_ENVVARS_CHANGED, env2, this.environment);
        }
    }

    public IntConfiguration getConsoleType() {
        return this.consoleType;
    }

    public void setConsoleType(IntConfiguration intConfiguration) {
        this.consoleType = intConfiguration;
    }

    public static int getDefaultConsoleType() {
        return 1;
    }

    public IntConfiguration getTerminalType() {
        if (this.terminalType.getName().equals(RunProfile.getString("TerminalType_None"))) {
            return null;
        }
        return this.terminalType;
    }

    public void setTerminalType(IntConfiguration intConfiguration) {
        this.terminalType = intConfiguration;
    }

    public IntConfiguration getRemoveInstrumentation() {
        return this.removeInstrumentation;
    }

    public void setRemoveInstrumentation(IntConfiguration intConfiguration) {
        this.removeInstrumentation = intConfiguration;
    }

    public void saveToDisk() {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public XMLDecoder getXMLDecoder() {
        return new RunProfileXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new RunProfileXMLCodec(this);
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public void assign(ConfigurationAuxObject configurationAuxObject) {
        if (!(configurationAuxObject instanceof RunProfile)) {
            System.err.print("Profile - assign: Profile object type expected - got " + configurationAuxObject);
            return;
        }
        RunProfile runProfile = (RunProfile)configurationAuxObject;
        this.setDefault(runProfile.isDefault());
        this.setArgs(runProfile.getArgsFlat());
        this.setBaseDir(runProfile.getBaseDir());
        this.setRunDir(runProfile.getRunDir());
        this.setBuildFirst(runProfile.getBuildFirst());
        this.getEnvironment().assign(runProfile.getEnvironment());
        this.getConsoleType().assign(runProfile.getConsoleType());
        this.getTerminalType().assign(runProfile.getTerminalType());
        this.getRemoveInstrumentation().assign(runProfile.getRemoveInstrumentation());
    }

    public RunProfile clone(Configuration configuration) {
        RunProfile runProfile = new RunProfile(this.getBaseDir(), this.platform);
        runProfile.setCloneOf(this);
        runProfile.setDefault(this.isDefault());
        runProfile.setArgs(this.getArgsFlat());
        runProfile.setRunDir(this.getRunDir());
        runProfile.setBuildFirst(this.getBuildFirst());
        runProfile.setEnvironment(this.getEnvironment().clone());
        runProfile.setConsoleType(this.getConsoleType().clone());
        runProfile.setTerminalType(this.getTerminalType().clone());
        runProfile.setRemoveInstrumentation(this.getRemoveInstrumentation().clone());
        return runProfile;
    }

    public Sheet getSheet(boolean bl) {
        return this.createSheet(bl);
    }

    public Sheet getSheet() {
        return this.createSheet(false);
    }

    private Sheet createSheet(boolean bl) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(RunProfile.getString("GeneralName"));
        set.setShortDescription(RunProfile.getString("GeneralTT"));
        set.put((Node.Property)new ArgumentsNodeProp());
        set.put((Node.Property)new RunDirectoryNodeProp());
        set.put((Node.Property)new EnvNodeProp());
        set.put((Node.Property)new BuildFirstNodeProp());
        ListenableIntNodeProp listenableIntNodeProp = new ListenableIntNodeProp(this.getConsoleType(), true, null, RunProfile.getString("ConsoleType_LBL"), RunProfile.getString("ConsoleType_HINT"));
        set.put((Node.Property)listenableIntNodeProp);
        final IntNodeProp intNodeProp = new IntNodeProp(this.getTerminalType(), true, null, RunProfile.getString("TerminalType_LBL"), RunProfile.getString("TerminalType_HINT"));
        set.put((Node.Property)intNodeProp);
        if (bl) {
            intNodeProp.setCanWrite(false);
            listenableIntNodeProp.setCanWrite(false);
        } else {
            listenableIntNodeProp.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    RunProfile.updateTerminalTypeState(intNodeProp, string);
                }
            });
            RunProfile.updateTerminalTypeState(intNodeProp, consoleTypeNames[(Integer)listenableIntNodeProp.getValue()]);
        }
        if (RunProfile.thaSupportEnabled()) {
            set.put((Node.Property)new IntNodeProp(this.getRemoveInstrumentation(), true, null, RunProfile.getString("RemoveInstrumentation_LBL"), RunProfile.getString("RemoveInstrumentation_HINT")));
        }
        sheet.put(set);
        return sheet;
    }

    private static void updateTerminalTypeState(IntNodeProp intNodeProp, String string) {
        intNodeProp.setCanWrite(consoleTypeNames[1].equals(string) || consoleTypeNames[0].equals(string) && RunProfile.getDefaultConsoleType() == 1);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(RunProfile.class, (String)string);
    }

    private static synchronized boolean thaSupportEnabled() {
        if (hasTHAModule == null) {
            hasTHAModule = Boolean.FALSE;
            FileObject fileObject = FileUtil.getConfigRoot();
            FileObject fileObject2 = fileObject.getFileObject("DLight/Configurations/THA");
            hasTHAModule = fileObject2 != null && fileObject2.isFolder();
        }
        return hasTHAModule;
    }

    private static class EnvEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private Env env;
        private PropertyEnv propenv;

        public EnvEditor(Env env) {
            this.env = env;
        }

        public void setAsText(String string) {
        }

        public String getAsText() {
            return this.env.toString();
        }

        public Component getCustomEditor() {
            return new EnvPanel(this.env, this, this.propenv);
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv propertyEnv) {
            this.propenv = propertyEnv;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnvNodeProp
    extends PropertySupport<Env> {
        public EnvNodeProp() {
            super("Environment", Env.class, RunProfile.getString("EnvironmentName"), RunProfile.getString("EnvironmentHint"), true, true);
        }

        public Env getValue() {
            return RunProfile.this.getEnvironment();
        }

        public void setValue(Env env) {
            RunProfile.this.getEnvironment().assign(env);
        }

        public PropertyEditor getPropertyEditor() {
            return new EnvEditor(RunProfile.this.getEnvironment().clone());
        }

        public Object getValue(String string) {
            if (string.equals("canEditAsText")) {
                return Boolean.FALSE;
            }
            return super.getValue(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildFirstNodeProp
    extends PropertySupport<Boolean> {
        public BuildFirstNodeProp() {
            super("Build First", Boolean.class, RunProfile.getString("BuildFirstName"), RunProfile.getString("BuildFirstHint"), true, true);
        }

        public Boolean getValue() {
            return RunProfile.this.getBuildFirst();
        }

        public void setValue(Boolean bl) {
            RunProfile.this.setBuildFirst(bl);
        }
    }

    private class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private String seed;

        public DirEditor(String string) {
            this.seed = string;
        }

        public void setAsText(String string) {
            RunProfile.this.setRunDir(string);
        }

        public String getAsText() {
            return RunProfile.this.getRunDir();
        }

        public Object getValue() {
            return RunProfile.this.getRunDir();
        }

        public void setValue(Object object) {
            RunProfile.this.setRunDir((String)object);
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            return new DirectoryChooserPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propertyEnv) {
            this.propenv = propertyEnv;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunDirectoryNodeProp
    extends PropertySupport<String> {
        public RunDirectoryNodeProp() {
            super("Run Directory", String.class, RunProfile.getString("RunDirectoryName"), RunProfile.getString("RunDirectoryHint"), true, true);
        }

        public String getValue() {
            return RunProfile.this.getRunDir();
        }

        public void setValue(String string) {
            String string2 = IpeUtils.toAbsoluteOrRelativePath((String)RunProfile.this.getBaseDir(), (String)string);
            string2 = FilePathAdaptor.normalize(string2);
            RunProfile.this.setRunDir(string2);
        }

        public PropertyEditor getPropertyEditor() {
            String string = RunProfile.this.getRunDir();
            if (string.length() == 0) {
                string = ".";
            }
            String string2 = IpeUtils.isPathAbsolute((String)string) ? string : RunProfile.this.getBaseDir() + File.separatorChar + string;
            return new DirEditor(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArgumentsNodeProp
    extends PropertySupport<String> {
        public ArgumentsNodeProp() {
            super("Arguments", String.class, RunProfile.getString("ArgumentsName"), RunProfile.getString("ArgumentsHint"), true, true);
        }

        public String getValue() {
            return RunProfile.this.getArgsFlat();
        }

        public void setValue(String string) {
            RunProfile.this.setArgs(string);
        }
    }
}

