/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.utils.AllSourceFileFilter;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Folder
implements FileChangeListener,
ChangeListener {
    public static final String DEFAULT_FOLDER_NAME = "f";
    public static final String DEFAULT_FOLDER_DISPLAY_NAME = Folder.getString("NewFolderName");
    private MakeConfigurationDescriptor configurationDescriptor;
    private final String name;
    private String displayName;
    private final Folder parent;
    private ArrayList<Object> items = null;
    private final Set<ChangeListener> changeListenerList = new WeakSet(1);
    private final boolean projectFiles;
    private String id = null;
    private String root;
    private static final Logger log = Logger.getLogger("makeproject.folder");
    private static boolean checkedLogging = Folder.checkLogging();

    public Folder(MakeConfigurationDescriptor makeConfigurationDescriptor, Folder folder, String string, String string2, boolean bl) {
        this.configurationDescriptor = makeConfigurationDescriptor;
        this.parent = folder;
        this.name = string;
        this.displayName = string2;
        this.projectFiles = bl;
        this.items = new ArrayList();
    }

    public void setRoot(String string) {
        this.root = string;
    }

    public String getRoot() {
        return this.root;
    }

    public Folder getThis() {
        return this;
    }

    public void refreshDiskFolder() {
        Object object;
        if (log.isLoggable(Level.FINER)) {
            log.finer("----------refreshDiskFolder " + this.getPath());
        }
        String string = this.getRootPath();
        String string2 = IpeUtils.toAbsolutePath((String)this.configurationDescriptor.getBaseDir(), (String)string);
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory() || !VisibilityQuery.getDefault().isVisible(file) || this.getConfigurationDescriptor().getFolderVisibilityQuery().isVisible(file)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("------------removing folder " + this.getPath() + " in " + this.getParent().getPath());
            }
            this.getParent().removeFolder(this);
            return;
        }
        for (Item object22 : this.getItemsAsArray()) {
            object = object22.getFile();
            if (((File)object).exists() && ((File)object).isFile() && VisibilityQuery.getDefault().isVisible((File)object) && CndFileVisibilityQuery.getDefault().isVisible((File)object)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("------------removing item " + object22.getPath() + " in " + this.getPath());
            }
            this.removeItem(object22);
        }
        Object[] objectArray = file.listFiles();
        if (objectArray == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible((File)objectArray[i]) || ((File)objectArray[i]).isFile() && !CndFileVisibilityQuery.getDefault().isVisible((File)objectArray[i]) || ((File)objectArray[i]).isDirectory() && this.getConfigurationDescriptor().getFolderVisibilityQuery().isVisible((File)objectArray[i])) continue;
            arrayList.add(objectArray[i]);
        }
        for (File file2 : arrayList) {
            if (file2.isDirectory()) {
                if (this.findFolderByName(file2.getName()) != null) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("------------adding folder " + file2.getPath() + " in " + this.getPath());
                }
                this.getConfigurationDescriptor().addSourceFilesFromFolder(this, file2, true);
                continue;
            }
            object = this.getRootPath() + '/' + file2.getName();
            if (((String)object).startsWith("./")) {
                object = ((String)object).substring(2);
            }
            if (this.findItemByPath((String)object) != null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("------------adding item " + file2.getPath() + " in " + this.getPath());
            }
            this.addItem(new Item((String)object));
        }
        Vector<Folder> vector = this.getFolders();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (Folder)iterator.next();
            ((Folder)object).refreshDiskFolder();
        }
    }

    public void attachListeners() {
        block7: {
            String string = this.getRootPath();
            String string2 = IpeUtils.toAbsolutePath((String)this.configurationDescriptor.getBaseDir(), (String)string);
            File file = new File(string2);
            if (!file.exists() || !file.isDirectory()) {
                return;
            }
            if (this.isDiskFolder() && this.getRoot() != null) {
                VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
                CndFileVisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
                this.getConfigurationDescriptor().getFolderVisibilityQuery().addChangeListener((ChangeListener)this);
                if (log.isLoggable(Level.FINER)) {
                    log.finer("-----------attachFilterListener " + this.getPath());
                }
            }
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
                if (log.isLoggable(Level.FINER)) {
                    log.finer("-----------attachFileChangeListener " + this.getPath());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!log.isLoggable(Level.FINER)) break block7;
                log.finer("-----------attachFileChangeListener duplicate error" + this.getPath());
            }
        }
        Vector<Folder> vector = this.getFolders();
        for (Folder folder : vector) {
            folder.attachListeners();
        }
    }

    public void detachListener() {
        if (log.isLoggable(Level.FINER)) {
            log.finer("-----------detachFileChangeListener " + this.getPath());
        }
        FileUtil.removeFileChangeListener((FileChangeListener)this);
        if (this.isDiskFolder() && this.getRoot() != null) {
            VisibilityQuery.getDefault().removeChangeListener((ChangeListener)this);
            CndFileVisibilityQuery.getDefault().removeChangeListener((ChangeListener)this);
            this.getConfigurationDescriptor().getFolderVisibilityQuery().removeChangeListener((ChangeListener)this);
            if (log.isLoggable(Level.FINER)) {
                log.finer("-----------detachFilterListener " + this.getPath());
            }
        }
    }

    public int size() {
        return this.items.size();
    }

    public Folder getParent() {
        return this.parent;
    }

    public Project getProject() {
        return this.getConfigurationDescriptor().getProject();
    }

    public String getName() {
        return this.name;
    }

    public String getSortName() {
        return this.displayName;
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.reversePath(this, stringBuilder, false);
        return stringBuilder.toString();
    }

    public String getRootPath() {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.reversePath(this, stringBuilder, true);
        String string = stringBuilder.toString();
        return string;
    }

    private void reversePath(Folder folder, StringBuilder stringBuilder, boolean bl) {
        Folder folder2 = folder.getParent();
        if (folder2 != null && folder2.getParent() != null) {
            this.reversePath(folder2, stringBuilder, bl);
            stringBuilder.append('/');
        }
        if (bl && folder.getRoot() != null) {
            stringBuilder.append(folder.getRoot());
        } else {
            stringBuilder.append(folder.getName());
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
        this.configurationDescriptor.setModified();
        this.getParent().reInsertElement(this);
    }

    public MakeConfigurationDescriptor getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    public void setConfigurationDescriptor(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.configurationDescriptor = makeConfigurationDescriptor;
    }

    public boolean isProjectFiles() {
        return this.projectFiles;
    }

    public boolean isDiskFolder() {
        Folder folder = this;
        do {
            if (folder.getRoot() == null) continue;
            return true;
        } while ((folder = folder.getParent()) != null);
        return false;
    }

    public ArrayList<Object> getElements() {
        return this.items;
    }

    public void reInsertElement(Object object) {
        int n = this.items.indexOf(object);
        if (n < 0) {
            return;
        }
        this.items.remove(object);
        if (object instanceof Folder) {
            this.insertFolderElement((Folder)object);
        } else if (object instanceof Item) {
            this.insertItemElement((Item)object);
        } else assert (false);
        this.fireChangeEvent();
    }

    private void insertFolderElement(Folder folder) {
        if (!folder.isProjectFiles()) {
            this.items.add(folder);
            return;
        }
        String string = folder.getSortName();
        int n = this.items.size() - 1;
        while (n >= 0) {
            Object object = this.items.get(n);
            if (!(object instanceof Folder)) {
                --n;
                continue;
            }
            if (!((Folder)object).isProjectFiles()) {
                --n;
                continue;
            }
            String string2 = ((Folder)object).getSortName();
            int n2 = string.compareToIgnoreCase(string2);
            if (n2 >= 0) break;
            --n;
        }
        this.items.add(n + 1, folder);
    }

    public static void insertItemElementInList(ArrayList<Object> arrayList, Item item) {
        String string;
        int n;
        Object object;
        int n2;
        String string2 = item.getSortName();
        for (n2 = arrayList.size() - 1; n2 >= 0 && (object = arrayList.get(n2)) instanceof Item && (n = string2.compareTo(string = ((Item)object).getSortName())) < 0; --n2) {
        }
        arrayList.add(n2 + 1, item);
    }

    private void insertItemElement(Item item) {
        Folder.insertItemElementInList(this.items, item);
    }

    public void addElement(Object object) {
        int n = -1;
        if (object instanceof Item) {
            this.insertItemElement((Item)object);
        } else if (object instanceof Folder) {
            this.insertFolderElement((Folder)object);
        } else assert (false);
        this.fireChangeEvent();
    }

    public Item addItemAction(Item item) {
        if (this.addItem(item) == null) {
            return null;
        }
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>(1);
        arrayList.add(item);
        this.configurationDescriptor.fireFilesAdded(arrayList);
        return item;
    }

    public Item addItem(Item item) {
        return this.addItem(item, true);
    }

    public Item addItem(Item item, boolean bl) {
        Configuration[] configurationArray;
        Item item2;
        if (item == null) {
            return null;
        }
        if (this.isProjectFiles() && (item2 = this.configurationDescriptor.findProjectItemByPath(item.getPath())) != null) {
            this.refresh(item2);
            return null;
        }
        item.setFolder(this);
        this.addElement(item);
        if (this.isProjectFiles() && bl) {
            NativeFileItemSet nativeFileItemSet;
            configurationArray = item.getDataObject();
            NativeFileItemSet nativeFileItemSet2 = nativeFileItemSet = configurationArray == null ? null : (NativeFileItemSet)configurationArray.getCookie(NativeFileItemSet.class);
            if (nativeFileItemSet != null) {
                nativeFileItemSet.add((NativeFileItem)item);
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("can not add folder's " + this + " item " + item + " using " + configurationArray);
            }
        }
        if (this.isProjectFiles()) {
            this.configurationDescriptor.addProjectItem(item);
            if (this.configurationDescriptor.getConfs() == null) {
                return item;
            }
            configurationArray = this.configurationDescriptor.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                FolderConfiguration folderConfiguration = this.getFolderConfiguration(configurationArray[i]);
                configurationArray[i].addAuxObject(new ItemConfiguration(configurationArray[i], item));
            }
        }
        return item;
    }

    public void addFolder(Folder folder) {
        this.addElement(folder);
        if (this.isProjectFiles()) {
            if (this.configurationDescriptor.getConfs() == null) {
                return;
            }
            Configuration[] configurationArray = this.configurationDescriptor.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                folder.getFolderConfiguration(configurationArray[i]);
            }
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = "f-" + this.getPath();
        }
        return this.id;
    }

    public FolderConfiguration getFolderConfiguration(Configuration configuration) {
        FolderConfiguration folderConfiguration = null;
        if (this.isProjectFiles() && (folderConfiguration = (FolderConfiguration)configuration.getAuxObject(this.getId())) == null) {
            CCCompilerConfiguration cCCompilerConfiguration;
            CCompilerConfiguration cCompilerConfiguration;
            FolderConfiguration folderConfiguration2 = null;
            if (this.getParent() != null) {
                folderConfiguration2 = this.getParent().getFolderConfiguration(configuration);
            }
            if (folderConfiguration2 != null) {
                cCompilerConfiguration = folderConfiguration2.getCCompilerConfiguration();
                cCCompilerConfiguration = folderConfiguration2.getCCCompilerConfiguration();
            } else {
                cCompilerConfiguration = ((MakeConfiguration)configuration).getCCompilerConfiguration();
                cCCompilerConfiguration = ((MakeConfiguration)configuration).getCCCompilerConfiguration();
            }
            folderConfiguration = new FolderConfiguration(configuration, cCompilerConfiguration, cCCompilerConfiguration, this);
            configuration.addAuxObject(folderConfiguration);
        }
        return folderConfiguration;
    }

    public Folder addNewFolder(boolean bl) {
        String string;
        String string2;
        int n = 1;
        while (true) {
            string2 = DEFAULT_FOLDER_NAME + n;
            string = DEFAULT_FOLDER_DISPLAY_NAME + " " + n;
            if (this.findFolderByName(string2) == null) break;
            ++n;
        }
        return this.addNewFolder(string2, string, bl);
    }

    public Folder addNewFolder(String string, String string2, boolean bl) {
        Folder folder = new Folder(this.getConfigurationDescriptor(), this, string, string2, bl);
        this.addFolder(folder);
        return folder;
    }

    public boolean removeItemAction(Item item) {
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>(1);
        arrayList.add(item);
        if (this.isProjectFiles()) {
            this.configurationDescriptor.fireFilesRemoved(arrayList);
        }
        return this.removeItem(item);
    }

    public void renameItemAction(String string, Item item) {
        this.configurationDescriptor.fireFileRenamed(string, item);
    }

    public boolean removeItem(Item item) {
        NativeFileItemSet nativeFileItemSet;
        Configuration[] configurationArray;
        boolean bl = false;
        if (item == null) {
            return false;
        }
        bl = this.items.remove(item);
        if (!bl) {
            return bl;
        }
        if (this.isProjectFiles() && (configurationArray = item.getDataObject()) != null && (nativeFileItemSet = (NativeFileItemSet)configurationArray.getCookie(NativeFileItemSet.class)) != null) {
            nativeFileItemSet.remove((NativeFileItem)item);
        }
        if (this.isProjectFiles()) {
            this.configurationDescriptor.removeProjectItem(item);
            configurationArray = this.configurationDescriptor.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                configurationArray[i].removeAuxObject(item.getId());
            }
        }
        item.setFolder(null);
        this.fireChangeEvent();
        return bl;
    }

    public boolean removeItemByPath(String string) {
        boolean bl = false;
        Item item = this.findItemByPath(string);
        return this.removeItem(item);
    }

    public boolean removeFolderAction(Folder folder) {
        this.configurationDescriptor.fireFilesRemoved(folder.getAllItemsAsList());
        return this.removeFolder(folder);
    }

    public boolean removeFolder(Folder folder) {
        boolean bl = false;
        if (folder != null) {
            if (folder.isDiskFolder()) {
                folder.detachListener();
            }
            folder.removeAll();
            bl = this.items.remove(folder);
            if (this.isProjectFiles()) {
                Configuration[] configurationArray = this.configurationDescriptor.getConfs().getConfs();
                for (int i = 0; i < configurationArray.length; ++i) {
                    configurationArray[i].removeAuxObject(folder.getId());
                }
            }
        }
        if (bl) {
            this.fireChangeEvent();
        }
        return bl;
    }

    public void removeAll() {
        int n;
        Item[] itemArray = this.getItemsAsArray();
        Folder[] folderArray = this.getFoldersAsArray();
        for (n = 0; n < itemArray.length; ++n) {
            this.removeItem(itemArray[n]);
        }
        for (n = 0; n < folderArray.length; ++n) {
            this.removeFolder(folderArray[n]);
        }
    }

    public void reset() {
        this.items = new ArrayList();
        this.fireChangeEvent();
    }

    public Item findItemByPath(String string) {
        if (string == null) {
            return null;
        }
        Item[] itemArray = this.getItemsAsArray();
        for (int i = 0; i < itemArray.length; ++i) {
            if (!string.equals(itemArray[i].getPath())) continue;
            return itemArray[i];
        }
        return null;
    }

    public Item findItemByName(String string) {
        if (string == null) {
            return null;
        }
        Item[] itemArray = this.getItemsAsArray();
        for (int i = 0; i < itemArray.length; ++i) {
            if (!string.equals(itemArray[i].getName())) continue;
            return itemArray[i];
        }
        return null;
    }

    public Folder findFolderByName(String string) {
        if (string == null) {
            return null;
        }
        Folder[] folderArray = this.getFoldersAsArray();
        for (int i = 0; i < folderArray.length; ++i) {
            if (!string.equals(folderArray[i].getName())) continue;
            return folderArray[i];
        }
        return null;
    }

    public Folder findFolderByDisplayName(String string) {
        if (string == null) {
            return null;
        }
        Folder[] folderArray = this.getFoldersAsArray();
        for (int i = 0; i < folderArray.length; ++i) {
            if (!string.equals(folderArray[i].getDisplayName())) continue;
            return folderArray[i];
        }
        return null;
    }

    public Folder findFolderByPath(String string) {
        int n = string.indexOf(47);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            Folder folder = this.findFolderByName(string2);
            if (folder == null) {
                return null;
            }
            return folder.findFolderByPath(string.substring(n + 1));
        }
        return this.findFolderByName(string);
    }

    public Item[] getItemsAsArray() {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (Object object : new ArrayList<Object>(this.getElements())) {
            if (!(object instanceof Item)) continue;
            arrayList.add((Item)object);
        }
        return arrayList.toArray(new Item[arrayList.size()]);
    }

    public List<NativeFileItem> getAllItemsAsList() {
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        for (Object object : new ArrayList<Object>(this.getElements())) {
            if (object instanceof Item) {
                arrayList.add((Item)object);
            }
            if (!(object instanceof Folder)) continue;
            List<NativeFileItem> list = ((Folder)object).getAllItemsAsList();
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public Item[] getAllItemsAsArray() {
        List<NativeFileItem> list = this.getAllItemsAsList();
        return list.toArray(new Item[list.size()]);
    }

    public Set<FileObject> getItemsAsFileObjectSet() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Item item : new ArrayList<Object>(this.getElements())) {
            FileObject fileObject = item.getFileObject();
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return new LinkedHashSet<FileObject>(arrayList);
    }

    public Set<FileObject> getAllItemsAsFileObjectSet(boolean bl) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (!bl || this.isProjectFiles()) {
            for (Object object : new ArrayList<Object>(this.getElements())) {
                FileObject fileObject;
                if (object instanceof Item && (fileObject = ((Item)object).getFileObject()) != null) {
                    arrayList.add(fileObject);
                }
                if (!(object instanceof Folder)) continue;
                arrayList.addAll(((Folder)object).getAllItemsAsFileObjectSet(bl));
            }
        }
        return new LinkedHashSet<FileObject>(arrayList);
    }

    public Set<DataObject> getItemsAsDataObjectSet(String string) {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        for (Item item : new ArrayList<Object>(this.getElements())) {
            DataObject dataObject = item.getDataObject();
            if (dataObject == null || string != null && !dataObject.getPrimaryFile().getMIMEType().contains(string)) continue;
            arrayList.add(dataObject);
        }
        return new LinkedHashSet<DataObject>(arrayList);
    }

    public Set<DataObject> getAllItemsAsDataObjectSet(boolean bl, String string) {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        if (!bl || this.isProjectFiles()) {
            for (Object object : new ArrayList<Object>(this.getElements())) {
                DataObject dataObject;
                if (object instanceof Item && (dataObject = ((Item)object).getDataObject()) != null && (string == null || dataObject.getPrimaryFile().getMIMEType().contains(string))) {
                    arrayList.add(dataObject);
                }
                if (!(object instanceof Folder)) continue;
                arrayList.addAll(((Folder)object).getAllItemsAsDataObjectSet(bl, string));
            }
        }
        return new LinkedHashSet<DataObject>(arrayList);
    }

    public Folder[] getFoldersAsArray() {
        Vector<Folder> vector = this.getFolders();
        return vector.toArray(new Folder[vector.size()]);
    }

    public Vector<Folder> getFolders() {
        Vector<Folder> vector = new Vector<Folder>();
        for (Object object : new ArrayList<Object>(this.getElements())) {
            if (!(object instanceof Folder)) continue;
            vector.add((Folder)object);
        }
        return vector;
    }

    public Vector<Folder> getAllFolders(boolean bl) {
        Vector<Folder> vector = new Vector<Folder>();
        if (!bl || this.isProjectFiles()) {
            for (Object object : new ArrayList<Object>(this.getElements())) {
                if (!(object instanceof Folder) || bl && !((Folder)object).isProjectFiles()) continue;
                vector.add((Folder)object);
                vector.addAll(((Folder)object).getAllFolders(bl));
            }
        }
        return vector;
    }

    public String[] getFolderNamesAsArray() {
        Folder[] folderArray = this.getFoldersAsArray();
        String[] stringArray = new String[folderArray.length];
        for (int i = 0; i < folderArray.length; ++i) {
            stringArray[i] = folderArray[i].getName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.remove(changeListener);
        }
    }

    public void refresh() {
        this.fireChangeEvent(this);
    }

    public void refresh(Object object) {
        this.fireChangeEvent(object);
    }

    public void fireChangeEvent() {
        this.fireChangeEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeEvent(Object object) {
        Iterator<ChangeListener> iterator;
        Object object2 = this.changeListenerList;
        synchronized (object2) {
            iterator = new HashSet<ChangeListener>(this.changeListenerList).iterator();
        }
        object2 = new ChangeEvent(object);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object2);
        }
        this.configurationDescriptor.setModified();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.fine("------------stateChanged " + this.getThis().getPath());
        }
        if (this.isDiskFolder()) {
            this.refreshDiskFolder();
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        boolean bl = this.getConfigurationDescriptor().getModified();
        FileObject fileObject = fileEvent.getFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (log.isLoggable(Level.FINE)) {
            log.fine("------------fileDataCreated " + file + " in " + this.getThis().getPath());
        }
        if (!file.exists() || file.isDirectory()) {
            return;
        }
        if (!AllSourceFileFilter.getInstance().accept(file)) {
            return;
        }
        String string = file.getPath();
        string = IpeUtils.toRelativePath((String)this.getConfigurationDescriptor().getBaseDir(), (String)string);
        string = FilePathAdaptor.normalize(string);
        Item item = new Item(string);
        this.addItemAction(item);
        this.getConfigurationDescriptor().setModified(bl);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        boolean bl = this.getConfigurationDescriptor().getModified();
        FileObject fileObject = fileEvent.getFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (log.isLoggable(Level.FINE)) {
            log.fine("------------fileFolderCreated " + file.getPath() + " in " + this.getThis().getPath());
        }
        if (!file.exists() || !file.isDirectory()) {
            assert (false);
            return;
        }
        Folder folder = this.getConfigurationDescriptor().addSourceFilesFromFolder(this.getThis(), file, true);
        this.getConfigurationDescriptor().setModified(bl);
    }

    public void fileDeleted(FileEvent fileEvent) {
        Item item;
        String string;
        boolean bl = this.getConfigurationDescriptor().getModified();
        FileObject fileObject = fileEvent.getFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (log.isLoggable(Level.FINE)) {
            log.fine("------------fileDeleted " + file.getPath() + " in " + this.getThis().getPath());
        }
        if ((string = this.getRootPath() + '/' + file.getName()).startsWith("./")) {
            string = string.substring(2);
        }
        if ((item = this.findItemByPath(string)) != null) {
            this.removeItemAction(item);
            this.getConfigurationDescriptor().setModified(bl);
            return;
        }
        Folder folder = this.findFolderByName(file.getName());
        if (folder != null) {
            this.removeFolderAction(folder);
            this.getConfigurationDescriptor().setModified(bl);
            return;
        }
    }

    public void copyConfigurations(Folder folder) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        for (Configuration configuration : makeConfigurationDescriptor.getConfs().getConfs()) {
            FolderConfiguration folderConfiguration = folder.getFolderConfiguration(configuration);
            FolderConfiguration folderConfiguration2 = this.getFolderConfiguration(configuration);
            if (folderConfiguration == null || folderConfiguration2 == null) continue;
            folderConfiguration2.assignValues(folderConfiguration);
        }
    }

    private static void copyConfigurations(Folder folder, Folder folder2) {
        folder2.copyConfigurations(folder);
        Item[] itemArray = folder.getItemsAsArray();
        EventListener[] eventListenerArray = itemArray;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            Item item = eventListenerArray[i];
            EventListener eventListener = folder2.findItemByName(item.getName());
            if (eventListener == null) continue;
            ((Item)eventListener).copyConfigurations(item);
        }
        for (EventListener eventListener : eventListenerArray = folder.getFoldersAsArray()) {
            Folder folder3 = folder2.findFolderByName(((Folder)eventListener).getName());
            if (folder3 == null) continue;
            folder3.copyConfigurations((Folder)eventListener);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        Folder folder;
        boolean bl = this.getConfigurationDescriptor().getModified();
        FileObject fileObject = fileRenameEvent.getFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (log.isLoggable(Level.FINE)) {
            log.fine("------------fileRenamed " + file.getPath() + " in " + this.getThis().getPath());
        }
        if ((folder = this.findFolderByName(fileRenameEvent.getName())) != null && folder.isDiskFolder()) {
            Folder folder2 = this.getConfigurationDescriptor().addSourceFilesFromFolder(this.getThis(), file, true);
            Folder.copyConfigurations(folder, folder2);
            this.removeFolderAction(folder);
            this.getConfigurationDescriptor().setModified(bl);
            return;
        }
    }

    private static boolean checkLogging() {
        if (checkedLogging) {
            return true;
        }
        String string = System.getProperty("makeproject.folder");
        if (string != null) {
            if (string.equals("FINE")) {
                log.setLevel(Level.FINE);
            } else if (string.equals("FINER")) {
                log.setLevel(Level.FINER);
            } else if (string.equals("FINEST")) {
                log.setLevel(Level.FINEST);
            }
        }
        return true;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(Folder.class, (String)string);
    }

    public String toString() {
        return this.name;
    }
}

