/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.TableColumnSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETableColumnModel
extends DefaultTableColumnModel {
    private static final String NUMBER_OF_COLUMNS = "ColumnsNumber";
    private static final String NUMBER_OF_HIDDEN_COLUMNS = "HiddenColumnsNumber";
    private static final String PROP_HIDDEN_PREFIX = "Hidden";
    protected transient List<TableColumn> sortedColumns = new ArrayList<TableColumn>();
    protected List<TableColumn> hiddenColumns = new ArrayList<TableColumn>();
    private TableColumnSelector.TreeNode columnHierarchyRoot;

    public void readSettings(Properties properties, String string, ETable eTable) {
        ETableColumn eTableColumn;
        int n;
        this.tableColumns = new Vector();
        this.sortedColumns = new ArrayList<TableColumn>();
        String string2 = properties.getProperty(string + NUMBER_OF_COLUMNS);
        int n2 = Integer.parseInt(string2);
        for (int i = 0; i < n2; ++i) {
            ETableColumn eTableColumn2 = (ETableColumn)eTable.createColumn(i);
            eTableColumn2.readSettings(properties, i, string);
            this.addColumn(eTableColumn2);
            if (eTableColumn2.getComparator() == null) continue;
            for (n = 0; n < this.sortedColumns.size() && (eTableColumn = (ETableColumn)this.sortedColumns.get(n)).getSortRank() <= eTableColumn2.getSortRank(); ++n) {
            }
            this.sortedColumns.add(n, eTableColumn2);
        }
        this.hiddenColumns = new ArrayList<TableColumn>();
        String string3 = properties.getProperty(string + NUMBER_OF_HIDDEN_COLUMNS);
        int n3 = Integer.parseInt(string3);
        for (n = 0; n < n3; ++n) {
            eTableColumn = new ETableColumn(eTable);
            eTableColumn.readSettings(properties, n, string + PROP_HIDDEN_PREFIX);
            this.hiddenColumns.add(eTableColumn);
        }
    }

    public void writeSettings(Properties properties, String string) {
        int n = 0;
        int n2 = this.tableColumns.size();
        properties.setProperty(string + NUMBER_OF_COLUMNS, Integer.toString(n2));
        for (Object object : this.tableColumns) {
            if (!(object instanceof ETableColumn)) continue;
            ETableColumn eTableColumn = (ETableColumn)object;
            eTableColumn.writeSettings(properties, n++, string);
        }
        n = 0;
        int n3 = this.hiddenColumns.size();
        properties.setProperty(string + NUMBER_OF_HIDDEN_COLUMNS, Integer.toString(n3));
        for (Object e : this.hiddenColumns) {
            if (!(e instanceof ETableColumn)) continue;
            ETableColumn eTableColumn = (ETableColumn)e;
            eTableColumn.writeSettings(properties, n++, string + PROP_HIDDEN_PREFIX);
        }
    }

    public Comparator<ETable.RowMapping> getComparator() {
        if (this.sortedColumns.isEmpty()) {
            return new ETable.OriginalRowComparator();
        }
        return new CompoundComparator();
    }

    public void setColumnSorted(ETableColumn eTableColumn, boolean bl, int n) {
        if (!eTableColumn.isSortingAllowed()) {
            return;
        }
        boolean bl2 = this.sortedColumns.contains(eTableColumn);
        if (bl2) {
            eTableColumn.setAscending(bl);
            eTableColumn.setSortRank(n);
            this.sortedColumns.remove(eTableColumn);
        } else {
            eTableColumn.setSorted(n, bl);
        }
        this.sortedColumns.add(n - 1, eTableColumn);
    }

    void toggleSortedColumn(ETableColumn eTableColumn, boolean bl) {
        if (!eTableColumn.isSortingAllowed()) {
            return;
        }
        boolean bl2 = this.sortedColumns.contains(eTableColumn);
        if (bl) {
            this.clearSortedColumns(eTableColumn);
        }
        if (bl2) {
            if (eTableColumn.isAscending()) {
                eTableColumn.setAscending(false);
            } else {
                this.sortedColumns.remove(eTableColumn);
                eTableColumn.setSorted(0, false);
            }
            this.updateRanks();
        } else {
            eTableColumn.setSorted(this.sortedColumns.size() + 1, true);
            this.sortedColumns.add(eTableColumn);
        }
    }

    public void setColumnHidden(TableColumn tableColumn, boolean bl) {
        if (bl) {
            if (!this.hiddenColumns.contains(tableColumn) && this.tableColumns.contains(tableColumn)) {
                this.removeColumn(tableColumn);
                this.hiddenColumns.add(tableColumn);
            }
        } else if (!this.tableColumns.contains(tableColumn) && this.hiddenColumns.contains(tableColumn)) {
            this.hiddenColumns.remove(tableColumn);
            this.addColumn(tableColumn);
        }
    }

    public boolean isColumnHidden(TableColumn tableColumn) {
        return this.hiddenColumns.contains(tableColumn);
    }

    public void clearSortedColumns() {
        for (TableColumn tableColumn : this.sortedColumns) {
            if (!(tableColumn instanceof ETableColumn)) continue;
            ETableColumn eTableColumn = (ETableColumn)tableColumn;
            eTableColumn.setSorted(0, false);
        }
        this.sortedColumns = new ArrayList<TableColumn>();
    }

    void clearSortedColumns(TableColumn tableColumn) {
        boolean bl = this.sortedColumns.contains(tableColumn);
        for (TableColumn tableColumn2 : this.sortedColumns) {
            if (!(tableColumn2 instanceof ETableColumn) || tableColumn2 == tableColumn) continue;
            ETableColumn eTableColumn = (ETableColumn)tableColumn2;
            eTableColumn.setSorted(0, false);
        }
        this.sortedColumns = new ArrayList<TableColumn>();
        if (bl) {
            this.sortedColumns.add(tableColumn);
        }
    }

    private void updateRanks() {
        int n = 1;
        for (TableColumn tableColumn : this.sortedColumns) {
            ETableColumn eTableColumn;
            if (tableColumn instanceof ETableColumn && (eTableColumn = (ETableColumn)tableColumn).isSorted()) {
                eTableColumn.setSortRank(n);
            }
            ++n;
        }
    }

    List<TableColumn> getSortedColumns() {
        return this.sortedColumns;
    }

    public TableColumnSelector.TreeNode getColumnHierarchyRoot() {
        return this.columnHierarchyRoot;
    }

    public void setColumnHierarchyRoot(TableColumnSelector.TreeNode treeNode) {
        this.columnHierarchyRoot = treeNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompoundComparator
    implements Comparator<ETable.RowMapping> {
        private Comparator<ETable.RowMapping> original = new ETable.OriginalRowComparator();

        @Override
        public int compare(ETable.RowMapping rowMapping, ETable.RowMapping rowMapping2) {
            for (TableColumn tableColumn : ETableColumnModel.this.sortedColumns) {
                int n;
                ETableColumn eTableColumn;
                Comparator<ETable.RowMapping> comparator;
                if (!(tableColumn instanceof ETableColumn) || (comparator = (eTableColumn = (ETableColumn)tableColumn).getComparator()) == null || (n = comparator.compare(rowMapping, rowMapping2)) == 0) continue;
                return n;
            }
            return this.original.compare(rowMapping, rowMapping2);
        }
    }
}

