/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.openide.util.Mutex;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SequentialPropertyEvaluator
implements PropertyEvaluator,
ChangeListener {
    private final PropertyProvider preprovider;
    private final PropertyProvider[] providers;
    private Map<String, String> predefs;
    private List<Map<String, String>> orderedDefs;
    private Map<String, String> defs;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final float COMPACT_LOAD_FACTOR = 0.95f;

    public SequentialPropertyEvaluator(final PropertyProvider propertyProvider, final PropertyProvider ... propertyProviderArray) {
        this.preprovider = propertyProvider;
        this.providers = propertyProviderArray;
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                if (propertyProvider != null) {
                    SequentialPropertyEvaluator.this.predefs = SequentialPropertyEvaluator.copyAndCompact(propertyProvider.getProperties());
                    propertyProvider.addChangeListener(WeakListeners.change((ChangeListener)SequentialPropertyEvaluator.this, (Object)propertyProvider));
                } else {
                    SequentialPropertyEvaluator.this.predefs = Collections.emptyMap();
                }
                SequentialPropertyEvaluator.this.orderedDefs = new ArrayList(propertyProviderArray.length);
                for (PropertyProvider propertyProvider2 : propertyProviderArray) {
                    SequentialPropertyEvaluator.this.orderedDefs.add(SequentialPropertyEvaluator.copyAndCompact(propertyProvider2.getProperties()));
                    propertyProvider2.addChangeListener(WeakListeners.change((ChangeListener)SequentialPropertyEvaluator.this, (Object)propertyProvider2));
                }
                return null;
            }
        });
        this.defs = SequentialPropertyEvaluator.evaluateAll(this.predefs, this.orderedDefs);
    }

    @Override
    public String getProperty(final String string) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                if (SequentialPropertyEvaluator.this.defs == null) {
                    return null;
                }
                return (String)SequentialPropertyEvaluator.this.defs.get(string);
            }
        });
    }

    @Override
    public String evaluate(final String string) {
        if (string == null) {
            throw new NullPointerException("Attempted to pass null to PropertyEvaluator.evaluate");
        }
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                if (SequentialPropertyEvaluator.this.defs == null) {
                    return null;
                }
                Union2 union2 = SequentialPropertyEvaluator.substitute(string, SequentialPropertyEvaluator.this.defs, Collections.emptySet());
                assert (union2.hasFirst()) : "Unexpected result " + union2 + " from " + string + " on " + SequentialPropertyEvaluator.access$300(SequentialPropertyEvaluator.this);
                return (String)union2.first();
            }
        });
    }

    @Override
    public Map<String, String> getProperties() {
        return (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<String, String>>(){

            public Map<String, String> run() {
                return SequentialPropertyEvaluator.this.defs;
            }
        });
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Map<String, String> map;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        PropertyProvider propertyProvider = (PropertyProvider)changeEvent.getSource();
        Map<String, String> map2 = SequentialPropertyEvaluator.copyAndCompact(propertyProvider.getProperties());
        if (propertyProvider == this.preprovider) {
            if (((Object)this.predefs).equals(map2)) {
                return;
            }
            this.predefs = map2;
        } else {
            int n = Arrays.asList(this.providers).indexOf(propertyProvider);
            if (n == -1) {
                assert (false) : "got change from unexpected source: " + propertyProvider;
                return;
            }
            if (((Object)this.orderedDefs.get(n)).equals(map2)) {
                return;
            }
            this.orderedDefs.set(n, map2);
        }
        Map<String, String> map3 = SequentialPropertyEvaluator.evaluateAll(this.predefs, this.orderedDefs);
        Map<Object, Object> map4 = this.defs != null ? this.defs : Collections.emptyMap();
        Map<String, String> map5 = map = map3 != null ? map3 : Collections.emptyMap();
        if (!((Object)map4).equals(map)) {
            HashSet<Object> hashSet = new HashSet<Object>(map4.keySet());
            hashSet.addAll(map.keySet());
            LinkedList<PropertyChangeEvent> linkedList = new LinkedList<PropertyChangeEvent>();
            for (String object : hashSet) {
                assert (object != null);
                String string = (String)map4.get(object);
                String string2 = map.get(object);
                if (string2 != null) {
                    if (string2.equals(string)) {
                        continue;
                    }
                } else assert (string != null) : "should not have had " + object;
                linkedList.add(new PropertyChangeEvent(this, object, string, string2));
            }
            assert (!linkedList.isEmpty());
            this.defs = map3;
            for (PropertyChangeEvent propertyChangeEvent : linkedList) {
                this.pcs.firePropertyChange(propertyChangeEvent);
            }
        }
    }

    private static Union2<String, Set<String>> substitute(String string, Map<String, String> map, Set<String> set) {
        assert (string != null) : "null rawval passed in";
        if (string.indexOf(36) == -1) {
            return Union2.createFirst((Object)string);
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            int n2;
            if ((n2 = string.indexOf(36, n)) == -1 || n2 == string.length() - 1) {
                if (hashSet.isEmpty()) {
                    stringBuilder.append(string.substring(n));
                    return Union2.createFirst((Object)stringBuilder.toString());
                }
                return Union2.createSecond(hashSet);
            }
            char c = string.charAt(n2 + 1);
            if (c == '$') {
                if (hashSet.isEmpty()) {
                    stringBuilder.append('$');
                }
                n += 2;
                continue;
            }
            if (c == '{') {
                int n3 = string.indexOf(125, n2 + 2);
                if (n3 != -1) {
                    String string2 = string.substring(n2 + 2, n3);
                    if (map.containsKey(string2)) {
                        if (hashSet.isEmpty()) {
                            stringBuilder.append(string.substring(n, n2));
                            stringBuilder.append(map.get(string2));
                        }
                        n = n3 + 1;
                        continue;
                    }
                    if (set.contains(string2)) {
                        hashSet.add(string2);
                        n = n3 + 1;
                        continue;
                    }
                    if (hashSet.isEmpty()) {
                        stringBuilder.append(string.substring(n, n3 + 1));
                    }
                    n = n3 + 1;
                    continue;
                }
                if (hashSet.isEmpty()) {
                    stringBuilder.append(string.substring(n));
                    return Union2.createFirst((Object)stringBuilder.toString());
                }
                return Union2.createSecond(hashSet);
            }
            if (hashSet.isEmpty()) {
                stringBuilder.append(string.substring(n, n + 2));
            }
            n += 2;
        }
    }

    private static Map<String, String> evaluateAll(Map<String, String> map, List<Map<String, String>> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        for (Map<String, String> map2 : list) {
            Object object;
            String string;
            Object object22;
            Map.Entry<String, String> entry2;
            HashMap hashMap2 = new HashMap();
            for (Map.Entry<String, String> entry2 : map2.entrySet()) {
                object22 = entry2.getKey();
                if (hashMap.containsKey(object22)) continue;
                string = (String)entry2.getValue();
                object = SequentialPropertyEvaluator.substitute(string, hashMap, map2.keySet());
                if (object.hasFirst()) {
                    hashMap.put((String)object22, (String)object.first());
                    continue;
                }
                hashMap2.put(object22, object.second());
            }
            HashSet hashSet = new HashSet(hashMap2.keySet());
            for (Object object22 : hashMap2.values()) {
                hashSet.addAll(object22);
            }
            try {
                entry2 = Utilities.topologicalSort((Collection)hashSet, hashMap2);
            }
            catch (TopologicalSortException topologicalSortException) {
                return null;
            }
            Collections.reverse(entry2);
            object22 = entry2.iterator();
            while (object22.hasNext()) {
                string = (String)object22.next();
                if (hashMap.containsKey(string)) continue;
                object = map2.get(string);
                hashMap.put(string, (String)SequentialPropertyEvaluator.substitute(object, hashMap, map2.keySet()).first());
            }
        }
        return SequentialPropertyEvaluator.copyAndCompact(hashMap);
    }

    private static <K, V> Map<K, V> copyAndCompact(Map<K, V> map) {
        HashMap<K, V> hashMap = new HashMap<K, V>((int)((float)map.size() / 0.95f) + 1, 0.95f);
        hashMap.putAll(map);
        return hashMap;
    }
}

