/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.glassfish.eecommon.api.RegisterDatabase;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunURIManager;
import org.netbeans.modules.j2ee.sun.ide.editors.AdminAuthenticator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.PlatformValidator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.RunTimeDDCatalog;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Utils;
import org.netbeans.modules.j2ee.sun.ide.j2ee.db.ExecSupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainDirectoryPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainHostPortPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainNamePasswordPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainPlatformPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainPortsDefPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Profile;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class AddDomainWizardIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private int index;
    private WizardDescriptor.Panel[] panels = null;
    static final String USER_NAME = "username";
    static final String PASSWORD = "password";
    static final String BLANK = "";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String CREATE_LOCALLY = "create_locally";
    static final String DOMAIN_FILE = "domain_file";
    static final String PLATFORM_LOCATION = "platform_location";
    static final String INSTALL_LOCATION = "install_location";
    static final String DOMAIN = "domain";
    static final String PROFILE = "profile";
    static final String INSTANCE_PORT = "instance_port";
    static final String JMS_PORT = "jms_port";
    static final String ORB_LISTENER_PORT = "orb_listener_port";
    static final String ORB_SSL_PORT = "orb_ssl_port";
    static final String HTTP_SSL_PORT = "http_ssl_port";
    static final String ORB_MUTUAL_AUTH_PORT = "orb_mutual_auth_port";
    static final String ADMIN_JMX_PORT = "admin_jmx_port";
    static final String SIP_PORT = "sip_port";
    static final String SIP_SSL_PORT = "sip_ssl_port";
    static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    static final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    static final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    static final String TYPE = "type";
    static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    private final AddDomainHostPortPanel hppanel = new AddDomainHostPortPanel();
    private final AddDomainDirectoryPanel domainDirPanel = new AddDomainDirectoryPanel(false);
    private final AddDomainDirectoryPanel personalDirPanel = new AddDomainDirectoryPanel(true);
    final AddDomainPlatformPanel platformPanel = new AddDomainPlatformPanel();
    private final AddDomainNamePasswordPanel unamePanel = new AddDomainNamePasswordPanel();
    private final AddDomainPortsDefPanel portsPanel = new AddDomainPortsDefPanel();
    private final WizardDescriptor.Panel[] defaultFlow = new WizardDescriptor.Panel[]{this.platformPanel, this.unamePanel};
    private final WizardDescriptor.Panel[] remoteFlow = new WizardDescriptor.Panel[]{this.platformPanel, this.hppanel, this.unamePanel};
    private final WizardDescriptor.Panel[] localFlow = new WizardDescriptor.Panel[]{this.platformPanel, this.domainDirPanel, this.unamePanel};
    private final WizardDescriptor.Panel[] personalFlow = new WizardDescriptor.Panel[]{this.platformPanel, this.personalDirPanel, this.unamePanel, this.portsPanel};
    private Set listeners = new HashSet(1);
    private WizardDescriptor wizard;
    static InstanceType PERSONAL = new InstanceType();
    static InstanceType REMOTE = new InstanceType();
    static InstanceType LOCAL = new InstanceType();
    static InstanceType DEFAULT = new InstanceType();

    public AddDomainWizardIterator(PlatformValidator platformValidator) {
        this.platformPanel.setPlatformValidator(platformValidator);
    }

    public AddDomainWizardIterator(PlatformValidator platformValidator, String string) {
        this.platformPanel.setPlatformValidator(platformValidator, string);
        this.portsPanel.setPlatformValidator(platformValidator, string);
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.decoratePanels(this.remoteFlow);
            this.decoratePanels(this.localFlow);
            this.decoratePanels(this.personalFlow);
            this.decoratePanels(this.defaultFlow);
            this.platformPanel.addChangeListener(this);
            this.panels = this.defaultFlow;
        }
        return this.panels;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ChangeListener changeListener = (ChangeListener)iterator.next();
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (null == this.wizard) {
            return;
        }
        if (this.wizard.getProperty(TYPE) == REMOTE) {
            this.panels = this.remoteFlow;
            this.decoratePanels(this.remoteFlow);
            this.fireChangeEvent();
        } else if (this.wizard.getProperty(TYPE) == DEFAULT) {
            this.panels = this.defaultFlow;
            this.decoratePanels(this.defaultFlow);
            this.fireChangeEvent();
        } else if (this.wizard.getProperty(TYPE) == LOCAL) {
            this.panels = this.localFlow;
            this.decoratePanels(this.localFlow);
            this.fireChangeEvent();
        } else if (this.wizard.getProperty(TYPE) == PERSONAL) {
            this.panels = this.personalFlow;
            this.decoratePanels(this.personalFlow);
            this.fireChangeEvent();
        } else {
            this.panels = this.defaultFlow;
            this.decoratePanels(this.defaultFlow);
            this.fireChangeEvent();
        }
    }

    private void decoratePanels(WizardDescriptor.Panel[] panelArray) {
        String[] stringArray = new String[panelArray.length];
        for (int i = 0; i < panelArray.length; ++i) {
            Component component = panelArray[i].getComponent();
            stringArray[i] = component.getName();
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
            jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new HashSet(1);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
    }

    public Set instantiate() throws IOException {
        InstanceProperties instanceProperties = null;
        if (null != this.wizard) {
            instanceProperties = this.createInstance();
        }
        HashSet<InstanceProperties> hashSet = new HashSet<InstanceProperties>();
        if (instanceProperties != null) {
            hashSet.add(instanceProperties);
        } else if (null != this.wizard && this.wizard.getProperty(TYPE) != PERSONAL) {
            throw new IOException(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"MSG_COULD_NOT_CREATE_INSTANCE"));
        }
        return hashSet;
    }

    private void queryForNameAndWord() {
        PasswordPanel passwordPanel = new PasswordPanel();
        passwordPanel.setPrompt(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"PROMPT_USERNAME_PASSWORD"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)passwordPanel, NbBundle.getMessage(AddDomainWizardIterator.class, (String)"TITLE_USERNAME_PASSWORD"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != NotifyDescriptor.CANCEL_OPTION) {
            this.wizard.putProperty(USER_NAME, (Object)passwordPanel.getUsername());
            this.wizard.putProperty(PASSWORD, (Object)passwordPanel.getTPassword());
        } else {
            this.wizard.putProperty(USER_NAME, (Object)BLANK);
            this.wizard.putProperty(PASSWORD, (Object)BLANK);
        }
    }

    InstanceProperties createInstance() {
        InstanceProperties instanceProperties = null;
        try {
            if (this.isValidHost((String)this.wizard.getProperty(HOST))) {
                String string;
                String string2 = (String)this.wizard.getProperty(USER_NAME);
                if (null == string2) {
                    string2 = BLANK;
                }
                if (null == (string = (String)this.wizard.getProperty(PASSWORD))) {
                    string = BLANK;
                }
                if (this.wizard.getProperty(TYPE) == PERSONAL) {
                    if (string2.trim().length() < 1 || string.trim().length() < 1) {
                        this.queryForNameAndWord();
                    }
                    if (((String)this.wizard.getProperty(USER_NAME)).trim().length() < 1 || ((String)this.wizard.getProperty(PASSWORD)).trim().length() < 8) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddDomainWizardIterator.class, (String)"ERR_Illegal_Values")));
                        return null;
                    }
                    CreateDomain createDomain = new CreateDomain(((String)this.wizard.getProperty(USER_NAME)).trim(), ((String)this.wizard.getProperty(PASSWORD)).trim());
                    createDomain.start();
                } else {
                    instanceProperties = this.createIP(string2, string);
                }
            }
        }
        catch (InstanceCreationException instanceCreationException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)instanceCreationException.getLocalizedMessage(), 1);
            message.setTitle(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"LBL_RegServerFailed"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        return instanceProperties;
    }

    private InstanceProperties createIP(String string, String string2) throws IllegalStateException, InstanceCreationException {
        String string3 = (String)this.wizard.getProperty(INSTALL_LOCATION);
        String string4 = (String)this.wizard.getProperty(PROP_DISPLAY_NAME);
        InstanceProperties instanceProperties = SunURIManager.createInstanceProperties((File)((File)this.wizard.getProperty(PLATFORM_LOCATION)), (String)((String)this.wizard.getProperty(HOST)), (String)((String)this.wizard.getProperty(PORT)), (String)string.trim(), (String)string2.trim(), (String)string4);
        instanceProperties.setProperty("httpportnumber", (String)this.wizard.getProperty(PORT));
        instanceProperties.setProperty("DOMAIN", (String)this.wizard.getProperty(DOMAIN));
        instanceProperties.setProperty("LOCATION", string3);
        if (this.wizard.getProperty(TYPE) != REMOTE) {
            String string5 = ((File)this.wizard.getProperty(PLATFORM_LOCATION)).getAbsolutePath();
            RegisterDatabase.getDefault().setupDerby(string5);
            instanceProperties.setProperty("HttpMonitorOn", Boolean.FALSE.toString());
        }
        RunTimeDDCatalog.getRunTimeDDCatalog().refresh();
        this.wizard.putProperty(USER_NAME, (Object)BLANK);
        this.wizard.putProperty(PASSWORD, (Object)BLANK);
        InstanceProperties instanceProperties2 = instanceProperties;
        return instanceProperties2;
    }

    private boolean isValidHost(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = MessageFormat.format(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"MSG_UnknownHost"), string);
            Util.showInformationWhenHolding(string2, NbBundle.getMessage(AddDomainWizardIterator.class, (String)"LBL_UnknownHost"));
        }
        return inetAddress != null;
    }

    static class InstanceType {
        InstanceType() {
        }
    }

    static class PasswordPanel
    extends JPanel {
        private static final int DEFAULT_WIDTH = 200;
        private static final int DEFAULT_HEIGHT = 0;
        static final long serialVersionUID = 1555749205340031767L;
        private JPanel mainPanel;
        private JLabel promptLabel;
        private JLabel jLabel1;
        private JTextField usernameField;
        private JLabel jLabel2;
        private JPasswordField passwordField;

        public PasswordPanel() {
            this.initComponents();
            this.usernameField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AdminAuthenticator.class).getString("ACSD_UserNameField"));
            this.passwordField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AdminAuthenticator.class).getString("ACSD_PasswordField"));
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(dimension.width, 200), Math.max(dimension.height, 0));
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
            this.promptLabel = new JLabel();
            this.promptLabel.setHorizontalAlignment(0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            this.mainPanel.add((Component)this.promptLabel, gridBagConstraints);
            this.jLabel1 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(AdminAuthenticator.class).getString("LAB_AUTH_User_Name"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 5, 12);
            gridBagConstraints.anchor = 17;
            this.mainPanel.add((Component)this.jLabel1, gridBagConstraints);
            this.usernameField = new JTextField();
            this.usernameField.setMinimumSize(new Dimension(70, 20));
            this.usernameField.setPreferredSize(new Dimension(70, 20));
            this.jLabel1.setLabelFor(this.usernameField);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.mainPanel.add((Component)this.usernameField, gridBagConstraints);
            this.jLabel2 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(AdminAuthenticator.class).getString("LAB_AUTH_Password"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.anchor = 17;
            this.mainPanel.add((Component)this.jLabel2, gridBagConstraints);
            this.passwordField = new JPasswordField();
            this.passwordField.setMinimumSize(new Dimension(70, 20));
            this.passwordField.setPreferredSize(new Dimension(70, 20));
            this.jLabel2.setLabelFor(this.passwordField);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.mainPanel.add((Component)this.passwordField, gridBagConstraints);
            this.add((Component)this.mainPanel, "Center");
        }

        String getUsername() {
            return this.usernameField.getText();
        }

        char[] getPassword() {
            return this.passwordField.getPassword();
        }

        String getTPassword() {
            return new String(this.passwordField.getPassword());
        }

        void setPrompt(String string) {
            if (string == null) {
                this.promptLabel.setVisible(false);
                this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AdminAuthenticator.class).getString("ACSD_NbAuthenticatorPasswordPanel"));
            } else {
                this.promptLabel.setVisible(true);
                this.promptLabel.setText(string);
                this.getAccessibleContext().setAccessibleDescription(string);
            }
        }
    }

    static class PDCancel
    implements Cancellable {
        private final Process p;
        private final String dirname;
        private boolean notFired = true;

        PDCancel(Process process, String string) {
            this.p = process;
            this.dirname = string;
        }

        public synchronized boolean isNotFired() {
            return this.notFired;
        }

        public synchronized boolean cancel() {
            this.notFired = false;
            this.p.destroy();
            File file = new File(this.dirname);
            if (file.exists()) {
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                try {
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    Util.showError(NbBundle.getMessage(AddDomainWizardIterator.class, (String)"ERR_Failed_cleanup", (Object)this.dirname));
                }
            }
            return true;
        }
    }

    private class CreateDomain
    extends Thread {
        private final String uname;
        private final String pword;

        CreateDomain(String string, String string2) {
            this.uname = string;
            this.pword = string2;
        }

        public void run() {
            Process process = null;
            File file = (File)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.PLATFORM_LOCATION);
            if (null != file && file.exists()) {
                String[] stringArray;
                Profile profile;
                PDCancel pDCancel = null;
                String string = file.getAbsolutePath();
                String string2 = string + File.separator + "bin" + File.separator + "asadmin";
                if ("\\".equals(File.separator)) {
                    string2 = string2 + ".bat";
                }
                String string3 = (String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.DOMAIN);
                String string4 = (String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.INSTALL_LOCATION);
                File file2 = Utils.createTempPasswordFile(this.pword, "changeit");
                if (file2 == null) {
                    return;
                }
                String[] stringArray2 = new String[]{string2, "create-domain", "--domaindir", string4, "--adminport", (String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.PORT), "--adminuser", this.uname, "--passwordfile", file2.getAbsolutePath(), "--instanceport", (String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.INSTANCE_PORT), "--domainproperties", "jms.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.JMS_PORT)).trim() + ":orb.listener.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.ORB_LISTENER_PORT)).trim() + ":http.ssl.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.HTTP_SSL_PORT)).trim() + ":orb.ssl.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.ORB_SSL_PORT)).trim() + ":orb.mutualauth.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.ORB_MUTUAL_AUTH_PORT)).trim() + ":domain.jmxPort=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.ADMIN_JMX_PORT)).trim() + ":sip.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.SIP_PORT)).trim() + ":sip.ssl.port=" + ((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.SIP_SSL_PORT)).trim(), string3};
                int n = ServerLocationManager.getAppServerPlatformVersion((File)file);
                if (n >= 910) {
                    stringArray2[6] = "--user";
                }
                if (null != (profile = (Profile)((Object)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.PROFILE))) && profile != Profile.DEFAULT) {
                    stringArray = new String[stringArray2.length + 2];
                    System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                    stringArray[stringArray.length - 1] = stringArray[stringArray.length - 3];
                    stringArray[stringArray.length - 3] = "--profile";
                    stringArray[stringArray.length - 2] = profile.value();
                    stringArray2 = stringArray;
                }
                stringArray = null;
                try {
                    ExecSupport execSupport = new ExecSupport();
                    process = Runtime.getRuntime().exec(stringArray2);
                    pDCancel = new PDCancel(process, string4 + File.separator + string3);
                    stringArray = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(AddDomainWizardIterator.class, (String)"LBL_Creating_personal_domain"), (Cancellable)pDCancel);
                    stringArray.start();
                    execSupport.displayProcessOutputs(process, NbBundle.getMessage(this.getClass(), (String)"LBL_outputtab"), NbBundle.getMessage(this.getClass(), (String)"LBL_RunningCreateDomainCommand"));
                }
                catch (MissingResourceException missingResourceException) {
                    Util.showInformation(missingResourceException.getLocalizedMessage());
                }
                catch (IOException iOException) {
                    Util.showInformation(iOException.getLocalizedMessage());
                }
                catch (InterruptedException interruptedException) {
                    Util.showInformation(interruptedException.getLocalizedMessage());
                }
                catch (RuntimeException runtimeException) {
                    Util.showInformation(runtimeException.getLocalizedMessage());
                    ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
                }
                int n2 = 0;
                if (null != process) {
                    try {
                        n2 = process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        n2 = -1;
                        ErrorManager.getDefault().notify(1, (Throwable)interruptedException);
                    }
                }
                if (null != stringArray) {
                    stringArray.finish();
                }
                if (null != pDCancel) {
                    if (0 != n2 && pDCancel.isNotFired()) {
                        Util.showError(NbBundle.getMessage(this.getClass(), (String)"WARN_DELETE_INSTANCE", (Object)((String)AddDomainWizardIterator.this.wizard.getProperty(AddDomainWizardIterator.PROP_DISPLAY_NAME))), NbBundle.getMessage(this.getClass(), (String)"WARN_DELETE_INSTANCE_TITLE"));
                    } else if (pDCancel.isNotFired()) {
                        try {
                            AddDomainWizardIterator.this.createIP(this.uname, this.pword);
                        }
                        catch (InstanceCreationException instanceCreationException) {
                            ErrorManager.getDefault().notify(1, (Throwable)instanceCreationException);
                        }
                        catch (IllegalStateException illegalStateException) {
                            ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
                        }
                    }
                }
            }
        }
    }
}

