/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext.preprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.netbeans.mobility.antext.Bundle;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.mobility.antext.preprocessor.PPLine;

public class CommentingPreProcessorTask
extends Task {
    ArrayList<FileSet> sources = null;
    File destDir = null;
    String abilities;
    String encoding = System.getProperty("file.encoding");

    public void setPreprocessFor(String string) {
        this.abilities = string;
    }

    public void setSrcDir(File file) {
        FileSet fileSet = this.createFileSet();
        fileSet.setDir(file);
        fileSet.setIncludes("**/*.java");
    }

    public FileSet createFileSet() {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        FileSet fileSet = new FileSet();
        this.sources.add(fileSet);
        return fileSet;
    }

    public void setFileSetRef(Reference reference) {
        this.createFileSet().setRefid(reference);
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void execute() throws BuildException {
        Object object;
        int n;
        if (this.sources == null) {
            throw new BuildException(Bundle.getMessage("ERR_MissingAttr", "srcDir, fileSetRef, or nested fileset"));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < this.sources.size(); ++n) {
            DirectoryScanner directoryScanner = this.sources.get(n).getDirectoryScanner(this.getProject());
            String string = directoryScanner.getBasedir().getAbsolutePath();
            object = directoryScanner.getIncludedFiles();
            for (int i = 0; i < ((String[])object).length; ++i) {
                int n2 = object[i].lastIndexOf(46);
                if (n2 < 0 || !"java".equals(object[i].substring(n2 + 1).toLowerCase())) continue;
                File file = new File(string + File.separator + (String)object[i]);
                File object2 = new File(this.destDir.getAbsolutePath() + File.separator + (String)object[i]);
                if (object2.exists() && file.lastModified() <= object2.lastModified()) continue;
                arrayList.add(file);
                arrayList.add(object2);
            }
        }
        this.log(Bundle.getMessage("MSG_PreprocessingXFiles", "" + arrayList.size() / 2, this.destDir.getAbsolutePath()), 2);
        n = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < arrayList.size()) {
            object = (File)arrayList.get(n4++);
            File file = (File)arrayList.get(n4++);
            try {
                this.log(Bundle.getMessage("MSG_PreprocessingFile", ((File)object).getAbsolutePath()), 3);
                CommentingPreProcessor commentingPreProcessor = new CommentingPreProcessor((CommentingPreProcessor.Source)new FileSource((File)object), (CommentingPreProcessor.Destination)new FileDestination(file), this.abilities);
                commentingPreProcessor.run();
                for (PPLine pPLine : commentingPreProcessor.getLines()) {
                    for (PPLine.Error error : pPLine.getErrors()) {
                        this.log(((File)object).getAbsolutePath() + ':' + error.toString(), error.warning ? 1 : 0);
                        if (error.warning) {
                            ++n3;
                            continue;
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                throw new BuildException((Throwable)exception);
            }
        }
        if (n3 > 0) {
            this.log(Bundle.getMessage("MSG_Warnings", String.valueOf(n3)), 1);
        }
        if (n > 0) {
            this.log(Bundle.getMessage("MSG_Errors", String.valueOf(n)), 0);
            throw new BuildException(Bundle.getMessage("MSG_PreprocessingError"));
        }
    }

    private final class FileDestination
    implements CommentingPreProcessor.Destination {
        private final File f;

        public FileDestination(File file) {
            this.f = file;
        }

        public void doInsert(int n, String string) throws IOException {
        }

        public void doRemove(int n, int n2, int n3) throws IOException {
        }

        public Writer createWriter(boolean bl) throws IOException {
            if (!bl) {
                return null;
            }
            this.f.getParentFile().mkdirs();
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.f), CommentingPreProcessorTask.this.encoding);
        }
    }

    private final class FileSource
    implements CommentingPreProcessor.Source {
        private final File f;

        public FileSource(File file) {
            this.f = file;
        }

        public Reader createReader() throws IOException {
            return new InputStreamReader((InputStream)new FileInputStream(this.f), CommentingPreProcessorTask.this.encoding);
        }
    }
}

