/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class DebuggerAntLogger
extends AntLogger {
    private Map runningDebuggers = new HashMap();
    private Map runningDebuggers2 = new HashMap();
    private Set filesToDebug = new HashSet();
    private Map fileExecutors = new HashMap();

    static DebuggerAntLogger getDefault() {
        for (AntLogger antLogger : Lookup.getDefault().lookup(new Lookup.Template(AntLogger.class)).allInstances()) {
            if (!(antLogger instanceof DebuggerAntLogger)) continue;
            return (DebuggerAntLogger)antLogger;
        }
        throw new InternalError();
    }

    public void buildInitializationFailed(AntEvent antEvent) {
    }

    public void buildStarted(AntEvent antEvent) {
    }

    public void buildFinished(AntEvent antEvent) {
        AntDebugger antDebugger = this.getDebugger(antEvent.getSession(), antEvent);
        if (antDebugger == null) {
            return;
        }
        antDebugger.buildFinished(antEvent);
        this.finishDebugging(antDebugger);
    }

    public void targetStarted(AntEvent antEvent) {
        AntDebugger antDebugger = this.getDebugger(antEvent.getSession(), antEvent);
        if (antDebugger == null) {
            return;
        }
        antDebugger.targetStarted(antEvent);
    }

    public void targetFinished(AntEvent antEvent) {
        AntDebugger antDebugger = this.getDebugger(antEvent.getSession(), antEvent);
        if (antDebugger == null) {
            return;
        }
        antDebugger.targetFinished(antEvent);
    }

    public void taskStarted(AntEvent antEvent) {
        AntDebugger antDebugger = this.getDebugger(antEvent.getSession(), antEvent);
        if (antDebugger == null) {
            return;
        }
        antDebugger.taskStarted(antEvent);
    }

    public void taskFinished(AntEvent antEvent) {
        AntDebugger antDebugger = this.getDebugger(antEvent.getSession(), antEvent);
        if (antDebugger == null) {
            return;
        }
        antDebugger.taskFinished(antEvent);
    }

    public void messageLogged(AntEvent antEvent) {
    }

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    public boolean interestedInScript(File file, AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return ALL_TASKS;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return new int[]{2, 4, 0, 3, 1};
    }

    void debugFile(File file) {
        this.filesToDebug.add(file);
    }

    void fileExecutor(File file, ExecutorTask executorTask) {
        this.fileExecutors.put(file, new WeakReference<ExecutorTask>(executorTask));
    }

    private void finishDebugging(AntDebugger antDebugger) {
        AntSession antSession = (AntSession)this.runningDebuggers2.remove((Object)antDebugger);
        this.runningDebuggers.remove(antSession);
    }

    private AntDebugger getDebugger(AntSession antSession, AntEvent antEvent) {
        AntDebugger antDebugger = (AntDebugger)((Object)this.runningDebuggers.get(antSession));
        if (antDebugger != null) {
            return antDebugger;
        }
        if (!this.filesToDebug.contains(antSession.getOriginatingScript())) {
            return null;
        }
        this.filesToDebug.remove(antSession.getOriginatingScript());
        Reference reference = (Reference)this.fileExecutors.remove(antSession.getOriginatingScript());
        ExecutorTask executorTask = null;
        if (reference != null) {
            executorTask = (ExecutorTask)reference.get();
        }
        try {
            FileObject fileObject = FileUtil.toFileObject((File)antSession.getOriginatingScript());
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            AntProjectCookie antProjectCookie = (AntProjectCookie)dataObject.getCookie(AntProjectCookie.class);
            if (antProjectCookie == null) {
                throw new NullPointerException();
            }
            antDebugger = DebuggerAntLogger.startDebugging(antProjectCookie, antEvent, executorTask);
            this.runningDebuggers.put(antSession, antDebugger);
            this.runningDebuggers2.put(antDebugger, antSession);
            return antDebugger;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            return null;
        }
    }

    private static AntDebugger startDebugging(AntProjectCookie antProjectCookie, final AntEvent antEvent, ExecutorTask executorTask) {
        DebuggerInfo debuggerInfo = DebuggerInfo.create((String)"AntDebuggerInfo", (Object[])new Object[]{new SessionProvider(){

            public String getSessionName() {
                return antEvent.getSession().getDisplayName();
            }

            public String getLocationName() {
                return "localhost";
            }

            public String getTypeID() {
                return "AntSession";
            }

            public Object[] getServices() {
                return new Object[0];
            }
        }, antProjectCookie});
        DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(debuggerInfo);
        AntDebugger antDebugger = (AntDebugger)((Object)debuggerEngineArray[0].lookupFirst(null, AntDebugger.class));
        antDebugger.setExecutor(executorTask);
        return antDebugger;
    }
}

